/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.google.common.base.Preconditions;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.StaticResource;
import com.jxdinfo.hussar.formdesign.desgin.form.service.StaticResourceService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class StaticResourceServiceImpl
implements StaticResourceService {
    @Value(value="${form-design.static-store-path}")
    private String staticResource;

    @Override
    public List<StaticResource> getJsFile() {
        ArrayList<StaticResource> list = new ArrayList<StaticResource>();
        File file = new File(this.staticResource);
        if (file.isDirectory()) {
            list.addAll(this.iterator(file, ".js"));
        }
        return list;
    }

    @Override
    public List<StaticResource> getCssFile() {
        ArrayList<StaticResource> list = new ArrayList<StaticResource>();
        File file = new File(this.staticResource);
        if (file.isDirectory()) {
            list.addAll(this.iterator(file, ".css"));
        }
        return list;
    }

    private List<StaticResource> iterator(File file, String type) {
        ArrayList<StaticResource> list = new ArrayList<StaticResource>();
        File[] childFiles = file.listFiles();
        if (ToolUtil.isNotEmpty((Object)childFiles)) {
            for (File f : childFiles) {
                if (f.isFile() && type.equals(this.getAfter(f.getAbsolutePath()))) {
                    String currentFile = f.getAbsolutePath().replace(File.separator, "/").replace(this.staticResource, "/").replace("//", "/");
                    String parentFile = f.getParent().replace(File.separator, "/").replace(this.staticResource, "/").replace("//", "/");
                    StaticResource resource = new StaticResource();
                    resource.setName(f.getName());
                    resource.setFilePath(currentFile);
                    resource.setParentDirectory(parentFile);
                    ArrayList<String> li = new ArrayList<String>();
                    while (new File(currentFile).getParent() != null) {
                        li.add(currentFile);
                        currentFile = new File(currentFile).getParent().replace(File.separator, "/").replace(this.staticResource, "/").replace("//", "/");
                    }
                    resource.setModel(li);
                    list.add(resource);
                    continue;
                }
                list.addAll(this.iterator(f, type));
            }
        }
        return list;
    }

    private String getAfter(String longPath) {
        Preconditions.checkNotNull((Object)longPath);
        String fileName = new File(longPath).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex);
    }

    @Override
    public String getCertainStaticResource(String path) throws IOException {
        String content = "";
        String realPath = this.staticResource + path.replace("/", File.separator);
        File file = new File(realPath);
        if (file.isFile()) {
            content = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8"));
        }
        return content;
    }
}

