/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.jxdinfo.hussar.formdesign.desgin.form.service.ResourcesService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ResourcesServiceImpl
implements ResourcesService {
    @Value(value="${form-design.static-store-path}")
    private String staticPath;
    @Value(value="${form-design.exclude-css}")
    private String excludeCss;
    @Value(value="${form-design.exclude-js}")
    private String excludeJs;
    @Value(value="${form-design.exclude-image}")
    private String excludeImage;
    @Value(value="${form-design.image-type}")
    private String imageType;
    private String[] excludeCsss;
    private String[] excludeJss;
    private String[] excludeImages;
    private String[] imageTypes;
    private List<Map<String, String>> cssPaths;
    private List<Map<String, String>> scriptPaths;
    private List<Map<String, String>> imagePaths;
    @Value(value="${form-design.project-path}")
    private String projectPath;

    @Override
    public List getCssResources() {
        this.excludeCsss = this.excludeCss.split(",");
        this.cssPaths = new ArrayList<Map<String, String>>();
        File baseFile = new File(this.projectPath + this.staticPath);
        this.getCssFile(baseFile);
        return this.cssPaths;
    }

    public void getCssFile(File file) {
        File[] files = file.listFiles();
        if (null != files && files.length > 0) {
            this.itorCssFile(files);
        }
    }

    public void itorCssFile(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().indexOf(".css") != -1) {
                boolean put = true;
                for (String str : this.excludeCsss) {
                    str = str.replace("/", File.separator);
                    if (file.getPath().indexOf(str) == -1) continue;
                    put = false;
                    break;
                }
                if (!put) continue;
                HashMap<String, String> retMap = new HashMap<String, String>();
                retMap.put("url", file.getAbsolutePath().replace(this.projectPath, "").replace(File.separator, "/"));
                this.cssPaths.add(retMap);
                continue;
            }
            File[] listFiles = file.listFiles();
            if (null == listFiles || listFiles.length <= 0) continue;
            this.itorCssFile(listFiles);
        }
    }

    @Override
    public List getScriptResources() {
        this.excludeJss = this.excludeJs.split(",");
        this.scriptPaths = new ArrayList<Map<String, String>>();
        File baseFile = new File(this.projectPath + this.staticPath);
        this.getScriptFile(baseFile);
        return this.scriptPaths;
    }

    public void getScriptFile(File file) {
        File[] files = file.listFiles();
        if (null != files && files.length > 0) {
            this.itorScriptFile(files);
        }
    }

    public void itorScriptFile(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().indexOf(".js") != -1) {
                boolean put = true;
                for (String str : this.excludeJss) {
                    str = str.replace("/", File.separator);
                    if (file.getPath().indexOf(str) == -1) continue;
                    put = false;
                    break;
                }
                if (!put) continue;
                HashMap<String, String> retMap = new HashMap<String, String>();
                retMap.put("url", file.getAbsolutePath().replace(this.projectPath, "").replace(File.separator, "/"));
                this.scriptPaths.add(retMap);
                continue;
            }
            File[] listFiles = file.listFiles();
            if (null == listFiles || listFiles.length <= 0) continue;
            this.itorScriptFile(listFiles);
        }
    }

    @Override
    public List getImageResources() {
        this.excludeImages = this.excludeImage.split(",");
        this.imageTypes = this.imageType.split(",");
        this.imagePaths = new ArrayList<Map<String, String>>();
        File baseFile = new File(this.projectPath + this.staticPath);
        this.getImageFile(baseFile);
        return this.imagePaths;
    }

    public void getImageFile(File file) {
        File[] files = file.listFiles();
        if (null != files && files.length > 0) {
            this.itorImageFile(files);
        }
    }

    public void itorImageFile(File[] files) {
        for (File file : files) {
            if (file.isFile()) {
                boolean isImage = false;
                for (String type : this.imageTypes) {
                    if (file.getName().toUpperCase().indexOf(type.toUpperCase()) == -1) continue;
                    isImage = true;
                    break;
                }
                if (!isImage) continue;
                boolean put = true;
                for (String str : this.excludeImages) {
                    str = str.replace("/", File.separator);
                    if (file.getPath().indexOf(str) == -1) continue;
                    put = false;
                    break;
                }
                if (!put) continue;
                HashMap<String, String> tmp = new HashMap<String, String>();
                tmp.put("name", file.getName());
                tmp.put("path", file.getAbsolutePath().replace((this.projectPath + this.staticPath).replace("/", File.separator), "/static").replace(File.separator, "/"));
                this.imagePaths.add(tmp);
                continue;
            }
            File[] listFiles = file.listFiles();
            if (null == listFiles || listFiles.length <= 0) continue;
            this.itorImageFile(listFiles);
        }
    }
}

