/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.Page;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageTreeNodeService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.impl.PageServiceImpl;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.PageTreeNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Repository;

@Repository
public class PageTreeNodeServiceImpl
extends PageServiceImpl
implements PageTreeNodeService<PageTreeNode> {
    @Override
    public List<PageTreeNode> listFileTreeNode(String projectPath) throws IOException {
        File file = new File(projectPath);
        ArrayList<PageTreeNode> retList = new ArrayList<PageTreeNode>();
        if (null != file.listFiles() && file.listFiles().length != 0) {
            this.itorFile(file.listFiles(), retList, "", "");
        }
        return retList;
    }

    @Override
    public String updateTableInfo(Page page, String rootPath) throws IOException {
        JSONObject newData = JSONObject.parseObject((String)page.getData());
        List newArray = newData.getJSONObject("table").getJSONArray("fields").toJavaList(JSONObject.class);
        List oldArray = null;
        File file = new File(rootPath + page.getPath());
        if (file.exists()) {
            JSONObject oldData = null;
            String oldStr = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (ToolUtil.isNotEmpty((Object)oldStr)) {
                oldData = JSONObject.parseObject((String)oldStr);
            }
            if (ToolUtil.isNotEmpty(oldData)) {
                oldArray = oldData.getJSONObject("table").getJSONArray("fields").toJavaList(JSONObject.class);
            }
            if (ToolUtil.isNotEmpty(oldArray)) {
                for (JSONObject oldJsonObject : oldArray) {
                    String oldFieldName = oldJsonObject.getString("name");
                    for (JSONObject newJsonObject : newArray) {
                        String newFieldName = newJsonObject.getString("name");
                        if (!oldFieldName.equals(newFieldName)) continue;
                        for (Map.Entry stringObjectEntry : newJsonObject.entrySet()) {
                            String entry = (String)stringObjectEntry.getKey();
                            if (!ToolUtil.isNotEmpty((Object)oldJsonObject.get((Object)entry)) || "type".equals(entry) || "primarys".equals(entry) || "comment".equals(entry) || "tablename".equals(entry) || "realName".equals(entry)) continue;
                            newJsonObject.put(entry, oldJsonObject.get((Object)entry));
                        }
                    }
                }
            }
        }
        String newDataStr = JSON.toJSONString((Object)newData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        page.setData(newDataStr);
        Object jsonObject = JSONObject.parse((String)page.getData());
        if (ToolUtil.isEmpty((Object)jsonObject)) {
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
        } else {
            FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject), (String)"UTF-8", (boolean)false);
        }
        return newDataStr;
    }

    private void itorFile(File[] files, List<PageTreeNode> retList, String parentId, String parentPath) throws IOException {
        for (File file : files) {
            File mataFile;
            if (file.getName().contains(".meta") || !(mataFile = new File(file.getAbsolutePath() + ".meta")).exists()) continue;
            PageTreeNode tmp = (PageTreeNode)JSON.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"utf-8"), PageTreeNode.class);
            if (("/" + tmp.getName()).equals(tmp.getPath()) || ("/" + tmp.getName() + ".vpd").equals(tmp.getPath()) || ("/" + tmp.getName() + ".wfd").equals(tmp.getPath()) || ("/" + tmp.getName() + ".dbd").equals(tmp.getPath())) {
                tmp.setParent("#");
                tmp.setParentPath("/");
            } else {
                tmp.setParent(parentId);
                tmp.setParentPath(parentPath);
            }
            if (mataFile.isFile() && "table".equals(tmp.getType())) {
                tmp.setData(FileUtils.readFileToString((File)file, (String)"UTF-8"));
            }
            retList.add(tmp);
            if (null == file.listFiles() || file.listFiles().length == 0) continue;
            this.itorFile(file.listFiles(), retList, tmp.getId(), tmp.getPath());
        }
    }
}

