/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.baomidou.mybatisplus.generator.formdesign.config.po.TableField;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableInfo;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.core.util.MD5UtilDIY;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.PageTemplate;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageTemplateService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.TemplateService;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.service.TableInfoService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class PageTemplateServiceImpl
implements PageTemplateService {
    @Value(value="${form-design.template-store-path}")
    private String templateStorePath;
    @Value(value="${form-design.project-path}")
    private String rawCodeProjectPath;
    @Resource
    private TemplateService templateService;
    @Resource
    private TableInfoService tableInfoService;

    @Override
    public List<PageTemplate> getAllTemplates() {
        File file = new File(this.rawCodeProjectPath + this.templateStorePath);
        ArrayList<PageTemplate> list = new ArrayList<PageTemplate>();
        File rootFile = new File(this.templateStorePath);
        String rootFiles = rootFile.getAbsolutePath();
        File[] files = file.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            for (File f : files) {
                if (f.isDirectory()) {
                    File[] childFiles = f.listFiles();
                    if (!ToolUtil.isNotEmpty((Object)childFiles)) continue;
                    for (File fi : childFiles) {
                        if (!fi.isFile()) continue;
                        PageTemplate pageTemplate = new PageTemplate();
                        String name = fi.getName();
                        pageTemplate.setId(MD5Util.encrypt((String)f.getAbsolutePath()));
                        pageTemplate.setName(name.substring(0, name.lastIndexOf(".")));
                        String relativePath = fi.getAbsolutePath().replace(File.separator, "/").replace(rootFiles, "/");
                        pageTemplate.setFilePath(relativePath.replace("//", "/"));
                        String parentRelativePath = fi.getParent().replace(File.separator, "/").replace(rootFiles, "/");
                        pageTemplate.setCategory(parentRelativePath.replace("//", "/"));
                        pageTemplate.setId(MD5UtilDIY.encrypt((String)pageTemplate.getFilePath()).substring(8, 24));
                        list.add(pageTemplate);
                    }
                    continue;
                }
                PageTemplate pageTemplate = new PageTemplate();
                String name = f.getName();
                pageTemplate.setId(MD5Util.encrypt((String)f.getAbsolutePath()));
                pageTemplate.setName(name.substring(0, name.lastIndexOf(".")));
                String relativePath = f.getAbsolutePath().replace(File.separator, "/").replace(rootFiles, "/");
                pageTemplate.setFilePath(relativePath.replace("//", "/"));
                String parentRelativePath = f.getParent().replace(File.separator, "/").replace(rootFiles, "/");
                pageTemplate.setCategory(parentRelativePath.replace("//", "/"));
                list.add(pageTemplate);
            }
        } else {
            return list;
        }
        return list;
    }

    @Override
    public String getTemplateContent(String path, String tableName) throws IOException {
        List<Map<String, Object>> tables = this.tableInfoService.getAllTablesByTableName();
        TableInfo tableInfo = new TableInfo();
        tables.forEach(table -> {
            if (table != null && table.get("name").equals(tableName)) {
                tableInfo.setName(String.valueOf(table.get("name")));
                tableInfo.setComment(String.valueOf(table.get("comment")));
                ArrayList tableFields = new ArrayList();
                if (table.get("fields") != null) {
                    List fields = (List)table.get("fields");
                    fields.forEach(field -> {
                        TableField tableField = new TableField();
                        tableField.setName(String.valueOf(field.get("name")));
                        tableField.setComment(String.valueOf(field.get("comment")));
                        tableField.setType(String.valueOf(field.get("type")));
                        tableFields.add(tableField);
                    });
                }
                tableInfo.setFields(tableFields);
            }
        });
        return this.templateService.genPageFromTemplate(tableInfo, path);
    }
}

