/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.Files;
import com.jxdinfo.hussar.core.util.CamelUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentPageDto;
import com.jxdinfo.hussar.formdesign.desgin.form.model.Page;
import com.jxdinfo.hussar.formdesign.desgin.form.model.WebComponentInstance;
import com.jxdinfo.hussar.formdesign.desgin.form.model.WebPage;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.impl.BaseFileServiceImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;

public class PageServiceImpl
extends BaseFileServiceImpl<Page>
implements PageService {
    @Value(value="${form-design.module-store-path}")
    private String moduleStorePath;
    private String pageSuffix = "vpd";
    private String pageTreeNodeTypePage = "page";
    private String pageTreeNodeTypeModule = "module";
    @Value(value="${form-design.project-path}")
    private String rawCodeProjectPath;
    @Value(value="${form-design.meta-suffix}")
    private String metaSuffix = "meta";
    @Value(value="${form-design.project-name}")
    private String projectName;

    @Override
    public WebPage parserPage(String path, String rootPath) throws IOException {
        WebPage page = new WebPage();
        File file = new File(this.relativeToAbsolute(path, rootPath));
        page.setName(Files.getNameWithoutExtension((String)file.getName()));
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
            StringBuilder sb = new StringBuilder();
            String line = "";
            do {
                sb.append(line);
            } while ((line = br.readLine()) != null);
            JSONObject jsonObject = JSONObject.parseObject((String)sb.toString());
            page.setInstances(new HashMap<String, WebComponentInstance>());
            JSONObject viewportJsonObject = jsonObject;
            JSONObject instancesJsonObj = viewportJsonObject.getJSONObject("instances");
            String rootInstanceKey = viewportJsonObject.getString("rootInstanceKey");
            page.setRootInstanceKey(rootInstanceKey);
            for (Map.Entry iEntry : instancesJsonObj.entrySet()) {
                JSONObject instanceJsonObj = (JSONObject)iEntry.getValue();
                String styles = instanceJsonObj.getString("style");
                styles = CamelUtil.camelToline((String)styles);
                instanceJsonObj.put("style", JSON.parse((String)styles));
                WebComponentInstance instance = new WebComponentInstance();
                instance.setInstanceKey(instanceJsonObj.getString("instanceKey"));
                instance.setId(instanceJsonObj.getString("id"));
                instance.setName(instanceJsonObj.getString("name"));
                instance.setParentInstanceKey(instanceJsonObj.getString("parentInstanceKey"));
                instance.setIndex(instanceJsonObj.getString("index"));
                JSONArray childrenJsonArray = instanceJsonObj.getJSONArray("children");
                if (childrenJsonArray != null) {
                    ArrayList<String> children = new ArrayList<String>();
                    for (Object o : childrenJsonArray) {
                        String child = (String)o;
                        children.add(child);
                    }
                    instance.setChildren(children);
                }
                instance.setStyle(new HashMap<String, String>());
                for (Map.Entry entry : instanceJsonObj.getJSONObject("style").entrySet()) {
                    instance.getStyle().put((String)entry.getKey(), (String)entry.getValue());
                }
                instance.setComputedStyle(new HashMap<String, String>());
                for (Map.Entry entry : instanceJsonObj.getJSONObject("computedStyle").entrySet()) {
                    instance.getComputedStyle().put((String)entry.getKey(), (String)entry.getValue());
                }
                instance.setClassName((String)instanceJsonObj.get((Object)"className"));
                instance.setEditingClassName((String)instanceJsonObj.get((Object)"editingClassName"));
                instance.setProps(new HashMap<String, String>());
                for (Map.Entry entry : instanceJsonObj.getJSONObject("props").entrySet()) {
                    instance.getProps().put((String)entry.getKey(), entry.getValue().toString());
                }
                instance.setEvents(new HashMap<String, String>());
                for (Map.Entry entry : instanceJsonObj.getJSONObject("events").entrySet()) {
                    instance.getEvents().put((String)entry.getKey(), entry.getValue().toString());
                }
                instance.setVariables(new HashMap<String, String>());
                for (Map.Entry entry : instanceJsonObj.getJSONObject("variables").entrySet()) {
                    instance.getVariables().put((String)entry.getKey(), entry.getValue().toString());
                }
                page.getInstances().put((String)iEntry.getKey(), instance);
            }
            return page;
        }
        return null;
    }

    @Override
    public ComponentPageDto readPageVPD(String path) throws IOException {
        path = this.rawCodeProjectPath + this.moduleStorePath + path;
        File pageVpd = new File(path);
        String pageString = FileUtils.readFileToString((File)pageVpd, (String)"utf-8");
        File pageVpdMeta = new File(path + ".meta");
        String pageMetaString = FileUtils.readFileToString((File)pageVpdMeta, (String)"utf-8");
        Page page = (Page)JSONObject.parseObject((String)pageMetaString, Page.class);
        ComponentPageDto componentPageDto = (ComponentPageDto)JSONObject.parseObject((String)pageString, ComponentPageDto.class);
        componentPageDto.setPage(page);
        return componentPageDto;
    }

    @Override
    public Page get(String path, String rootPath) throws IOException {
        return this.readFileToObject((rootPath + path).replace("/", File.separator), path);
    }

    private Page readFileToObject(String absolutePath, String path) throws IOException {
        HashMap map = new HashMap(3);
        File file = new File(absolutePath);
        File fileOfMeta = new File(this.addMeta(absolutePath));
        String info = FileUtils.readFileToString((File)fileOfMeta, (String)"UTF-8");
        Page t = (Page)JSON.parseObject((String)info, Page.class);
        String data = FileUtils.readFileToString((File)file, (String)"UTF-8");
        t.setData(data);
        t.setPath(path);
        return t;
    }
}

