/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.BaseFile;
import com.jxdinfo.hussar.formdesign.desgin.form.service.ModularService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class ModularServiceImpl<T extends BaseFile>
implements ModularService<T> {
    @Override
    public void createDirectory(BaseFile baseFile, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        if (file.exists()) {
            throw new FileExistsException();
        }
        FileUtils.forceMkdir((File)file);
        File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
        FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)baseFile), (String)"UTF-8", (boolean)false);
    }

    @Override
    public void copyDirectory(T baseFile, String dstPath, String rootPath) throws IOException {
        File from = new File(this.relativeToAbsolute(((BaseFile)baseFile).getPath(), rootPath));
        File to = new File(this.relativeToAbsolute(dstPath, rootPath));
        FileUtils.copyDirectory((File)from, (File)to);
        File meatFile = new File(this.addMeta(to.getParentFile() + File.separator + to.getName()));
        FileUtils.copyFile((File)new File(this.addMeta(from.getAbsolutePath())), (File)meatFile, (boolean)false);
        JSONObject jsonObject = (JSONObject)JSON.parse((String)FileUtils.readFileToString((File)meatFile, (String)"utf-8"));
        jsonObject.put("path", (Object)dstPath);
        jsonObject.put("name", (Object)((BaseFile)baseFile).getName());
        jsonObject.put("desc", (Object)((BaseFile)baseFile).getDesc());
        FileUtils.writeStringToFile((File)meatFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"utf-8");
        this.updateMetaData(to, rootPath);
    }

    @Override
    public void deleteDirectory(T baseFile, String rootPath) throws IOException {
        File f = new File(this.relativeToAbsolute(((BaseFile)baseFile).getPath(), rootPath));
        FileUtils.forceDelete((File)f);
        FileUtils.forceDelete((File)new File(this.addMeta(f.getAbsolutePath())));
    }

    @Override
    public void updateDirectory(T baseFile, String rootPath) throws IOException {
        File file = new File(this.addMeta(this.relativeToAbsolute(((BaseFile)baseFile).getPath(), rootPath)));
        FileUtils.writeStringToFile((File)file, (String)JSON.toJSONString(baseFile), (String)"UTF-8", (boolean)false);
    }

    @Override
    public void moveDirectory(T baseFile, String dstPath, String rootPath, String suffix) throws IOException {
        this.renameDirectory((BaseFile)baseFile, ((BaseFile)baseFile).getName(), rootPath, suffix);
        File from = new File(this.relativeToAbsolute(((BaseFile)baseFile).getPath(), rootPath));
        File fromFile = new File(from.getParentFile().getPath() + File.separator + ((BaseFile)baseFile).getName());
        File mixFileMeta = new File(this.addMeta(fromFile.getPath()));
        File to = new File(this.relativeToAbsolute(dstPath, rootPath));
        FileUtils.moveDirectoryToDirectory((File)fromFile, (File)to.getParentFile(), (boolean)false);
        FileUtils.moveFileToDirectory((File)mixFileMeta, (File)to.getParentFile(), (boolean)false);
        this.updateMetaPath(to, rootPath);
    }

    @Override
    public void renameDirectory(BaseFile baseFile, String newName, String rootPath, String suffix) throws IOException {
        File f2;
        File f = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        if (!f.renameTo(f2 = new File(f.getParentFile().getPath() + File.separator + newName + suffix))) {
            throw new IOException("\u6587\u4ef6\u5df2\u5b58\u5728");
        }
        File fileOld = new File(this.addMeta(rootPath + baseFile.getPath()).replace("/", File.separator));
        this.fixName(fileOld.getAbsolutePath(), this.addMeta(fileOld.getParentFile().getAbsolutePath() + File.separator + newName + suffix));
        File newMeta = new File(this.addMeta(fileOld.getParentFile().getAbsolutePath() + File.separator + newName + suffix));
        JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)newMeta, (String)"utf-8"));
        jsonObject.put("path", (Object)(f.getParentFile().getPath().replace(rootPath.replace("/", File.separator), "") + File.separator + newName + suffix).replace(File.separator, "/"));
        jsonObject.put("name", (Object)newName);
        if (baseFile.getDesc() != null) {
            jsonObject.put("desc", (Object)baseFile.getDesc());
        }
        FileUtils.writeStringToFile((File)newMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8", (boolean)false);
        this.updateMetaPath(f2, rootPath);
    }

    @Override
    public List<T> listDirectory(String path, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(path, rootPath));
        ArrayList<T> list = new ArrayList<T>();
        File[] files = file.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            for (File f : files) {
                if (!f.isDirectory()) continue;
                path = f.getAbsolutePath().replace(new File(rootPath).getAbsolutePath() + File.separator, "/").replace("//", "/");
                T t = this.readDirectoryToObject(f.getAbsolutePath(), path);
                list.add(t);
            }
        }
        return list;
    }

    private T readDirectoryToObject(String absolutePath, String path) throws IOException {
        File fileOfMeta = new File(this.addMeta(absolutePath));
        String info = FileUtils.readFileToString((File)fileOfMeta, (String)"UTF-8");
        BaseFile t = (BaseFile)JSON.parseObject((String)info, (Type)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0], (Feature[])new Feature[0]);
        t.setData("");
        t.setPath(path);
        return (T)t;
    }

    private void fixName(String oldFile, String newFile) throws IOException {
        File fileOld = new File(oldFile);
        File fileNew = new File(newFile);
        if (!fileOld.renameTo(fileNew)) {
            throw new IOException("\u6587\u4ef6\u5df2\u5b58\u5728");
        }
    }

    private void updateMetaData(File file, String rootPath) throws IOException {
        if (!file.isFile()) {
            this.updateMetaDataItor(file, rootPath);
        }
    }

    private String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + relativePath).replace("/", File.separator);
    }

    private String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator);
        return real + ".meta";
    }

    private void updateMetaDataItor(File file, String rootPath) throws IOException {
        if (!file.getName().contains(".meta")) {
            File metaFile = new File(this.addMeta(file.getAbsolutePath()));
            JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"utf-8"));
            jsonObject.put("path", (Object)this.replacePathForRelatPath(file.getPath(), rootPath));
            jsonObject.put("id", (Object)IdWorker.get32UUID());
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"utf-8");
            File[] files = file.listFiles();
            if (null != files && files.length > 0) {
                for (File tmp : files) {
                    this.updateMetaDataItor(tmp, rootPath);
                }
            }
        }
    }

    private void updateMetaPath(File file, String rootPath) throws IOException {
        if (!file.isFile()) {
            this.updateMetaPathItor(file, rootPath);
        }
    }

    private void updateMetaPathItor(File file, String rootPath) throws IOException {
        if (!file.getName().contains(".meta")) {
            File metaFile = new File(this.addMeta(file.getAbsolutePath()));
            JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"utf-8"));
            jsonObject.put("path", (Object)this.replacePathForRelatPath(file.getPath(), rootPath.replace("/", File.separator)));
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"utf-8");
            File[] files = file.listFiles();
            if (null != files && files.length > 0) {
                for (File tmp : files) {
                    this.updateMetaPathItor(tmp, rootPath);
                }
            }
        }
    }

    private String replacePathForRelatPath(String absolutePath, String rootPath) {
        return absolutePath.replace(rootPath.replace("/", File.separator), "").replace(File.separator, "/");
    }
}

