/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.CommonStyleConfig;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.CommonStyleItem;
import com.jxdinfo.hussar.formdesign.desgin.form.model.BaseFile;
import com.jxdinfo.hussar.formdesign.desgin.form.service.CommonStyleService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.impl.BaseFileServiceImpl;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class CommonStyleServiceImpl
extends BaseFileServiceImpl<BaseFile>
implements CommonStyleService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void genCommonCss(BaseFile file, String rootPath, String cssCodePath) throws IOException, CompilationException {
        Object fileWithData;
        List styleConfigs;
        HashMap<String, String> variables = new HashMap<String, String>();
        ArrayList<String> variableOrder = new ArrayList<String>();
        InputStream in = this.getClass().getResourceAsStream("/template/_variables.scss");
        if (in != null) {
            try {
                char[] variableContent = IOUtils.toCharArray((InputStream)in, (Charset)Charset.forName("UTF-8"));
                StringBuilder key = new StringBuilder();
                StringBuilder value = new StringBuilder();
                int state = 0;
                for (int i = 0; i < variableContent.length; ++i) {
                    if (state == 0) {
                        if (variableContent[i] == '/') {
                            if (i + 1 < variableContent.length && variableContent[i + 1] == '*') {
                                ++i;
                                state = 1;
                            } else {
                                key.append(variableContent[i]);
                            }
                        } else if (variableContent[i] == ':' && key.length() == 0 || variableContent[i] == '\n' || variableContent[i] == '\r') {
                            state = 10;
                        } else if (variableContent[i] == ':') {
                            state = 2;
                        } else {
                            key.append(variableContent[i]);
                        }
                    } else if (state == 1) {
                        if (variableContent[i] == '*' && i + 1 < variableContent.length && variableContent[i + 1] == '/') {
                            state = 0;
                        }
                    } else if (state == 2) {
                        if (variableContent[i] == '/') {
                            if (i + 1 < variableContent.length && variableContent[i + 1] == '*') {
                                ++i;
                                state = 3;
                            } else {
                                value.append(variableContent[i]);
                            }
                        } else if ((variableContent[i] == '\n' || variableContent[i] == '\r') && value.length() == 0) {
                            state = 10;
                        } else if (variableContent[i] == '\r' || variableContent[i] == '\n') {
                            state = 100;
                        } else {
                            value.append(variableContent[i]);
                            if (i == variableContent.length - 1) {
                                state = 100;
                            }
                        }
                    } else if (state == 3) {
                        if (variableContent[i] == '*' && i + 1 < variableContent.length && variableContent[i + 1] == '/') {
                            state = 2;
                        }
                    } else if (state == 10) {
                        state = 0;
                        key.delete(0, key.length());
                        value.delete(0, value.length());
                    }
                    if (state != 100) continue;
                    state = 0;
                    if (value.charAt(value.length() - 1) != ';') {
                        value.append(";");
                    }
                    variables.put(key.toString(), value.toString());
                    variableOrder.add(key.toString());
                    key.delete(0, key.length());
                    value.delete(0, value.length());
                    --i;
                }
            }
            finally {
                in.close();
            }
        }
        if ((styleConfigs = (List)JSONObject.parseObject((String)((BaseFile)(fileWithData = super.get(file.getPath(), rootPath))).getData(), (TypeReference)new TypeReference<List<CommonStyleConfig>>(){}, (Feature[])new Feature[0])) != null) {
            for (CommonStyleConfig config : styleConfigs) {
                if (config.getStyles() == null || config.getDefaultCss() == null) continue;
                for (CommonStyleItem item : config.getStyles()) {
                    if (item.getChildren() != null) {
                        for (CommonStyleItem styleItem : item.getChildren()) {
                            this.confirmVariables(variables, config, styleItem);
                        }
                        continue;
                    }
                    this.confirmVariables(variables, config, item);
                }
            }
        }
        StringBuilder scssCode = new StringBuilder();
        for (String varKey : variableOrder) {
            scssCode.append(varKey).append(":").append((String)variables.get(varKey)).append("\n");
        }
        in = this.getClass().getResourceAsStream("/template/css-layui.scss");
        if (in != null) {
            String scssTem = IOUtils.toString((InputStream)in, (Charset)Charset.forName("UTF-8"));
            scssCode.append(scssTem);
        }
        Compiler compiler = new Compiler();
        Output output = compiler.compileString(scssCode.toString(), new Options());
        String result = output.getCss();
        File outputFile = new File((cssCodePath + File.separator + file.getPath() + ".css").replace("/", File.separator));
        File outputCompileFile = new File(this.getClass().getClassLoader().getResource("").getPath() + ("static/css/" + file.getPath() + ".css").replace("/", File.separator));
        FileUtils.writeStringToFile((File)outputFile, (String)result, (String)"utf-8");
        FileUtils.writeStringToFile((File)outputCompileFile, (String)result, (String)"utf-8");
    }

    private void confirmVariables(Map<String, String> variables, CommonStyleConfig config, CommonStyleItem item) {
        String field = item.getField();
        if ("width".equals(field) || "height".equals(field)) {
            return;
        }
        String fieldValue = config.getDefaultCss().getOrDefault(field, "");
        if (variables.containsKey(item.getVars())) {
            if (fieldValue.charAt(fieldValue.length() - 1) != ';') {
                fieldValue = fieldValue + ";";
            }
            variables.put(item.getVars(), fieldValue);
        }
    }
}

