/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.configration.DesignConfig;
import com.jxdinfo.hussar.formdesign.contant.TableQueryConditionType;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentLibsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentPageDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.GenCodePreData;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.InstanceDataFiledDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.PageAPIDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.RequestData;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.BaseCellImplUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.FormRelatedUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.dto.WebJsCode;
import com.jxdinfo.hussar.formdesign.desgin.form.dto.WebPageCode;
import com.jxdinfo.hussar.formdesign.desgin.form.service.CodeGenService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.ComponentService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageService;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenJavaScriptCode;
import com.jxdinfo.hussar.formdesign.result.GenCodeResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeGenServiceImpl
implements CodeGenService {
    private static final Logger log = LoggerFactory.getLogger(CodeGenServiceImpl.class);
    @Autowired
    private ComponentService componentService;
    @Autowired
    private PageService pageService;
    @Autowired
    private DesignConfig designConfig;
    private String pageColor;
    private String pageHeight;
    private String pageName;
    private GroupTemplate groupTemplate;

    public CodeGenServiceImpl() throws IOException {
        Properties properties = new Properties();
        properties.put("RESOURCE.root", "");
        properties.put("DELIMITER_STATEMENT_START", "<%");
        properties.put("DELIMITER_STATEMENT_END", "%>");
        properties.put("HTML_TAG_FLAG", "##");
        Configuration cfg = new Configuration(properties);
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("template/");
        this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        this.groupTemplate.registerFunctionPackage("tool", (Object)new ToolUtil());
    }

    @Override
    public GenCodeResult generateCode(String path, String rootPath, String projectPath, GenCodePreData genCodePreData) throws Exception {
        String htmlPath = (this.designConfig.getProjectPath() + this.designConfig.getPageCodeStorePath()).replace("/", File.separator);
        boolean isNginx = this.designConfig.isNginx();
        String jsPath = (this.designConfig.getProjectPath() + this.designConfig.getJsCodeStorePath()).replace("/", File.separator);
        String jsRelativePath = "${ctxPath}/static/js" + path.replace(".vpd", ".js") + "?version=" + System.currentTimeMillis();
        if (isNginx) {
            jsPath = (this.designConfig.getProjectPath() + this.designConfig.getJsCodeStorePath() + this.designConfig.getNginxJsAlias()).replace("/", File.separator);
            jsRelativePath = "${ctxPath}/static/js" + this.designConfig.getNginxJsAlias() + path.replace(".vpd", ".js") + "?version=" + System.currentTimeMillis();
        }
        File file = new File(htmlPath + File.separator + path.replace(".vpd", ".html"));
        File jsFile = new File(jsPath + File.separator + path.replace(".vpd", ".js"));
        String compileHtmlPath = this.getClass().getClassLoader().getResource("").getPath() + "WEB-INF/view/".replace("/", File.separator) + path.replace(".vpd", ".html");
        File compileFile = new File(compileHtmlPath);
        WebPageCode webPageCode = new WebPageCode();
        WebJsCode webJsCode = new WebJsCode();
        ComponentPageDto componentPageDto = this.pageService.readPageVPD(projectPath + this.designConfig.getPageStorePath() + path);
        this.parserExistContent(file, webPageCode, componentPageDto);
        this.pageColor = componentPageDto.getPage().getPageColor();
        this.pageHeight = componentPageDto.getPage().getPageHeight();
        Boolean autoHeight = componentPageDto.getPage().getAutoHeight();
        this.pageName = componentPageDto.getPage().getDesc();
        if (this.pageName != null && !"".equals(this.pageName)) {
            webPageCode.setTitle(this.pageName);
        } else {
            webPageCode.setTitle(componentPageDto.getPage().getName());
        }
        StringBuilder style = new StringBuilder();
        if (this.pageColor != null && !"".equals(this.pageColor)) {
            style.append("background-color:").append(this.pageColor).append(";");
        }
        if (!autoHeight.booleanValue() && this.pageHeight != null && !"".equals(this.pageHeight)) {
            style.append("height:").append(this.pageHeight).append("px;");
            style.append("position:relative");
        }
        if (style.length() > 0) {
            webPageCode.setPageStyle(style.toString());
        }
        Map<String, ComponentDto> componentDtoMap = componentPageDto.getInstances();
        String rootInstanceKey = componentPageDto.getRootInstanceKey();
        ComponentDto rootInstanceObj = componentDtoMap.get(rootInstanceKey);
        List<ComponentLibsDto> componentLibsDtos = this.componentService.getComponentsJson().getLibs();
        ArrayList<String> compentsDepens = new ArrayList<String>();
        StringBuilder preloadDataCellsScript = new StringBuilder(1024);
        StringBuilder cellsScript = new StringBuilder(1024);
        StringBuilder cellEvents = new StringBuilder(1024);
        StringBuilder cellCSS = new StringBuilder();
        List<String> formKeys = rootInstanceObj.getChildren();
        ArrayList<String> waitForRemove = new ArrayList<String>();
        for (String string : formKeys) {
            String realParentKey;
            ComponentDto componentDto = componentDtoMap.get(string);
            if (!"iHidden".equals(componentDto.getName()) || (realParentKey = (String)componentDto.getProps().get("relatedForm")) == null || "".equals(realParentKey)) continue;
            waitForRemove.add(string);
            ComponentDto componentDto2 = componentDtoMap.get(realParentKey);
            if (componentDto2 == null) continue;
            componentDto2.getChildren().add(componentDto.getInstanceKey());
        }
        for (String string : waitForRemove) {
            formKeys.remove(string);
        }
        this.resortChildren(formKeys, componentDtoMap);
        StringBuilder cellsHtml = new StringBuilder(1024);
        for (ComponentDto componentDto : componentDtoMap.values()) {
            String comName = componentDto.getName();
            for (ComponentLibsDto componentLibsDto : componentLibsDtos) {
                String prefix = componentLibsDto.getPrefix();
                if (comName.indexOf(prefix) != 0) continue;
                for (ComponentDto componentDto3 : componentLibsDto.getComponents()) {
                    if (!comName.equals(prefix + componentDto3.getName())) continue;
                    componentDto.setImplInstance(componentDto3.getImplInstance());
                    componentDto.setElementTag(componentDto3.getElementTag());
                    componentDto.setDependentModules(componentDto3.getDependentModules());
                    if (null == componentDto3.getDependentModules()) continue;
                    componentDto.setImplInstance(componentDto3.getImplInstance());
                    compentsDepens.addAll(componentDto3.getDependentModules());
                }
            }
            componentDto.setTableDtoMap(genCodePreData.getFormCrudMapWithTableKey());
            componentDto.setGenCodePreData(genCodePreData);
        }
        for (String string : formKeys) {
            Iterator<String> fomCompon = componentDtoMap.get(string);
            Element element = this.renderCell(null, componentDtoMap, (ComponentDto)((Object)fomCompon), componentLibsDtos, compentsDepens, cellsScript, preloadDataCellsScript, cellEvents, cellCSS);
            cellsHtml.append(element.outerHtml()).append("\n");
        }
        if (genCodePreData.isCustomRule()) {
            cellEvents.append(FormRelatedUtil.formVerify(componentDtoMap));
        }
        webPageCode.setNodeCode(cellsHtml.toString());
        webPageCode.setNodeInitScript("window.businessId = \"${businessId!}\";\n");
        webPageCode.addNodeInitScript("window.taskId = \"${taskId!}\";\n");
        webPageCode.addNodeInitScript("window.workFlowKey = \"${workFlowKey!}\";\n");
        webPageCode.addNodeInitScript("window.nodeId = \"${nodeId!}\";\n");
        webPageCode.addNodeInitScript("window.userId = \"${!(shiro.getUser().id)}\";\n");
        webPageCode.addNodeInitScript("window.userName = \"${!(shiro.getUser().name)}\";\n");
        webPageCode.addNodeInitScript("window.organId = \"${!(shiro.getUser().deptId)}\";\n");
        webPageCode.addNodeInitScript("window.organName = \"${!(shiro.getUser().deptName)}\";\n");
        webPageCode.setNodeCss(cellCSS.toString());
        CodeGenServiceImpl.removeDuplicate(compentsDepens);
        for (String string : compentsDepens) {
            webJsCode.addImportModule(string);
        }
        webJsCode.setCellPreloadCode(preloadDataCellsScript.toString());
        webJsCode.setCellCode(cellsScript.toString());
        webJsCode.setEventCode(cellEvents.toString());
        BaseCell baseCell = BaseCellImplUtil.getBaseCellImpl(rootInstanceObj, componentDtoMap);
        webJsCode.setDocumentReadyCode(baseCell.renderEvent(rootInstanceObj.getEventConfigs()));
        webJsCode.setPageStateControl(this.getPageState(componentPageDto, componentDtoMap).toString());
        webJsCode.setWorkFlowControl(this.getWorkFlowControl(componentPageDto, componentDtoMap, webPageCode).toString());
        if (componentPageDto.getApis() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (PageAPIDto pageAPIDto : componentPageDto.getApis().values()) {
                String string = pageAPIDto.getApiPath();
                HashMap<String, List<InstanceDataFiledDto>> bodyParam = new HashMap<String, List<InstanceDataFiledDto>>();
                HashMap<String, String> bodyResponse = new HashMap<String, String>();
                Map<String, List<InstanceDataFiledDto>> apiField2instance = componentPageDto.getApi2instance().get(pageAPIDto.getApiId());
                for (Map.Entry<String, List<InstanceDataFiledDto>> entry : apiField2instance.entrySet()) {
                    int i;
                    String[] fieldPath = entry.getKey().split(".");
                    String getValueStr = "document.getElementById('" + entry.getValue().get(0).getInstanceKey() + "').value";
                    if (fieldPath.length < 2) {
                        System.out.println("\u4e0d\u652f\u6301");
                        continue;
                    }
                    if (fieldPath[0].equals("parameters")) {
                        JSONObject lastParamPath = null;
                        for (i = 1; i < fieldPath.length; ++i) {
                            JSONObject newJo;
                            if (lastParamPath == null) {
                                if (!bodyParam.containsKey(fieldPath[i])) {
                                    if (i == fieldPath.length - 1) {
                                        bodyParam.put(fieldPath[i], entry.getValue());
                                        continue;
                                    }
                                    newJo = new JSONObject();
                                    bodyParam.put(fieldPath[i], (List<InstanceDataFiledDto>)newJo);
                                    lastParamPath = newJo;
                                    continue;
                                }
                                Object paramObject = bodyParam.get(fieldPath[i]);
                                if (paramObject instanceof JSONObject) {
                                    lastParamPath = (JSONObject)paramObject;
                                    continue;
                                }
                                System.out.println("\u8def\u5f84\u9519\u8bef");
                                continue;
                            }
                            if (!lastParamPath.containsKey((Object)fieldPath[i])) {
                                if (i == fieldPath.length - 1) {
                                    lastParamPath.put(fieldPath[i], (Object)getValueStr);
                                    continue;
                                }
                                newJo = new JSONObject();
                                lastParamPath.put(fieldPath[i], (Object)newJo);
                                lastParamPath = newJo;
                                continue;
                            }
                            lastParamPath = (JSONObject)lastParamPath.get((Object)fieldPath[i]);
                        }
                        continue;
                    }
                    if (fieldPath[0].equals("response")) {
                        StringBuilder responsePath = new StringBuilder();
                        for (i = 1; i < fieldPath.length; ++i) {
                            responsePath.append(fieldPath[i]);
                            if (i == fieldPath.length - 1) continue;
                            responsePath.append(".");
                        }
                        bodyResponse.put(getValueStr, responsePath.toString());
                        continue;
                    }
                    System.out.println("\u4e0d\u652f\u6301");
                }
                stringBuilder.append("function ").append(string.replaceAll("/", "_")).append("(){").append("\r\n");
                stringBuilder.append("var ajax = new $ax(Hussar.ctxPath + ").append(string).append(",");
                stringBuilder.append("    function(data) {").append("\r\n");
                for (Map.Entry<String, List<InstanceDataFiledDto>> entry : bodyResponse.entrySet()) {
                    stringBuilder.append("    ").append(entry.getKey()).append(" = ").append("data").append((String)((Object)entry.getValue())).append(";").append("\r\n");
                }
                stringBuilder.append("    },").append("\r\n");
                stringBuilder.append("    function(data) {").append("\r\n");
                stringBuilder.append("        Hussar.error(data);").append("\r\n");
                stringBuilder.append("    });").append("\r\n");
                for (Map.Entry<String, List<InstanceDataFiledDto>> entry : bodyParam.entrySet()) {
                    stringBuilder.append("ajax.set('").append(entry.getKey()).append("',");
                    if (entry.getValue() instanceof JSONObject) {
                        stringBuilder.append(((JSONObject)entry.getValue()).toJSONString());
                        continue;
                    }
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("\r\n");
                stringBuilder.append("ajax.start();").append("\r\n");
                stringBuilder.append("};").append("\r\n");
            }
            webPageCode.setPageAPIRequestScript(stringBuilder.toString());
        }
        if (componentPageDto.getCssArray() != null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            for (String string : componentPageDto.getCssArray()) {
                if (string.indexOf("/") == 0) {
                    stringBuilder.append("<link fm=\"fromdesign\" rel=\"stylesheet\" href=\"${ctxPath}").append(string).append("\">").append("\n");
                    continue;
                }
                stringBuilder.append("<link fm=\"fromdesign\" rel=\"stylesheet\" href=\"${ctxPath}/").append(string).append("\">").append("\n");
            }
            webPageCode.setCssLinks(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        ArrayList<String> scriptArray = new ArrayList<String>();
        if (componentPageDto.getScriptArray() != null) {
            scriptArray.addAll(componentPageDto.getScriptArray());
        }
        for (ComponentDto componentDto : componentDtoMap.values()) {
            if (!componentDto.getName().contains("Chart")) continue;
            scriptArray.add("/static/assets/lib/echarts/echarts.common.min.js");
            break;
        }
        boolean bl = false;
        for (ComponentDto instance : componentDtoMap.values()) {
            boolean bl2;
            if (instance.getGenCodePreData() != null && instance.getGenCodePreData().getRequestDataList().size() != 0) {
                List<RequestData> requestDataList = instance.getGenCodePreData().getRequestDataList();
                for (RequestData requestData : requestDataList) {
                    if (!"linkPage".equals(requestData.getType())) continue;
                    scriptArray.add("/static/js/common/tabUtils.js");
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            break;
        }
        if (genCodePreData.isAddTreeSelect() && !scriptArray.contains("/static/js/common/layuiExtends.js")) {
            scriptArray.add("/static/js/common/layuiExtends.js");
        }
        for (String str : scriptArray) {
            if (str.indexOf("/") == 0) {
                stringBuilder.append("<script src=\"${ctxPath}").append(str).append("\"></script>").append("\n");
                continue;
            }
            stringBuilder.append("<script src=\"${ctxPath}/").append(str).append("\"></script>").append("\n");
        }
        Template template = this.groupTemplate.getTemplate("js-layui.js");
        template.binding("code", (Object)webJsCode);
        String jsCode = template.render();
        GenJavaScriptCode genJavaScriptCode = new GenJavaScriptCode(jsFile.getPath(), jsCode);
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genJavaScriptCode.setPagePath(pagePath.replace("/", ""));
        genJavaScriptCode.run();
        GenCodeResult genCodeResult = genJavaScriptCode.getGenCodeResult();
        stringBuilder.append("<script id=\"formCheckJs\" src=\"${ctxPath}/static/js/common/formCheck.js\"></script>").append("\n");
        stringBuilder.append("<script id=\"defaultJs\" src=\"").append(jsRelativePath).append("\"></script>").append("\n");
        webPageCode.setScriptLinks(stringBuilder.toString());
        Template template2 = this.groupTemplate.getTemplate(this.designConfig.getPageTemplate());
        template2.binding("code", (Object)webPageCode);
        template2.binding("ctxPath", (Object)"${ctxPath}");
        template2.binding("defaultCss", (Object)("default.css?version=" + System.currentTimeMillis()));
        String result = template2.render();
        FileUtils.writeStringToFile((File)file, (String)result, (String)"utf-8");
        FileUtils.writeStringToFile((File)compileFile, (String)result, (String)"utf-8");
        return genCodeResult;
    }

    private StringBuilder getPageState(ComponentPageDto componentPageDto, Map<String, ComponentDto> componentDtoMap) {
        StringBuilder waitForAppend = new StringBuilder();
        Map<String, Object> pageState = componentPageDto.getPageState();
        for (Object obj : pageState.values()) {
            waitForAppend.append("if(");
            JSONObject jsonObject = (JSONObject)obj;
            JSONArray conditions = jsonObject.getJSONArray("condition");
            for (int i = 0; i < conditions.size(); ++i) {
                JSONObject condition;
                if (i != 0 && i != conditions.size()) {
                    String con = ((JSONObject)conditions.get(i - 1)).getString("conditionConnect");
                    if ("and".equals(con)) {
                        waitForAppend.append(" && ");
                    } else if ("or".equals(con)) {
                        waitForAppend.append(" || ");
                    }
                }
                if ((condition = conditions.getJSONObject(i)).containsKey((Object)"children") && condition.getJSONArray("children").size() != 0) {
                    JSONArray childState = condition.getJSONArray("children");
                    waitForAppend.append("(");
                    for (int j = 0; j < childState.size(); ++j) {
                        if (j != 0 && j != childState.size()) {
                            String con = ((JSONObject)childState.get(j - 1)).getString("conditionConnect");
                            if ("and".equals(con)) {
                                waitForAppend.append(" && ");
                            } else if ("or".equals(con)) {
                                waitForAppend.append(" || ");
                            }
                        }
                        this.getStateExpression(waitForAppend, childState.getJSONObject(j));
                    }
                    waitForAppend.append(")");
                    continue;
                }
                this.getStateExpression(waitForAppend, condition);
            }
            waitForAppend.append("){\n");
            JSONObject instances = jsonObject.getJSONObject("instances");
            for (String key : instances.keySet()) {
                BaseCell baseCell = BaseCellImplUtil.getBaseCellImpl(componentDtoMap.get(key), componentDtoMap);
                boolean isNeedCheck = false;
                isNeedCheck = BaseCellImplUtil.isNeedCheck(componentDtoMap.get(key));
                JSONObject jsonObj = instances.getJSONObject(key);
                if (jsonObj.containsKey((Object)"readonly") && jsonObj.getBoolean("readonly").booleanValue()) {
                    waitForAppend.append(baseCell.renderSetReadonlyActionScript(isNeedCheck));
                } else if (jsonObj.containsKey((Object)"hide") && jsonObj.getBoolean("hide").booleanValue()) {
                    waitForAppend.append(baseCell.renderHideActionScript(isNeedCheck));
                } else if (jsonObj.containsKey((Object)"disabled") && jsonObj.getBoolean("disabled").booleanValue()) {
                    waitForAppend.append(baseCell.renderSetDisableActionScript(isNeedCheck));
                }
                waitForAppend.append("\n");
            }
            waitForAppend.append("}\n");
        }
        return waitForAppend;
    }

    private StringBuilder getWorkFlowControl(ComponentPageDto componentPageDto, Map<String, ComponentDto> componentDtoMap, WebPageCode webPageCode) {
        Map conditionMap;
        Map tmp;
        StringBuilder paramCheckBuilder = new StringBuilder();
        paramCheckBuilder.append("var businessId=window.businessId;\n").append("var nodeId=window.nodeId;\n").append("var workFlowKey=window.workFlowKey;\n");
        if (componentPageDto.getPage().getPageParams().size() > 1) {
            List<Object> pageParams = componentPageDto.getPage().getPageParams();
            for (Object pageParam : pageParams) {
                if ("businessId".equals(((Map)pageParam).get("field"))) continue;
                paramCheckBuilder.append("var ").append((String)((Map)pageParam).get("field")).append("=window.").append((String)((Map)pageParam).get("field")).append(";\n");
                String codeScript = "window." + (String)((Map)pageParam).get("field") + " = \"${" + (String)((Map)pageParam).get("field") + "!}\";\n";
                webPageCode.addNodeInitScript(codeScript);
            }
        }
        paramCheckBuilder.append("if(workFlowKey!==''){\n");
        Map<String, Object> conditionShow = componentPageDto.getConditionShow();
        paramCheckBuilder.append("  if(nodeId!==''){\n");
        for (Object o : conditionShow.values()) {
            tmp = (Map)o;
            conditionMap = (Map)tmp.get("condition");
            String nodeId = (String)((Map)conditionMap.get("nodeId")).get("value");
            String modelKey = (String)((Map)conditionMap.get("flowKey")).get("value");
            paramCheckBuilder.append("    if(").append("nodeId===").append("'").append(nodeId).append("'").append(" && workFlowKey===").append("'").append(modelKey).append("'").append("){\n");
            Map instancesMap = (Map)tmp.get("instances");
            for (Map.Entry instanceObj : instancesMap.entrySet()) {
                ComponentDto fomCompon = componentDtoMap.get(instanceObj.getKey());
                if (!ToolUtil.isNotEmpty((Object)fomCompon)) continue;
                BaseCell baseCell = BaseCellImplUtil.getBaseCellImpl(fomCompon, componentDtoMap);
                boolean isNeedCheck = BaseCellImplUtil.isNeedCheck(fomCompon);
                baseCell.setData(fomCompon);
                baseCell.setComponentDtoMap(componentDtoMap);
                Map permission = (Map)instanceObj.getValue();
                if (permission.containsKey("readonly") && ((Boolean)permission.get("readonly")).booleanValue()) {
                    paramCheckBuilder.append("      ").append(baseCell.renderSetReadonlyActionScript(isNeedCheck)).append("\n");
                }
                if (permission.containsKey("disabled") && ((Boolean)permission.get("disabled")).booleanValue()) {
                    paramCheckBuilder.append("      ").append(baseCell.renderSetDisableActionScript(isNeedCheck)).append("\n");
                }
                if (!permission.containsKey("hide") || !((Boolean)permission.get("hide")).booleanValue()) continue;
                paramCheckBuilder.append("      ").append(baseCell.renderHideActionScript(isNeedCheck)).append("\n");
            }
            paramCheckBuilder.append("    }").append("\n");
        }
        paramCheckBuilder.append("  }else{\n");
        for (Object o : conditionShow.values()) {
            tmp = (Map)o;
            conditionMap = (Map)tmp.get("condition");
            if (!conditionMap.containsKey("startFillNode")) continue;
            String modelKey = (String)((Map)conditionMap.get("flowKey")).get("value");
            paramCheckBuilder.append("    if(").append("workFlowKey===").append("'").append(modelKey).append("'").append("){\n");
            Map instancesMap = (Map)tmp.get("instances");
            for (Map.Entry instanceObj : instancesMap.entrySet()) {
                ComponentDto fomCompon = componentDtoMap.get(instanceObj.getKey());
                if (!ToolUtil.isNotEmpty((Object)fomCompon)) continue;
                BaseCell baseCell = BaseCellImplUtil.getBaseCellImpl(fomCompon, componentDtoMap);
                boolean isNeedCheck = BaseCellImplUtil.isNeedCheck(fomCompon);
                baseCell.setData(fomCompon);
                baseCell.setComponentDtoMap(componentDtoMap);
                Map permission = (Map)instanceObj.getValue();
                if (permission.containsKey("readonly") && ((Boolean)permission.get("readonly")).booleanValue()) {
                    paramCheckBuilder.append("        ").append(baseCell.renderSetReadonlyActionScript(isNeedCheck)).append("\n");
                }
                if (permission.containsKey("disabled") && ((Boolean)permission.get("disabled")).booleanValue()) {
                    paramCheckBuilder.append("        ").append(baseCell.renderSetDisableActionScript(isNeedCheck)).append("\n");
                }
                if (!permission.containsKey("hide") || !((Boolean)permission.get("hide")).booleanValue()) continue;
                paramCheckBuilder.append("        ").append(baseCell.renderHideActionScript(isNeedCheck)).append("\n");
            }
            paramCheckBuilder.append("    }").append("\n");
        }
        paramCheckBuilder.append("  }\n");
        paramCheckBuilder.append("}").append("\n");
        return paramCheckBuilder;
    }

    private void getStateExpression(StringBuilder waitForAppend, JSONObject condition) {
        String getValWay = condition.getString("getValWay");
        if (TableQueryConditionType.PARAMS.getType().equals(getValWay)) {
            waitForAppend.append(condition.getString("variable"));
        } else if (TableQueryConditionType.INPUT.getType().equals(getValWay)) {
            waitForAppend.append("'").append(condition.getString("variable")).append("'");
        } else if (TableQueryConditionType.SESSION.getType().equals(getValWay)) {
            String variable = condition.getString("variable");
            if (TableQueryConditionType.USER_ID.getType().equals(variable)) {
                waitForAppend.append(TableQueryConditionType.WINDOW_USER_ID.getType());
            } else if (TableQueryConditionType.USER_NAME.getType().equals(variable)) {
                waitForAppend.append(TableQueryConditionType.WINDOW_USER_NAME.getType());
            } else if (TableQueryConditionType.ORGAN_ID.getType().equals(variable)) {
                waitForAppend.append(TableQueryConditionType.WINDOW_ORGAN_ID.getType());
            } else if (TableQueryConditionType.ORGAN_NAME.getType().equals(variable)) {
                waitForAppend.append(TableQueryConditionType.WINDOW_ORGAN_NAME.getType());
            }
        }
        waitForAppend.append(" ").append(condition.getString("varConnect")).append(" '").append(condition.getString("varLimit")).append("'");
    }

    private void parserExistContent(File file, WebPageCode code, ComponentPageDto componentPageDto) {
        if (file.exists()) {
            try {
                Element jsSuf;
                Element jsPre;
                Document document = Jsoup.parse((File)file, (String)"utf-8");
                Element htmlPre = document.getElementById(code.HTML_PREFIX_RESERVE_ZONE_ELEMENT_ID);
                if (htmlPre != null) {
                    code.setHtmlPrefixReserveZone(htmlPre.html());
                }
                Elements links = document.getElementsByTag("link");
                links.forEach(code::addLinkReserve);
                Elements scripts = document.getElementsByTag("script");
                scripts.forEach(code::addScriptReserveZone);
                Element htmlSuf = document.getElementById(code.HTML_SUFFIX_RESERVE_ZONE_ELEMENT_ID);
                if (htmlSuf != null) {
                    code.setHtmlSuffixReserveZone(htmlSuf.html());
                }
                if ((jsPre = document.getElementById(code.JS_PREFIX_RESERVE_ZONE_ELEMENT_ID)) != null) {
                    code.setJsPrefixReserveZone(jsPre.html());
                }
                if ((jsSuf = document.getElementById(code.JS_SUFFIX_RESERVE_ZONE_ELEMENT_ID)) != null) {
                    code.setJsSuffixReserveZone(jsSuf.html());
                }
                for (Map.Entry<String, ComponentDto> instance : componentPageDto.getInstances().entrySet()) {
                    Element element;
                    if (!"iPlaceholder".equals(instance.getValue().getName()) || null == (element = document.getElementById(instance.getKey()))) continue;
                    instance.getValue().setSpecialHtml(element.html());
                }
            }
            catch (Exception e) {
                log.error("\u9875\u9762:" + file.getName() + "\u89e3\u6790\u5931\u8d25\uff01" + e.getMessage());
            }
        }
    }

    private Element renderCell(Element parent, Map<String, ComponentDto> componentDtoMap, ComponentDto fomCompon, List<ComponentLibsDto> componentLibsDtos, List<String> compentsDepens, StringBuilder cellsScript, StringBuilder preloadDataCellsScript, StringBuilder cellEvents, StringBuilder cellCss) throws GodAxeException {
        Element node = null;
        try {
            String preloadDataScript;
            String cellScript;
            BaseCell baseCell = BaseCellImplUtil.getBaseCellImpl(fomCompon, componentDtoMap);
            baseCell.setData(fomCompon);
            baseCell.setComponentDtoMap(componentDtoMap);
            node = new Element(fomCompon.getElementTag() == null ? fomCompon.getName() : fomCompon.getElementTag());
            baseCell.prepareEmbedElementRender(componentDtoMap);
            node = baseCell.renderCommonHTML(node);
            baseCell.renderCellHTML(node);
            String cssCode = baseCell.renderCSS(fomCompon.getProps(), fomCompon.getInteractive());
            if (cssCode != null) {
                cellCss.append(cssCode);
            }
            if (null != (cellScript = baseCell.renderScript(fomCompon.getProps()))) {
                cellsScript.append(cellScript).append("\n");
            }
            if (null != (preloadDataScript = baseCell.renderPreloadDataScript(fomCompon.getProps())) && !"".equals(preloadDataScript)) {
                preloadDataCellsScript.append(preloadDataScript).append("\n");
            }
            if (fomCompon.getEventConfigs() != null) {
                String renderEvent = baseCell.renderEvent(fomCompon.getEventConfigs());
                cellEvents.append(ToolUtil.isEmpty((Object)renderEvent) ? "" : renderEvent);
            }
            if (fomCompon.getChildren().size() > 0) {
                this.resortChildren(fomCompon.getChildren(), componentDtoMap);
                this.ItorCell(node, fomCompon, componentDtoMap, componentLibsDtos, compentsDepens, cellsScript, preloadDataCellsScript, cellEvents, cellCss);
            }
            baseCell.dealEmbedElementRendered(node);
            if (parent != null) {
                parent.appendChild((Node)node);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("\u65e0\u6cd5\u627e\u5230\u5143\u4ef6" + fomCompon.getName() + "\u7684\u5b9e\u73b0\u7c7b\uff1a\n" + e.getMessage());
        }
        catch (GodAxeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    private void resortChildren(List<String> childKeys, Map<String, ComponentDto> componentDtoMap) {
        LinkedList<String[]> floatLeftChildren = new LinkedList<String[]>();
        LinkedList<String[]> floatRightChildren = new LinkedList<String[]>();
        LinkedList<String[]> floatTopChildren = new LinkedList<String[]>();
        LinkedList<String> wait4Delete = new LinkedList<String>();
        for (String childInstanceKey : childKeys) {
            ComponentDto childDto = componentDtoMap.get(childInstanceKey);
            JSONObject posRelation = (JSONObject)childDto.getProps().get("posRelation");
            if (posRelation == null) continue;
            String[] childTmp = new String[3];
            childTmp[0] = childInstanceKey;
            if ("left".equals(posRelation.get((Object)"floatType"))) {
                this.resortFloatChildren(floatLeftChildren, posRelation, childTmp);
                wait4Delete.add(childInstanceKey);
                continue;
            }
            if ("right".equals(posRelation.get((Object)"floatType"))) {
                this.resortFloatChildren(floatRightChildren, posRelation, childTmp);
                wait4Delete.add(childInstanceKey);
                continue;
            }
            if (!"top".equals(posRelation.get((Object)"floatType"))) continue;
            this.resortFloatChildren(floatTopChildren, posRelation, childTmp);
            wait4Delete.add(childInstanceKey);
        }
        ArrayList<String> preAddChildren = new ArrayList<String>();
        for (String[] childTmp : floatTopChildren) {
            preAddChildren.add(childTmp[0]);
        }
        for (String[] childTmp : floatLeftChildren) {
            preAddChildren.add(childTmp[0]);
        }
        for (String[] childTmp : floatRightChildren) {
            preAddChildren.add(childTmp[0]);
        }
        for (String deleteKey : wait4Delete) {
            childKeys.remove(deleteKey);
        }
        childKeys.addAll(0, preAddChildren);
    }

    private void resortFloatChildren(List<String[]> floatChildren, JSONObject posRelation, String[] childTmp) {
        childTmp[1] = posRelation.get((Object)"floatOrder") != null ? String.valueOf(posRelation.get((Object)"floatOrder")) : "0";
        childTmp[2] = (String)posRelation.get((Object)"floatType");
        int i = 0;
        if (floatChildren.size() == 0) {
            floatChildren.add(childTmp);
        } else {
            for (String[] alreadyIn : floatChildren) {
                if (Integer.parseInt(alreadyIn[1]) > Integer.parseInt(childTmp[1])) {
                    floatChildren.add(i, childTmp);
                    break;
                }
                ++i;
            }
            if (i == floatChildren.size()) {
                floatChildren.add(childTmp);
            }
        }
    }

    private void ItorCell(Element itNode, ComponentDto fomCompon, Map<String, ComponentDto> componentDtoMap, List<ComponentLibsDto> componentLibsDtos, List<String> compentsDepens, StringBuilder cellsScript, StringBuilder preloadDataCellsScript, StringBuilder cellEvents, StringBuilder cellCSS) throws GodAxeException {
        List<String> componKey = fomCompon.getChildren();
        ArrayList<String> waitForRemove = new ArrayList<String>();
        for (String key : componKey) {
            ComponentDto realParent;
            String realParentKey;
            ComponentDto thisDto = componentDtoMap.get(key);
            if (!"iHidden".equals(thisDto.getName()) || (realParentKey = (String)thisDto.getProps().get("relatedForm")) == null || "".equals(realParentKey) || (realParent = componentDtoMap.get(realParentKey)) == null || !componKey.contains(realParent.getInstanceKey())) continue;
            realParent.getChildren().add(thisDto.getInstanceKey());
            waitForRemove.add(key);
        }
        for (String key : waitForRemove) {
            componKey.remove(key);
        }
        for (String key : componKey) {
            ComponentDto compon = componentDtoMap.get(key);
            compon.setTableDtoMap(fomCompon.getTableDtoMap());
            compon.setGenCodePreData(fomCompon.getGenCodePreData());
            this.renderCell(itNode, componentDtoMap, compon, componentLibsDtos, compentsDepens, cellsScript, preloadDataCellsScript, cellEvents, cellCSS);
        }
    }

    private static void removeDuplicate(List<String> list) {
        HashSet<String> h = new HashSet<String>(list);
        list.clear();
        list.addAll(h);
        list.add("jquery");
        list.add("HussarBpm");
    }
}

