/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.BaseFile;
import com.jxdinfo.hussar.formdesign.desgin.form.service.BaseFileService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;

public class BaseFileServiceImpl<T extends BaseFile>
implements BaseFileService<T> {
    @Override
    public void create(BaseFile baseFile, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        if (file.exists()) {
            throw new FileExistsException();
        }
        this.write(file, baseFile);
    }

    @Override
    public void delete(BaseFile baseFile, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        FileUtils.forceDelete((File)file);
        FileUtils.forceDelete((File)new File(this.addMeta(file.getAbsolutePath())));
    }

    @Override
    public void update(BaseFile baseFile, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        this.write(file, baseFile);
    }

    @Override
    public T get(String path, String rootPath) throws IOException {
        return this.readFileToObject((rootPath + path).replace("/", File.separator), path);
    }

    @Override
    public List<T> list(String path, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(path, rootPath));
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(this.iterator(file, rootPath));
        return list;
    }

    @Override
    public List<T> listWithoutData(String path, String rootPath) throws IOException {
        File file = new File(this.relativeToAbsolute(path, rootPath));
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(this.iterator(file, rootPath));
        return list;
    }

    @Override
    public void rename(BaseFile baseFile, String newName, String rootPath) throws IOException {
        File f2;
        String suffix = this.getSuffix(baseFile.getPath());
        File f = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        if (!f.renameTo(f2 = new File(f.getParentFile().getAbsolutePath() + File.separator + newName + suffix))) {
            throw new IOException("\u6587\u4ef6\u5df2\u5b58\u5728");
        }
        File fileOld = new File(this.addMeta(rootPath + baseFile.getPath()).replace("/", File.separator));
        this.fixName(fileOld.getAbsolutePath(), this.addMeta(fileOld.getParentFile().getAbsolutePath() + File.separator + newName + suffix));
        File newMeta = new File(this.addMeta(fileOld.getParentFile().getAbsolutePath() + File.separator + newName + suffix));
        JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)newMeta, (String)"utf-8"));
        jsonObject.put("path", (Object)(f.getParentFile().getPath().replace(rootPath.replace("/", File.separator), "") + File.separator + newName + suffix).replace(File.separator, "/"));
        jsonObject.put("name", (Object)newName);
        if (baseFile.getDesc() != null) {
            jsonObject.put("desc", (Object)baseFile.getDesc());
        }
        FileUtils.writeStringToFile((File)newMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8", (boolean)false);
    }

    @Override
    public void move(BaseFile baseFile, String dstPath, String rootPath) throws IOException {
        String suffix = this.getSuffix(baseFile.getPath());
        this.rename(baseFile, baseFile.getName(), rootPath);
        File from = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        File reNameFile = new File(from.getParentFile().getPath() + File.separator + baseFile.getName() + suffix);
        File reNameFileMeta = new File(this.addMeta(reNameFile.getPath()));
        File to = new File(this.relativeToAbsolute(dstPath, rootPath));
        FileUtils.moveFileToDirectory((File)reNameFile, (File)to.getParentFile(), (boolean)false);
        FileUtils.moveFileToDirectory((File)reNameFileMeta, (File)to.getParentFile(), (boolean)false);
        File meatFile = new File(this.addMeta(to.getParentFile().getAbsolutePath() + File.separator + reNameFile.getName()));
        JSONObject jsonObject = (JSONObject)JSON.parse((String)FileUtils.readFileToString((File)meatFile, (String)"utf-8"));
        jsonObject.put("path", (Object)dstPath);
        FileUtils.writeStringToFile((File)meatFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"utf-8");
    }

    @Override
    public void copy(BaseFile baseFile, String dstPath, String rootPath) throws IOException {
        File from = new File(this.relativeToAbsolute(baseFile.getPath(), rootPath));
        File to = new File(this.relativeToAbsolute(dstPath, rootPath));
        FileUtils.copyFile((File)from, (File)to, (boolean)false);
        FileUtils.copyFile((File)new File(this.addMeta(from.getAbsolutePath())), (File)new File(this.addMeta(to.getAbsolutePath())), (boolean)false);
        File meatFile = new File(this.addMeta(to.getAbsolutePath()));
        JSONObject jsonObject = (JSONObject)JSON.parse((String)FileUtils.readFileToString((File)meatFile, (String)"utf-8"));
        jsonObject.put("path", (Object)dstPath);
        jsonObject.put("id", (Object)IdWorker.get32UUID());
        jsonObject.put("name", (Object)baseFile.getName());
        jsonObject.put("desc", (Object)baseFile.getDesc());
        FileUtils.writeStringToFile((File)meatFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"utf-8");
    }

    public static String replacePathForRelatPath(String absolutePath, String rootPath) {
        return absolutePath.replace(rootPath.replace("/", File.separator), "").replace(File.separator, "/");
    }

    private void copyFile(String dstPath, String path) throws IOException {
        File from = new File(path.replace("/", File.separator));
        File to = new File(dstPath.replace("/", File.separator));
        FileUtils.copyFile((File)from, (File)to);
    }

    public void fixName(String oldFile, String newFile) throws IOException {
        File fileOld = new File(oldFile);
        File fileNew = new File(newFile);
        if (!fileOld.renameTo(fileNew)) {
            throw new IOException("\u6587\u4ef6\u5df2\u5b58\u5728");
        }
    }

    public String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator);
        return real + ".meta";
    }

    public String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + relativePath).replace("/", File.separator);
    }

    private List<T> iterator(File file, String rootPath) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        File[] files = file.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            for (File f : files) {
                if (f.isFile() && !f.getName().contains(".meta")) {
                    String path = f.getPath().replace(rootPath.replace("/", File.separator), "/").replace(File.separator + File.separator, File.separator);
                    T t = this.readFileToObject(f.getAbsolutePath(), path);
                    list.add(t);
                    continue;
                }
                list.addAll(this.iterator(f, rootPath));
            }
        }
        return list;
    }

    public void write(File file, BaseFile baseFile) throws IOException {
        File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
        Object jsonObject = JSONObject.parse((String)baseFile.getData());
        if (ToolUtil.isEmpty((Object)jsonObject)) {
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
        } else {
            FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject), (String)"UTF-8", (boolean)false);
        }
        baseFile.setData(null);
        FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)baseFile), (String)"UTF-8", (boolean)false);
    }

    private T readFileToObject(String absolutePath, String path) throws IOException {
        HashMap map = new HashMap(3);
        File file = new File(absolutePath);
        File fileOfMeta = new File(this.addMeta(absolutePath));
        String info = FileUtils.readFileToString((File)fileOfMeta, (String)"UTF-8");
        BaseFile t = (BaseFile)JSON.parseObject((String)info, (Type)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0], (Feature[])new Feature[0]);
        String data = FileUtils.readFileToString((File)file, (String)"UTF-8");
        t.setData(data);
        return (T)t;
    }

    private String getSuffix(String path) {
        String suffix = "";
        int lastIndex = path.lastIndexOf(".");
        if (lastIndex != -1) {
            suffix = path.substring(lastIndex);
        }
        return suffix;
    }
}

