/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.bsp.permit.service.ISysModulesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.configration.DesignConfig;
import com.jxdinfo.hussar.formdesign.desgin.form.model.Page;
import com.jxdinfo.hussar.formdesign.desgin.form.service.CodeGenService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageTreeNodeService;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.PageTreeNode;
import com.jxdinfo.hussar.formdesign.desgin.menuconfig.service.IMenuConfigService;
import com.jxdinfo.hussar.formdesign.desgin.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publish"})
public class PublishController {
    @Value(value="${form-design.module-store-path}")
    private String rootPath;
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Value(value="${form-design.project-name}")
    private String projectName;
    @Resource
    private ISysResManageService sysResManageService;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Autowired
    private CodeGenService service;
    @Autowired
    private IMenuConfigService menuConfigService;
    @Autowired
    private ISysRoleResourceService roleResourceService;
    @Autowired
    private ISysMenuManageService menuManageService;
    @Autowired
    private ISysFunctionsService functionsService;
    @Autowired
    private ISysResourcesService resourcesService;
    @Autowired
    private ISysModulesService modulesService;
    @Autowired
    private PageTreeNodeService<PageTreeNode> pageTreeNodeService;
    @Autowired
    private PublishService publishService;
    @Autowired
    private DesignConfig designConfig;
    @Value(value="${form-design.page-store-path}")
    private String pagePath;

    @RequestMapping(value={"/page"})
    public FormDesignResponse<String> publishPage(String path, String projectPath) throws Exception {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            this.service.generateCode(path, this.getRootPath() + projectPath + this.pagePath, projectPath, null);
            response.setErrorCode("200");
        }
        catch (IOException e) {
            response.setErrorCode("40011");
            response.setErrorMsg("\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/configMenu"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    public FormDesignResponse<String> configMenu(String pageId) {
        FormDesignResponse<String> formDesignResponse = new FormDesignResponse<String>();
        formDesignResponse.setErrorCode("201");
        try {
            if (pageId != null) {
                List<PageTreeNode> pageTreeNodes = this.pageTreeNodeService.listFileTreeNode(this.getRootPath() + this.projectName + this.pagePath);
                String currentId = pageId;
                HashMap map = new HashMap();
                this.getData(pageTreeNodes, currentId, map);
                StringBuilder resourceId = new StringBuilder();
                this.genModule(map, resourceId, formDesignResponse);
                if (!"199".equals(formDesignResponse.getErrorCode())) {
                    List<String> newMenuParentParams = this.checkMenuExist(map);
                    this.genMenu(map, resourceId, newMenuParentParams);
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setResourceId(resourceId.toString());
                    sysRoleResource.setRoleId("superadmin_role");
                    boolean isSuccess = this.roleResourceService.insert((Object)sysRoleResource);
                    if (isSuccess) {
                        formDesignResponse.setErrorCode("200");
                    }
                }
            }
            return formDesignResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            return formDesignResponse;
        }
    }

    @RequestMapping(value={"/delMenu"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    public FormDesignResponse<String> delMenu(String pageId) {
        FormDesignResponse<String> formDesignResponse = new FormDesignResponse<String>();
        formDesignResponse.setErrorCode("201");
        try {
            if (pageId != null) {
                List<PageTreeNode> pageTreeNodes = this.pageTreeNodeService.listFileTreeNode(this.getRootPath() + this.projectName + this.pagePath);
                String currentId = pageId;
                HashMap map = new HashMap();
                this.getData(pageTreeNodes, currentId, map);
                StringBuilder isSuccess = new StringBuilder();
                isSuccess.append("fasle");
                this.delSelectMenu(map, formDesignResponse, isSuccess);
                if (Boolean.valueOf(isSuccess.toString()).booleanValue()) {
                    formDesignResponse.setErrorCode("200");
                }
            }
            return formDesignResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            return formDesignResponse;
        }
    }

    @RequestMapping(value={"/genWorkFlowListener"})
    public FormDesignResponse<String> genWorkFlowListener(String path) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        response.setErrorCode("40001");
        File file = new File(this.projectPath + this.rootPath + this.projectName + this.pagePath + path);
        if (file.exists() && file.isFile()) {
            try {
                String xml = FileUtils.readFileToString((File)file, (String)"UTF-8");
                File fileMeta = new File(file.getAbsolutePath() + ".meta");
                Page meta = (Page)JSONObject.parseObject((String)FileUtils.readFileToString((File)fileMeta, (String)"UTF-8"), Page.class);
                this.publishService.publishWorkFlowListener(xml, meta);
            }
            catch (GodAxeException e) {
                e.printInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
                return response;
            }
        }
        response.setErrorCode("200");
        return response;
    }

    private void getData(List<PageTreeNode> pageTreeNodes, String currentId, Map map) {
        for (PageTreeNode pageTreeNode : pageTreeNodes) {
            HashMap childMap = new HashMap();
            childMap.putAll(map);
            if (!pageTreeNode.getId().equals(currentId)) continue;
            map.put("child", childMap);
            map.put("desc", pageTreeNode.getDesc());
            map.put("name", pageTreeNode.getName());
            if (null != pageTreeNode.getPath()) {
                map.put("url", pageTreeNode.getPath().replace(".vpd", ""));
            }
            currentId = pageTreeNode.getParent();
            this.getData(pageTreeNodes, currentId, map);
        }
    }

    private void getMenuNames(Map menu, List<String> menuNames) {
        menuNames.add((String)menu.get("desc"));
        if (menu.get("child") != null && ((Map)menu.get("child")).size() > 0) {
            Map childMenuMap = (Map)menu.get("child");
            this.getMenuNames(childMenuMap, menuNames);
        }
    }

    private List<String> checkMenuExist(Map menu) {
        int i;
        ArrayList<String> menuNames = new ArrayList<String>();
        this.getMenuNames(menu, menuNames);
        String newMenuParentID = "";
        boolean isExist = false;
        HashMap thisMenuChild = new HashMap();
        for (i = menuNames.size() - 1; i >= 0; --i) {
            EntityWrapper sysMenuEntityWrapper = new EntityWrapper();
            sysMenuEntityWrapper.eq("MENU_ALIAS", menuNames.get(i));
            if (this.menuManageService.selectList((Wrapper)sysMenuEntityWrapper).size() > 0) {
                List sysMenuList = this.menuManageService.selectList((Wrapper)sysMenuEntityWrapper);
                ArrayList menuModuels = new ArrayList();
                for (SysMenu sysMenu : sysMenuList) {
                    thisMenuChild.putAll((Map)menu.get("child"));
                    newMenuParentID = sysMenu.getMenuId();
                    ArrayList<String> selectMenuNames = new ArrayList<String>();
                    this.selectMenuName(sysMenu.getMenuId(), selectMenuNames, i + 1);
                    int menuIndex = 0;
                    for (int j = selectMenuNames.size() - 1; j >= 0 && menuNames.get(menuIndex) != null; --j) {
                        if (((String)selectMenuNames.get(j)).equals(menuNames.get(menuIndex))) {
                            if (j > 0) {
                                if (thisMenuChild.get("child") == null || ((Map)thisMenuChild.get("child")).size() == 0) {
                                    thisMenuChild = null;
                                } else {
                                    thisMenuChild.putAll((Map)thisMenuChild.get("child"));
                                }
                            }
                            isExist = true;
                        } else {
                            isExist = false;
                        }
                        ++menuIndex;
                    }
                    if (!isExist) continue;
                    break;
                }
            }
            if (!isExist) continue;
            menu.clear();
            if (thisMenuChild == null) {
                menu.put("child", null);
                break;
            }
            menu.putAll(thisMenuChild);
            break;
        }
        ArrayList<String> returnMenu = new ArrayList<String>();
        returnMenu.add(newMenuParentID);
        if (i >= 0 && i != menuNames.size() - 1) {
            returnMenu.add((String)menuNames.get(i));
        } else {
            returnMenu.add("");
        }
        return returnMenu;
    }

    private void selectMenuName(String menuId, List<String> selectMenuNames, int nums) {
        if (nums > 0) {
            SysMenu sysMenu = (SysMenu)this.menuManageService.selectById((Serializable)((Object)menuId));
            if (sysMenu == null) {
                selectMenuNames.add("");
            } else {
                selectMenuNames.add(sysMenu.getMenuAlias());
                if (!"1".equals(sysMenu.getParentId())) {
                    this.selectMenuName(sysMenu.getParentId(), selectMenuNames, nums);
                }
            }
            --nums;
        }
    }

    private void genMenu(Map menu, StringBuilder resourceId, List<String> parentMenu) {
        if (menu.get("child") != null && ((Map)menu.get("child")).size() > 0) {
            String parentMenuId;
            Map childMenuMap = (Map)menu.get("child");
            SysMenu sysMenu = new SysMenu();
            sysMenu.setText((String)menu.get("desc"));
            sysMenu.setMenuAlias((String)menu.get("desc"));
            if (menu.get("parentMenuId") == null) {
                if ("".equals(parentMenu.get(0))) {
                    parentMenuId = "1";
                } else {
                    parentMenuId = parentMenu.get(0);
                    parentMenu.set(0, "");
                }
            } else {
                parentMenuId = menu.get("parentMenuId").toString();
            }
            sysMenu.setParentId(parentMenuId);
            sysMenu.setOpenType("tab");
            sysMenu.setTitle((String)menu.get("desc"));
            sysMenu.setIsLeaf("0");
            this.sysMenuManageService.menuInfoSave(sysMenu);
            childMenuMap.put("parentMenuId", sysMenu.getMenuId());
            this.genMenu(childMenuMap, resourceId, parentMenu);
        } else {
            String parentMenuId = "";
            if (menu.get("parentMenuId") == null) {
                if ("".equals(parentMenu.get(0))) {
                    parentMenuId = "1";
                } else {
                    parentMenuId = parentMenu.get(0);
                    parentMenu.set(0, "");
                }
            } else {
                parentMenuId = menu.get("parentMenuId").toString();
            }
            String desc = menu.get("desc").toString();
            SysMenu sysMenu = new SysMenu();
            sysMenu.setParentId(parentMenuId);
            sysMenu.setOpenType("tab");
            sysMenu.setMenuAlias(menu.get("desc").toString());
            sysMenu.setText(desc);
            sysMenu.setResourceId(resourceId.toString());
            sysMenu.setTitle(desc);
            sysMenu.setIsLeaf("1");
            this.sysMenuManageService.menuInfoSave(sysMenu);
        }
    }

    private void genModule(Map menu, StringBuilder resourseId, FormDesignResponse<String> formDesignResponse) {
        if (menu.get("child") != null && ((Map)menu.get("child")).size() > 0) {
            Map childMenuMap = (Map)menu.get("child");
            SysModules sysModules = this.menuConfigService.selectOneModule(menu.get("url").toString());
            SysMenu sysMenu = new SysMenu();
            if (ToolUtil.isEmpty((Object)sysModules.getModuleId())) {
                String moduleName = menu.get("desc").toString();
                sysModules.setModuleName(moduleName);
                String parentModuleId = menu.get("parentModuleId") == null ? "1" : menu.get("parentModuleId").toString();
                sysModules.setParentModuleId(parentModuleId);
                if (childMenuMap.get("child") != null && ((Map)childMenuMap.get("child")).size() > 0) {
                    sysModules.setIsLeaf("0");
                } else {
                    sysModules.setIsLeaf("1");
                }
                this.sysResManageService.moduleSave(sysModules);
            }
            childMenuMap.put("parentModuleId", sysModules.getModuleId());
            this.genModule(childMenuMap, resourseId, formDesignResponse);
        } else {
            SysFunctions sysFunctions = new SysFunctions();
            String parentModuleId = "";
            if (menu.get("parentModuleId") != null) {
                parentModuleId = menu.get("parentModuleId").toString();
                EntityWrapper functionsEntityWrapper = new EntityWrapper();
                functionsEntityWrapper.eq("MODULE_ID", (Object)parentModuleId);
                functionsEntityWrapper.eq("FUNCTION_CODE", (Object)menu.get("url").toString());
                sysFunctions = (SysFunctions)this.functionsService.selectOne((Wrapper)functionsEntityWrapper);
            }
            if (sysFunctions == null) {
                sysFunctions = new SysFunctions();
                String desc = menu.get("desc").toString();
                String name = menu.get("name").toString();
                sysFunctions.setModuleId(parentModuleId);
                sysFunctions.setFunctionName(desc);
                sysFunctions.setFunctionCode(menu.get("url").toString());
                sysFunctions.setIsSys("1");
                this.sysResManageService.functionSave(sysFunctions);
                String functionId = sysFunctions.getFunctionId();
                SysResources sysResources = new SysResources();
                sysResources.setFunctionId(functionId);
                sysResources.setResourceName(desc);
                sysResources.setResourceAlias(desc);
                sysResources.setPermissions(name);
                sysResources.setIsDefault("0");
                sysResources.setIsAudit("0");
                sysResources.setIsRepeatAuthenticate("0");
                String url = "";
                boolean isDynamic = this.designConfig.isDynamic();
                url = isDynamic ? "/dynamic-page/view/" + menu.get("url").toString().replace("/", ".") : menu.get("url").toString() + "/view";
                sysResources.setResTypeId("1");
                sysResources.setUrlNames(url);
                sysResources.setResourceCode(UUID.randomUUID().toString().replace("-", ""));
                this.sysResManageService.resourceSave(sysResources);
                resourseId.append(sysResources.getResourceId());
            } else {
                formDesignResponse.setErrorCode("199");
            }
        }
    }

    public void delSelectMenu(Map menu, FormDesignResponse<String> formDesignResponse, StringBuilder isSuccessDel) {
        if (menu.get("child") != null && ((Map)menu.get("child")).size() > 0) {
            Map childMenuMap = (Map)menu.get("child");
            this.delSelectMenu(childMenuMap, formDesignResponse, isSuccessDel);
        } else {
            EntityWrapper sysResourcesEntityWrapper = new EntityWrapper();
            boolean isDynamic = this.designConfig.isDynamic();
            if (isDynamic) {
                sysResourcesEntityWrapper.eq("URL_NAMES", (Object)("/dynamic-page/view/" + menu.get("url").toString().replace("/", ".")));
            } else {
                sysResourcesEntityWrapper.eq("URL_NAMES", (Object)(menu.get("url").toString() + "/view"));
            }
            SysResources sysResources = (SysResources)this.resourcesService.selectOne((Wrapper)sysResourcesEntityWrapper);
            if (sysResources == null) {
                formDesignResponse.setErrorCode("199");
            } else {
                String resourceId = sysResources.getResourceId();
                EntityWrapper sysRoleResourceEntityWrapper = new EntityWrapper();
                sysRoleResourceEntityWrapper.eq("RESOURCE_ID", (Object)resourceId);
                boolean delRoleResource = this.roleResourceService.delete((Wrapper)sysRoleResourceEntityWrapper);
                if (delRoleResource) {
                    String functionID = sysResources.getFunctionId();
                    this.sysResManageService.delResource(resourceId);
                    SysFunctions sysFunctions = (SysFunctions)this.functionsService.selectById((Serializable)((Object)functionID));
                    String moduleId = sysFunctions.getModuleId();
                    this.sysResManageService.delFunction(functionID);
                    this.delModule(moduleId);
                    EntityWrapper menuEntityWrapper = new EntityWrapper();
                    menuEntityWrapper.eq("RESOURCE_ID", (Object)resourceId);
                    SysMenu sysMenu = (SysMenu)this.menuManageService.selectOne((Wrapper)menuEntityWrapper);
                    this.menuManageService.delMenuById(sysMenu.getMenuId());
                    this.delTierMenu(sysMenu.getParentId());
                    isSuccessDel.delete(0, isSuccessDel.length());
                    isSuccessDel.append("true");
                }
            }
        }
    }

    private void delModule(String moduleId) {
        EntityWrapper functionsEntityWrapper = new EntityWrapper();
        functionsEntityWrapper.eq("MODULE_ID", (Object)moduleId);
        int functionCount = this.functionsService.selectCount((Wrapper)functionsEntityWrapper);
        if (functionCount == 0) {
            SysModules sysModules = (SysModules)this.modulesService.selectById((Serializable)((Object)moduleId));
            String parentModuleId = sysModules.getParentModuleId();
            this.sysResManageService.delModule(moduleId);
            if (!"1".equals(parentModuleId)) {
                this.delModule(parentModuleId);
            }
        }
    }

    private void delTierMenu(String menuId) {
        EntityWrapper menuEntityWrapper = new EntityWrapper();
        menuEntityWrapper.eq("PARENT_ID", (Object)menuId);
        int menuCount = this.menuManageService.selectCount((Wrapper)menuEntityWrapper);
        if (menuCount == 0) {
            SysMenu sysMenu = (SysMenu)this.menuManageService.selectById((Serializable)((Object)menuId));
            String parentMenuId = sysMenu.getParentId();
            this.sysMenuManageService.delMenuById(menuId).toString();
            if (!"1".equals(parentMenuId)) {
                this.delTierMenu(parentMenuId);
            }
        }
    }

    private String getRootPath() {
        return this.projectPath + this.rootPath;
    }
}

