/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.controller;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.Project;
import com.jxdinfo.hussar.formdesign.desgin.form.service.ModularService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.ProjectService;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectInfo"})
public class ProjectController {
    @Value(value="${form-design.project-store-path}")
    private String rootPath;
    @Value(value="${form-design.project-name}")
    private String projectName;
    @Autowired
    private ProjectService projectService;
    @Resource
    private ModularService<Project> modularService;

    @RequestMapping(value={"/getProjectName"})
    public FormDesignResponse<String> getProjectName() {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        response.setErrorCode("200");
        response.setData(this.projectName);
        return response;
    }

    @RequestMapping(value={"/createProjectInfo"})
    public FormDesignResponse<String> createProjectInfo(@RequestBody Project project) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.modularService.createDirectory(project, this.getRootPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setErrorCode("40011");
            response.setErrorMsg("\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/deleteProjectInfo"})
    public FormDesignResponse<String> deleteProjectInfo(@RequestBody Project project) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.modularService.deleteDirectory(project, this.getRootPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setErrorCode("40012");
            response.setErrorMsg("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/updateProjectInfo"})
    public FormDesignResponse<String> updateProjectInfo(@RequestBody Project project) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.modularService.updateDirectory(project, this.getRootPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setErrorCode("40013");
            response.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/listProjectInfo"})
    public FormDesignResponse<List<Project>> listProjectInfo() {
        FormDesignResponse<List<Project>> response = new FormDesignResponse<List<Project>>();
        try {
            response.setErrorCode("200");
            response.setData(this.modularService.listDirectory("", this.getRootPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    private String getRootPath() {
        String path = ToolUtil.getWebRootPath(null);
        return path + this.rootPath;
    }
}

