/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.controller;

import com.jxdinfo.hussar.formdesign.desgin.form.model.BaseFile;
import com.jxdinfo.hussar.formdesign.desgin.form.model.Page;
import com.jxdinfo.hussar.formdesign.desgin.form.service.ModularService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageTreeNodeService;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.CustomComponentMoveVO;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.PageTreeNode;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/page"})
public class PageController {
    private static final Logger log = LoggerFactory.getLogger(PageController.class);
    @Resource
    private PageTreeNodeService<PageTreeNode> service;
    @Resource
    private ModularService<BaseFile> projectService;
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Value(value="${form-design.module-store-path}")
    private String rootPath;
    @Value(value="${form-design.page-store-path}")
    private String pagePath;
    @Value(value="${form-design.project-name}")
    private String projectName;

    @RequestMapping(value={"/createPage"})
    public FormDesignResponse<String> createPage(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.service.create((PageTreeNode)page, this.getRootPath(page.getProjectPath()));
        }
        catch (FileExistsException fe) {
            response.setErrorCode("40010");
            response.setErrorMsg("\u6587\u4ef6\u5df2\u5b58\u5728");
            log.error(fe.getMessage());
        }
        catch (IOException e) {
            response.setErrorCode("40011");
            response.setErrorMsg("\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/deletePage"})
    public FormDesignResponse<String> deletePage(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.service.delete((PageTreeNode)page, this.getRootPath(page.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40012");
            response.setErrorMsg("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/updatePage"})
    public FormDesignResponse<String> updatePage(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.service.update((PageTreeNode)page, this.getRootPath(page.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/updateTableWithSave"})
    public FormDesignResponse<String> updateTableWithSave(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            response.setData(this.service.updateTableInfo(page, this.getRootPath(page.getProjectPath())));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/getPage"})
    public FormDesignResponse<Page> getPage(String path, String projectName) {
        FormDesignResponse<Page> response = new FormDesignResponse<Page>();
        try {
            response.setErrorCode("200");
            response.setData((Page)this.service.get(path, this.getRootPath(projectName)));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/listPage"})
    public FormDesignResponse<List<PageTreeNode>> listPage(String path) {
        FormDesignResponse<List<PageTreeNode>> response = new FormDesignResponse<List<PageTreeNode>>();
        try {
            response.setErrorCode("200");
            response.setData(this.service.listFileTreeNode(this.getRootPath(path)));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/listPageWithoutData"})
    public FormDesignResponse<List<Page>> listPageWithoutData(String path, String projectName) {
        FormDesignResponse<List<Page>> response = new FormDesignResponse<List<Page>>();
        try {
            response.setErrorCode("200");
            response.setData(this.service.listWithoutData(path, this.getRootPath(projectName)));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/createDirectory"})
    public FormDesignResponse<String> createDirectory(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            page.setCategory("page");
            page.setType("modular");
            this.projectService.createDirectory(page, this.getRootPath(page.getProjectPath()));
        }
        catch (FileExistsException fe) {
            response.setErrorCode("40010");
            response.setErrorMsg("\u6587\u4ef6\u5df2\u5b58\u5728");
            log.error(fe.getMessage());
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/deleteDirectory"})
    public FormDesignResponse<String> deleteDirectory(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.projectService.deleteDirectory(page, this.getRootPath(page.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/moveDirectory"})
    public FormDesignResponse<String> moveDirectory(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            Page page = new Page();
            page.setPath(vo.getSrcPath());
            page.setName(vo.getNewName());
            this.projectService.moveDirectory(page, vo.getNewPath(), this.getRootPath(vo.getProjectPath()), "");
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u79fb\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/movePage"})
    public FormDesignResponse<String> movePage(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            Page page = new Page();
            page.setName(vo.getNewName());
            page.setPath(vo.getSrcPath());
            this.service.move((PageTreeNode)page, vo.getNewPath(), this.getRootPath(vo.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u79fb\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/copyDirectory"})
    public FormDesignResponse<String> copyDirectory(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            Page page = new Page();
            page.setPath(vo.getSrcPath());
            page.setName(vo.getNewName());
            page.setDesc(vo.getNewDesc());
            this.projectService.copyDirectory(page, vo.getNewPath(), this.getRootPath(vo.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/copyPage"})
    public FormDesignResponse<String> copyPage(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            Page page = new Page();
            page.setPath(vo.getSrcPath());
            page.setName(vo.getNewName());
            page.setDesc(vo.getNewDesc());
            this.service.copy((PageTreeNode)page, vo.getNewPath(), this.getRootPath(vo.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/renameDirectory"})
    public FormDesignResponse<String> renameDirectory(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            Page page = new Page();
            page.setPath(vo.getSrcPath());
            page.setDesc(vo.getNewDesc());
            this.projectService.renameDirectory(page, vo.getNewName(), this.getRootPath(vo.getProjectPath()), "");
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u91cd\u547d\u540d\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/renamePage"})
    public FormDesignResponse<String> renamePage(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            Page page = new Page();
            page.setPath(vo.getSrcPath());
            page.setDesc(vo.getNewDesc());
            this.service.rename((PageTreeNode)page, vo.getNewName(), this.getRootPath(vo.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u91cd\u547d\u540d\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/updateDirectory"})
    public FormDesignResponse<String> updateDirectory(@RequestBody Page page) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.projectService.updateDirectory(page, this.getRootPath(page.getProjectPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            log.error(e.getMessage());
        }
        return response;
    }

    private String getRootPath(String projectName) {
        return this.projectPath + this.rootPath + projectName + this.pagePath;
    }
}

