/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.controller;

import com.jxdinfo.hussar.formdesign.desgin.form.model.BaseFile;
import com.jxdinfo.hussar.formdesign.desgin.form.model.CustomComponent;
import com.jxdinfo.hussar.formdesign.desgin.form.service.CustomComponentService;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.CustomComponentMoveVO;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customComponent"})
public class CustomComponentController {
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Value(value="${form-design.custom-component-store-path}")
    private String rootPath;
    @Autowired
    private CustomComponentService customComponentService;

    @RequestMapping(value={"/createCustomComponent"})
    public FormDesignResponse<String> createBaseFile(@RequestBody CustomComponent customComponent) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.customComponentService.create(customComponent, this.getRootPath());
        }
        catch (IOException e) {
            response.setErrorCode("40011");
            response.setErrorMsg("\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/deleteCustomComponent"})
    public FormDesignResponse<String> deleteBaseFile(@RequestBody CustomComponent customComponent) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.customComponentService.delete(customComponent, this.getRootPath());
        }
        catch (IOException e) {
            response.setErrorCode("40012");
            response.setErrorMsg("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/updateCustomComponent"})
    public FormDesignResponse<String> updateBaseFile(@RequestBody CustomComponent customComponent) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            response.setErrorCode("200");
            this.customComponentService.update(customComponent, this.getRootPath());
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/getCustomComponent"})
    public FormDesignResponse<CustomComponent> getBaseFile(String path) {
        FormDesignResponse<CustomComponent> response = new FormDesignResponse<CustomComponent>();
        try {
            response.setErrorCode("200");
            response.setData((CustomComponent)this.customComponentService.get(path, this.getRootPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/listCustomComponent"})
    public FormDesignResponse<List<CustomComponent>> listBaseFile(String path) {
        FormDesignResponse<List<CustomComponent>> response = new FormDesignResponse<List<CustomComponent>>();
        try {
            response.setErrorCode("200");
            response.setData(this.customComponentService.list(path, this.getRootPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/listCustomComponentWithoutData"})
    public FormDesignResponse<List<CustomComponent>> listBaseFileWithoutData(String path) {
        FormDesignResponse<List<CustomComponent>> response = new FormDesignResponse<List<CustomComponent>>();
        try {
            response.setErrorCode("200");
            ArrayList list = new ArrayList();
            response.setData(this.customComponentService.listWithoutData(path, this.getRootPath()));
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/moveCustomComponent"})
    public FormDesignResponse<List<BaseFile>> moveBaseFile(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<List<BaseFile>> response = new FormDesignResponse<List<BaseFile>>();
        try {
            response.setErrorCode("200");
            CustomComponent customComponent = new CustomComponent();
            customComponent.setPath(vo.getSrcPath());
            this.customComponentService.move(customComponent, vo.getNewPath(), this.getRootPath());
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u6587\u4ef6\u79fb\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/copyCustomComponent"})
    public FormDesignResponse<List<BaseFile>> copyBaseFile(@RequestBody CustomComponentMoveVO vo) {
        FormDesignResponse<List<BaseFile>> response = new FormDesignResponse<List<BaseFile>>();
        try {
            response.setErrorCode("200");
            CustomComponent customComponent = new CustomComponent();
            customComponent.setPath(vo.getSrcPath());
            this.customComponentService.copy(customComponent, vo.getNewPath(), this.getRootPath());
        }
        catch (IOException e) {
            response.setErrorCode("40013");
            response.setErrorMsg("\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    private String getRootPath() {
        return this.projectPath + this.rootPath;
    }
}

