/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.controller;

import com.jxdinfo.hussar.formdesign.desgin.form.model.BaseFile;
import com.jxdinfo.hussar.formdesign.desgin.form.service.CommonStyleService;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.CommonStyleVo;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/commonstyle"})
public class CommonStyleController {
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Value(value="${form-design.module-store-path}")
    private String rootPath;
    @Value(value="${form-design.css-code-store-path}")
    private String cssCodeStorePath;
    @Autowired
    CommonStyleService service;

    private String getRootPath(String userProjectPath) {
        return this.projectPath + this.rootPath + userProjectPath + "-CSS/";
    }

    private String getStaticPath() {
        return this.projectPath + this.cssCodeStorePath;
    }

    @RequestMapping(value={"/get"})
    public FormDesignResponse getCommonCss(@RequestBody CommonStyleVo vo) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            response.setData(this.service.get("/" + vo.getName(), this.getRootPath(vo.getProjectPath())));
            response.setErrorCode("200");
        }
        catch (Exception e) {
            response.setErrorCode("40011");
            response.setErrorMsg("\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }

    @RequestMapping(value={"/save"})
    public FormDesignResponse saveCommonCss(@RequestBody CommonStyleVo vo) {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        try {
            BaseFile file = new BaseFile();
            file.setName(vo.getName());
            file.setPath("/" + vo.getName());
            file.setProjectPath(vo.getProjectPath());
            file.setData(vo.getData());
            String rootPath = this.getRootPath(vo.getProjectPath());
            this.service.update(file, rootPath);
            this.service.genCommonCss(file, rootPath, this.getStaticPath());
            response.setData("");
            response.setErrorCode("200");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setErrorCode("40011");
            response.setErrorMsg("\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return response;
    }
}

