/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.event.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.generator.formdesign.config.designvo.ExcelFieldInfo;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableInfo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.contant.GodAxeExceptionType;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventActionsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.GenCodePreData;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.TableDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.GenPreDataUtil;
import com.jxdinfo.hussar.formdesign.desgin.event.BaseEvent;
import com.jxdinfo.hussar.formdesign.excel.template.ExcelConverterTem;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import com.jxdinfo.hussar.formdesign.jsparser.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportDataEvent
extends BaseEvent {
    @Override
    public String renderEventBody(EventActionsDto eventActionsDto, Map<String, ComponentDto> componentDtoMap, String eventName) throws GodAxeException {
        List<Map<String, String>> params = eventActionsDto.getParams();
        String listCellId = params.get(0).get("value");
        String template = "window.importTableCols = [[${tableCols}]];\n            layer.open({\n                type : 2,\n                title : '\u6a21\u677f\u5bfc\u5165',\n                area : ['100%', '100%'],\n                fix : false,\n                maxmin : false,\n                content : Hussar.ctxPath + \"${url}?url=\" + \"${urlForImport}\",\n                end : function() {\n                    ${tableReload};\n                }\n            });\n";
        ComponentDto listCell = componentDtoMap.get(listCellId);
        if (ToolUtil.isNotEmpty((Object)listCell)) {
            Map<String, TableDto> tableDtoMap = this.componentDto.getTableDtoMap();
            JSONObject data = listCell.getDatas();
            List tableNames = data.getJSONObject("relateTable").getJSONArray("tableName").toJavaList(String.class);
            if (tableNames.size() >= 1) {
                TableDto tableDto = tableDtoMap.get(tableNames.get(0));
                GenCodePreData genCodePreData = this.componentDto.getGenCodePreData();
                String url = genCodePreData.getModulePath() + "/" + genCodePreData.getPageName() + "/" + tableDto.getTableInfo().getEnName() + "/uploadPage";
                url = url.replace("//", "/");
                TableInfo tableInfo = GenPreDataUtil.getTableInfo((String)tableNames.get(0), genCodePreData);
                if (!tableInfo.isExportOrNot()) {
                    throw new GodAxeException(GodAxeExceptionType.NO_EXPORT_OR_IMPORT, tableInfo.getName());
                }
                tableInfo.addTableMethodControl("isImportData", true);
                String reload = "table.reload('" + listCell.getInstanceKey() + "_main')";
                String tableTemplate = "{title:\"${titleValue}\",\nfield:\"${fieldValue}\",\nminWidth:80,\nhide:${hide},\n},\n";
                List fields = JSONArray.parseArray((String)data.getJSONObject("relateTable").getJSONObject("relateFields").getString("col"), JSONObject.class);
                List hideFields = JSONArray.parseArray((String)data.getJSONObject("relateTable").getJSONObject("relateFields").getString("hiddenCol"), JSONObject.class);
                ArrayList<String> hideArr = new ArrayList<String>();
                if (ToolUtil.isNotEmpty((Object)hideFields)) {
                    for (JSONObject field : hideFields) {
                        hideArr.add(field.getString("tableFieldName"));
                    }
                    fields.addAll(hideFields);
                }
                JSONArray cols = (JSONArray)listCell.getProps().get("opt_cols");
                StringBuilder stringBuilder = new StringBuilder(128);
                Map fieldsRelate = (Map)data.getObject("fieldsRelate", (TypeReference)new TypeReference<Map<String, JSONObject>>(){});
                stringBuilder.append("{\"width\" : 60,\"type\" : \"numbers\",\"title\" : \"\u5e8f\u53f7\",\"align\" : \"center\",\"rowspan\" : 1},");
                ArrayList dicNameList = new ArrayList();
                for (JSONObject field : fields) {
                    String fieldVal = field.getString("tableFieldName");
                    String title = field.getJSONObject("col").getString("colName");
                    String id = field.getJSONObject("col").getString("id");
                    if (ToolUtil.isNotEmpty((Object)fieldVal)) {
                        stringBuilder.append(tableTemplate.replace("${titleValue}", title).replace("${fieldValue}", fieldVal).replace("${hide}", String.valueOf(hideArr.contains(fieldVal))));
                    }
                    if (!ToolUtil.isNotEmpty((Object)fieldsRelate) || !ToolUtil.isNotEmpty(fieldsRelate.get(id))) continue;
                    HashMap<String, String> dicNameMap = new HashMap<String, String>();
                    dicNameMap.put(((JSONObject)fieldsRelate.get(id)).getJSONObject("dictTypeID").getString("typeName"), fieldVal);
                    dicNameList.add(dicNameMap);
                    ExcelConverterTem excelConverterTem = new ExcelConverterTem();
                    excelConverterTem.setConverterType("String");
                    String javaName = StringUtils.firstToUpper(fieldVal) + "Converter";
                    excelConverterTem.setJavaName(javaName);
                    String importPath = (genCodePreData.getProPackage().replaceAll("\\.", "\\\\") + genCodePreData.getModulePath().replaceAll("/", "\\\\").toLowerCase() + "\\excelconverter\\" + javaName).replace("\\", ".");
                    excelConverterTem.setImportPath(importPath);
                    excelConverterTem.setDictValue(((JSONObject)fieldsRelate.get(id)).getJSONObject("dictTypeID").getString("typeName"));
                    genCodePreData.addExcelConverter(excelConverterTem);
                    tableInfo.getFields().forEach(f -> {
                        if (fieldVal.equals(f.getPropertyName())) {
                            ExcelFieldInfo excelFieldInfo = new ExcelFieldInfo();
                            excelFieldInfo.setImportPath(importPath);
                            excelFieldInfo.setJavaName(javaName);
                            excelFieldInfo.setConverter(true);
                            f.setExcelFieldInfo(excelFieldInfo);
                        }
                    });
                }
                tableInfo.getExcelInfo().setDicNameList(dicNameList);
                String urlForImport = genCodePreData.getModulePath() + "/" + genCodePreData.getPageName() + "/" + tableDto.getTableInfo().getEnName() + "/importData";
                urlForImport = urlForImport.replace("//", "/");
                return template.replace("${url}", url).replace("${tableReload}", reload).replace("${tableCols}", stringBuilder).replace("${urlForImport}", urlForImport);
            }
        }
        return "";
    }
}

