/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.event;

import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventActionsDto;
import com.jxdinfo.hussar.formdesign.desgin.event.EventFactory;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BaseEvent {
    protected ComponentDto componentDto;

    public BaseEvent() {
    }

    public BaseEvent(ComponentDto componentDto) {
        this.componentDto = componentDto;
    }

    public String renderEventBody(EventActionsDto eventActionsDto, Map<String, ComponentDto> componentDtoMap, String eventName) throws GodAxeException {
        return "";
    }

    private String renderCommonEvent(EventActionsDto eventActionsDto, Map<String, ComponentDto> componentDtoMap, String eventName) throws GodAxeException {
        StringBuilder retStr = new StringBuilder(128);
        Optional<BaseEvent> optionalBaseEvent = EventFactory.getOperation(eventActionsDto.getHandler());
        if (optionalBaseEvent.isPresent()) {
            BaseEvent baseEvent = optionalBaseEvent.get();
            baseEvent.setComponentDto(this.componentDto);
            retStr.append(baseEvent.renderEventBody(eventActionsDto, componentDtoMap, eventName));
        }
        return retStr.toString();
    }

    public String renderEvents(List<EventActionsDto> eventActionsDtos, Map<String, ComponentDto> componentDtoMap, String eventName) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(1024);
        for (EventActionsDto eventActionsDto : eventActionsDtos) {
            String cellEvent = this.renderCommonEvent(eventActionsDto, componentDtoMap, eventName);
            sbf.append(cellEvent.length() > 0 ? cellEvent : "").append("\n");
        }
        return sbf.toString();
    }

    public ComponentDto getComponentDto() {
        return this.componentDto;
    }

    public void setComponentDto(ComponentDto componentDto) {
        this.componentDto = componentDto;
    }
}

