/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;

public class TreeSelect
extends BaseCell {
    @Override
    public void setData(ComponentDto componentDto) {
        this.renderPorp = true;
        this.componentDto = componentDto;
    }

    @Override
    public void renderCellHTML(Element element) {
        boolean isAddCheckClass = true;
        Map<String, Object> mapProp = this.componentDto.getProps();
        if (((Boolean)mapProp.get("disabled")).booleanValue()) {
            isAddCheckClass = false;
            element.attr("disabled", "");
            element.addClass("layui-select-disabled");
        }
        if (!this.componentDto.getIsShow().booleanValue()) {
            isAddCheckClass = false;
        }
        if (null != mapProp.get("lay-search") && ((Boolean)mapProp.get("lay-search")).booleanValue()) {
            element.attr("lay-search", "");
        }
        boolean isNeedCheck = false;
        String checkType = "";
        if (ToolUtil.isNotEmpty((Object)mapProp.get("isChecked"))) {
            List checked = (List)mapProp.get("isChecked");
            for (Map check : checked) {
                if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                isNeedCheck = true;
                element.attr("require", true);
            }
        }
        if (ToolUtil.isNotEmpty((Object)mapProp.get("checkedType"))) {
            isNeedCheck = true;
            if ("number".equals(mapProp.get("checkedType"))) {
                element.attr("number", true);
            } else if ("email".equals(mapProp.get("checkedType"))) {
                element.attr("email", true);
            } else if ("date".equals(mapProp.get("checkedType"))) {
                element.attr("date", true);
            } else if ("http".equals(mapProp.get("checkedType"))) {
                element.attr("url", true);
            } else if ("phone".equals(mapProp.get("checkedType"))) {
                element.attr("phone", true);
            } else if ("identityCard".equals(mapProp.get("checkedType"))) {
                element.attr("identity", true);
            } else if ("fixAndMobile".equals(mapProp.get("checkedType"))) {
                element.attr("fixAndMobile", true);
            } else if ("decimals".equals(mapProp.get("checkedType"))) {
                element.attr("decimals", true);
            } else if ("fix".equals(mapProp.get("checkedType"))) {
                element.attr("fix", true);
            } else if ("positiveInteger".equals(mapProp.get("checkedType"))) {
                element.attr("positiveInteger", true);
            } else if ("isInteger".equals(mapProp.get("checkedType"))) {
                element.attr("isInteger", true);
            } else if ("isEnglish".equals(mapProp.get("checkedType"))) {
                element.attr("isEnglish", true);
            } else if ("isChinese".equals(mapProp.get("checkedType"))) {
                element.attr("isChinese", true);
            }
        }
        if (isNeedCheck && isAddCheckClass) {
            element.addClass("needCheck");
        }
        if (this.renderPorp) {
            element.attr("lay-filter", this.componentDto.getId());
        }
        if (mapProp.containsKey("tabindex")) {
            element.attr("tabindex", mapProp.get("tabindex").toString());
        }
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        StringBuilder sbf = new StringBuilder(128);
        sbf.append(" treeSelect.render({\n");
        String dicId = "";
        if (this.componentDto.getDatas().getJSONObject("relateTable").containsKey((Object)"dictTypeID")) {
            dicId = this.componentDto.getDatas().getJSONObject("relateTable").getJSONObject("dictTypeID").getString("id");
        }
        sbf.append("elem : '#").append(this.componentDto.getInstanceKey()).append("',\n");
        sbf.append("data : '/commonMethod/treeSelect/getDicData?dicId=").append(dicId).append("',\n").append("type : 'get',\n");
        String holder = "\u8bf7\u9009\u62e9";
        if (this.componentDto.getProps().containsKey("placeholder") && ToolUtil.isNotEmpty((Object)this.componentDto.getProps().get("placeholder"))) {
            holder = this.componentDto.getProps().get("placeholder").toString();
        }
        sbf.append("placeholder : '").append(holder).append("',\n").append("search : true,\n").append("style : {\n").append("folder:{\n").append("enable: false\n},").append("line:{\n").append("enable: false\n}").append("}\n");
        if (((Boolean)this.componentDto.getProps().get("disabled")).booleanValue()) {
            sbf.append(" ,disabledClass : true\n");
        }
        sbf.append("});\n");
        return sbf.toString();
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        contentBackground.append(this.componentDto.getStyle().toString().replace("=", ":").replace(",", ";").replace("{", "").replace("}", ";"));
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#layui_treeSelect_$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("borderHoverColor")) {
            content1.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#layui_treeSelect_$id:hover,#layui_treeSelect_$id:focus{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("placeholderColor")) {
            content2.append("color:").append(props.get("placeholderColor")).append(";").append("\n");
        }
        if (props.containsKey("placeholderFontSize")) {
            content2.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (props.containsKey("placeholderPosition")) {
            content2.append("text-align:").append(props.get("placeholderPosition")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            String template = "#treeSelect_input_$id::-webkit-input-placeholder{\n $content}\n#treeSelect_input_$id::-moz-placeholder{\n $content}\n#treeSelect_input_$id:-moz-placeholder{\n $content}\n#treeSelect_input_$id:-ms-input-placeholder{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        StringBuilder content3 = new StringBuilder();
        if (props.containsKey("placeholderFontSize")) {
            content3.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (content3.length() > 0) {
            String template = "#treeSelect_input_$id:placeholder-shown{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content3);
            result.append(template).append("\n");
        }
        StringBuilder content4 = new StringBuilder();
        if (props.containsKey("disabledBg")) {
            content4.append("background:").append(props.get("disabledBg")).append(";").append("\n");
        }
        if (content4.length() > 0) {
            String template = "#layui_treeSelect_$id .layui-select-disabled,#layui_treeSelect_$id .layui-select-disabled:hover{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content4);
            result.append(template).append("\n");
        }
        StringBuilder hoverStyle = new StringBuilder();
        if (interactive.containsKey("hover")) {
            Object hovers = interactive.get("hover");
            for (Map.Entry entry : ((Map)hovers).entrySet()) {
                hoverStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (hoverStyle.length() > 0) {
            String template = "#treeSelect_input_$id:not(:disabled):hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", hoverStyle);
            result.append(template).append("\n");
        }
        StringBuilder readonlyStyle = new StringBuilder();
        if (interactive.containsKey("readonly")) {
            Object readonlys = interactive.get("readonly");
            for (Map.Entry entry : ((Map)readonlys).entrySet()) {
                readonlyStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (readonlyStyle.length() > 0) {
            String template = "#treeSelect_input_$id:read-only{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", readonlyStyle);
            result.append(template).append("\n");
        }
        StringBuilder contentOption = new StringBuilder();
        if (props.containsKey("optionSelectBg")) {
            contentOption.append("background:").append(props.get("optionSelectBg")).append(";").append("\n");
        }
        if (props.containsKey("optionSelectColor")) {
            contentOption.append("color:").append(props.get("optionSelectColor")).append(";").append("\n");
        }
        if (contentOption.length() > 0) {
            String string3 = "#layui_treeSelect_$id .ztree li a.curSelectedNode{\n $content}";
            string3 = string3.replace("$id", this.componentDto.getInstanceKey());
            string3 = string3.replace("$content", contentOption);
            result.append(string3).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            if (!EventTriggerEnums.CHANGE.getValue().equals(eventConfigsDto.getTrigger())) continue;
            sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").change(function(e){").append("\n");
            String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }

    @Override
    public String renderNormalActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').addClass(\"needCheck\");";
        }
        returnStr = returnStr + "$('#treeSelect_anim_" + this.componentDto.getInstanceKey() + "').removeAttr('style','display:block');\n$('#layui_treeSelect_" + this.componentDto.getInstanceKey() + "').removeClass(\"layui-select-disabled\");\n$('#layui_treeSelect_" + this.componentDto.getInstanceKey() + "').show();\n";
        return returnStr;
    }

    @Override
    public String renderHideActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#layui_treeSelect_" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
        }
        returnStr = returnStr + "$('#layui_treeSelect_" + this.componentDto.getInstanceKey() + "').hide();\n";
        return returnStr;
    }

    @Override
    public String renderSetDisableActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#layui_treeSelect_" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
        }
        returnStr = returnStr + "$('#treeSelect_anim_" + this.componentDto.getInstanceKey() + "').attr('style','display:none');\n$('#layui_treeSelect_" + this.componentDto.getInstanceKey() + "').addClass(\"layui-select-disabled\");\n";
        return returnStr;
    }
}

