/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.ComponentUtil;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Tab
extends BaseCell {
    @Override
    public void prepareEmbedElementRender(Map<String, ComponentDto> componentDtoMap) {
        JSONArray tabList = (JSONArray)this.componentDto.getProps().get("tabLists");
        for (Object o : tabList) {
            JSONObject jo = (JSONObject)o;
            JSONObject instanceConfigJO = (JSONObject)jo.get((Object)"instanceConfig");
            if (instanceConfigJO == null) continue;
            Map embedElementMap = (Map)instanceConfigJO.getObject("instanceConfig", (TypeReference)new TypeReference<Map<String, ComponentDto>>(){});
            String rootInstanceKey = instanceConfigJO.getString("rootInstanceKey");
            this.slots.put(jo.getString("value"), rootInstanceKey);
            this.componentDto.getChildren().add(rootInstanceKey);
        }
    }

    @Override
    public void dealEmbedElementRendered(Element element) {
        Element contentDiv = new Element("div");
        contentDiv.addClass("layui-tab-content");
        Element ul = new Element("ul");
        ul.addClass("layui-tab-title");
        List tabList = (List)this.componentDto.getProps().get("tabLists");
        for (Map map : tabList) {
            Element li = new Element("li");
            li.append(map.get("text").toString());
            if (ul.childNodeSize() == 0) {
                li.addClass("layui-this");
            }
            ul.appendChild((Node)li);
            Element div = new Element("div");
            String contentRootInstanceKey = null;
            if (ToolUtil.isNotEmpty(map.get("value"))) {
                contentRootInstanceKey = (String)this.slots.get(map.get("value").toString());
            }
            if (ToolUtil.isNotEmpty(contentRootInstanceKey)) {
                div.appendChild((Node)element.getElementById(contentRootInstanceKey));
            } else {
                JSONObject obj = (JSONObject)map.get("tabPagePath");
                if (ToolUtil.isNotEmpty((Object)obj)) {
                    String pagePath = obj.getString("pagePath");
                    if (ToolUtil.isNotEmpty((Object)pagePath)) {
                        String tabHeight = this.componentDto.getStyle().get("height");
                        Element iframe = new Element("iframe");
                        iframe.attr("src", ComponentUtil.getViewStr(pagePath));
                        iframe.attr("scrolling", "yes");
                        iframe.attr("frameborder", "0");
                        iframe.attr("width", "100%");
                        iframe.attr("height", "100%");
                        div.appendChild((Node)iframe);
                    }
                } else {
                    div.append(map.get("content").toString());
                }
            }
            div.addClass("layui-tab-item");
            if (contentDiv.childNodeSize() == 0) {
                div.addClass("layui-show");
            }
            contentDiv.appendChild((Node)div);
        }
        element.html("");
        element.addClass((String)this.componentDto.getProps().get("type"));
        element.appendChild((Node)ul);
        element.appendChild((Node)contentDiv);
    }

    @Override
    public void renderCellHTML(Element element) {
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        return null;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("headerFontColor")) {
            content.append("color:").append(props.get("headerFontColor")).append(";").append("\n");
        }
        if (props.containsKey("headerFontSize")) {
            content.append("font-size:").append(props.get("headerFontSize")).append(";").append("\n");
        }
        if (props.containsKey("headerFontWeight")) {
            content.append("font-weight:").append(props.get("headerFontWeight")).append(";").append("\n");
        }
        if (content.length() > 0) {
            String template = "#$id .layui-tab-title{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("activeItemColor")) {
            content1.append("color:").append(props.get("activeItemColor")).append(";").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id .layui-tab-title>li.layui-this{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("activeBarColor")) {
            content2.append("border-bottom-color:").append(props.get("activeBarColor")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            String template = "#$id.layui-tab-brief>.layui-tab-more li.layui-this:after,#$id.layui-tab-brief>.layui-tab-title .layui-this:after{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        String templateShow = "#$id .layui-show > div{\n width: 100% !important}";
        templateShow = templateShow.replace("$id", this.componentDto.getInstanceKey());
        result.append(templateShow);
        return result.toString();
    }
}

