/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class SelectFreeFlowNode
extends BaseCell {
    @Override
    public void setData(ComponentDto componentDto) {
        this.renderPorp = true;
        this.componentDto = componentDto;
    }

    @Override
    public void renderCellHTML(Element element) {
        Map<String, Object> mapProp = this.componentDto.getProps();
        Element select = new Element("select");
        JSONObject selectName = this.componentDto.getDatas().getJSONObject("value");
        if (ToolUtil.isNotEmpty((Object)selectName) && ToolUtil.isNotEmpty((Object)selectName.getJSONObject("value"))) {
            select.attr("name", selectName.getJSONObject("value").getString("fieldName"));
        }
        select.attr("id", "jxd_next_node");
        if (((Boolean)mapProp.get("disabled")).booleanValue()) {
            select.attr("disabled", "");
        }
        if (null != mapProp.get("lay-search") && ((Boolean)mapProp.get("lay-search")).booleanValue()) {
            select.attr("lay-search", "");
        }
        boolean isNeedCheck = false;
        String checkType = "";
        if (ToolUtil.isNotEmpty((Object)mapProp.get("isChecked"))) {
            List checked = (List)mapProp.get("isChecked");
            for (Map check : checked) {
                if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                isNeedCheck = true;
                select.attr("requiredforselect", true);
            }
        }
        if (ToolUtil.isNotEmpty((Object)mapProp.get("checkedType"))) {
            isNeedCheck = true;
            if ("number".equals(mapProp.get("checkedType"))) {
                select.attr("number", true);
            } else if ("email".equals(mapProp.get("checkedType"))) {
                select.attr("email", true);
            } else if ("date".equals(mapProp.get("checkedType"))) {
                select.attr("date", true);
            } else if ("http".equals(mapProp.get("checkedType"))) {
                select.attr("url", true);
            } else if ("phone".equals(mapProp.get("checkedType"))) {
                select.attr("phone", true);
            } else if ("identityCard".equals(mapProp.get("checkedType"))) {
                select.attr("identity", true);
            }
        }
        if (isNeedCheck) {
            select.addClass("needCheck");
        }
        if (this.renderPorp) {
            select.attr("lay-filter", this.componentDto.getId());
        }
        element.attr("id", this.componentDto.getInstanceKey() + "_container");
        element.appendChild((Node)select);
        this.renderAttribute(select);
    }

    @Override
    public String renderPreloadDataScript(Map<String, Object> cellProperties) {
        this.componentDto.getGenCodePreData().addFlowControl("nextNodeQuery", true);
        StringBuilder res = new StringBuilder(128);
        String defaultValue = "";
        boolean connect = Boolean.valueOf(cellProperties.get("connectNextNode").toString());
        String url = "\"" + this.componentDto.getGenCodePreData().getModulePath() + "/" + this.componentDto.getGenCodePreData().getPageName() + "/nextNodeQuery?taskId=\" + window.taskId";
        res.append(this.replaceContent(url, defaultValue, connect));
        return res.toString();
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        String template;
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template2 = "#$id{\n $content}";
            template2 = template2.replace("$id", this.componentDto.getInstanceKey());
            template2 = template2.replace("$content", contentBackground);
            result.append(template2).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("borderHoverColor")) {
            content.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content.length() > 0) {
            String template3 = "#$id:hover,#$id:focus{\n $content}";
            template3 = template3.replace("$id", this.componentDto.getInstanceKey() + "_container");
            template3 = template3.replace("$content", content);
            result.append(template3).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("optionSelectBg")) {
            content1.append("background:").append(props.get("optionSelectBg")).append(";").append("\n");
        }
        if (props.containsKey("optionSelectColor")) {
            content1.append("color:").append(props.get("optionSelectColor")).append(";").append("\n");
        }
        if (content1.length() > 0) {
            String template4 = "#$id .layui-form-select dl dd.layui-this{\n $content}";
            template4 = template4.replace("$id", this.componentDto.getInstanceKey() + "_container");
            template4 = template4.replace("$content", content1);
            result.append(template4).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("disabledBg")) {
            content2.append("background:").append(props.get("disabledBg")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            template = "#$id .layui-form-select.layui-select-disabled{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey() + "_container");
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        if (this.componentDto.getStyle().containsKey("height")) {
            template = "#$id .layui-form-select .layui-input{\n height:100%}\n#$id .layui-form-select .layui-select-title{\n height:100%}\n#$id .layui-form-select{\n height:100%}";
            template = template.replace("$id", this.componentDto.getInstanceKey() + "_container");
            result.append(template).append("\n");
        }
        return result.toString();
    }

    private String replaceContent(String requestPath, String defaultValue, boolean connect) {
        String template = "var ajax_${instanceId} = new $ax(Hussar.ctxPath + ${requestMapping},function(result){\n\tvar options = ${result};\n\tfor(var i = 0; i < options.length; i++){\n\t\tif(options[i] != null){\n\t\t\tvar temp = \"\";\n\t\t\t${defaultValueSince}\n\t\t\t$(\"#${instanceId}\").append('${itemContent}');\n\t\t}\n\t}\n\tform.render(\"${type}\");\n${queryFirst}});\najax_${instanceId}.start();\n${onChange}";
        String queryFirst = "";
        String onChange = "";
        if (connect) {
            queryFirst = "getNextNodeAssign($(\"#${instanceId}\").val())";
            onChange = "var ${insId}_on_select = form.on('select(${insId})',function (data) {\n\tvar nextNodeAssign = $(\"#jxd_next_node_assign_query\");\n\tif (nextNodeAssign !== undefined && nextNodeAssign != null && nextNodeAssign.length ===1 && data.value !== ''){\n\t\tgetNextNodeAssign(data.value);\n}\n})\n";
        }
        String defaultValueContent = "";
        if (ToolUtil.isNotEmpty((Object)defaultValue)) {
            defaultValueContent = "if(options[i].value == " + defaultValue + "){\ntemp = \"selected \";\n}";
        }
        return template.replace("${instanceId}", "jxd_next_node").replace("${insId}", this.componentDto.getInstanceKey()).replace("${result}", "result.result").replace("${requestMapping}", requestPath).replace("${htmlContent}", "<option value=\"\"></option>").replace("${defaultValueSince}", defaultValueContent).replace("${itemContent}", "<option '+temp+'value=\"' + options[i].id + '\">' + options[i].name + '</option>").replace("${type}", "select").replace("${queryFirst}", queryFirst.replace("${instanceId}", "jxd_next_node")).replace("${onChange}", onChange.replace("${insId}", this.componentDto.getInstanceKey()));
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            if (!EventTriggerEnums.CHANGE.getValue().equals(eventConfigsDto.getTrigger())) continue;
            sbf.append("form.on(\"select(").append(this.componentDto.getInstanceKey()).append(")\",function(data){").append("\n");
            String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }

    @Override
    public String renderNormalActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').addClass(\"needCheck\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeAttr(\"disabled\");\n$('#" + this.componentDto.getInstanceKey() + "_container').removeClass(\"layui-hide\");\nform.render();";
        return returnStr;
    }

    @Override
    public String renderHideActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "_container').removeClass(\"error\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "_container').addClass(\"layui-hide\");\nform.render();";
        return returnStr;
    }

    @Override
    public String renderSetReadonlyActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "_container').removeClass(\"error\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').attr('readonly',true);\nform.render();";
        return returnStr;
    }

    @Override
    public String renderSetDisableActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "_container').removeClass(\"error\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').attr('disabled',true);\nform.render()";
        return returnStr;
    }

    @Override
    public String renderGetValue() {
        return "$('#" + this.componentDto.getInstanceKey() + " option:checked').val()";
    }

    @Override
    public String renderClearValue() {
        return super.renderClearValue() + "form.render();\n";
    }
}

