/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;

public class Label
extends BaseCell {
    @Override
    public void renderCellHTML(Element element) {
        Object obj = this.componentDto.getProps().get("isRequired");
        if (null != obj && ((Boolean)obj).booleanValue()) {
            element.addClass("required");
        }
        String text = this.componentDto.getProps().get("text").toString().replace(" ", "&nbsp;");
        if (this.componentDto.getInsField() != null) {
            text = "{{d." + this.componentDto.getInsField() + "}}";
        }
        element.append(text);
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        return null;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder hoverStyle = new StringBuilder();
        if (interactive.containsKey("hover")) {
            Object hovers = interactive.get("hover");
            for (Map.Entry map : ((Map)hovers).entrySet()) {
                hoverStyle.append((String)map.getKey()).append(":").append((String)map.getValue()).append("!important;").append("\n");
            }
        }
        if (hoverStyle.length() > 0) {
            String template = "#$id.layui-form-label:hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", hoverStyle);
            result.append(template).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            sbf.append(CellEventUtil.clickEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
        }
        return sbf.toString();
    }
}

