/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class InputAddParticipant
extends BaseCell {
    @Override
    public void setData(ComponentDto componentDto) {
        this.renderPorp = true;
        this.componentDto = componentDto;
    }

    @Override
    public void renderCellHTML(Element element) {
        Map<String, Object> mapProp = this.componentDto.getProps();
        Element input = new Element("input");
        JSONObject inputName = this.componentDto.getDatas().getJSONObject("value");
        if (ToolUtil.isNotEmpty((Object)inputName) && ToolUtil.isNotEmpty((Object)inputName.getJSONObject("value"))) {
            input.attr("name", inputName.getJSONObject("value").getString("fieldName"));
        }
        input.attr("id", "jxd_next_node_assign");
        input.attr("class", "layui-input");
        input.attr("readonly", "true");
        if (((Boolean)mapProp.get("disabled")).booleanValue()) {
            input.attr("disabled", "");
        }
        String checkType = "";
        if (ToolUtil.isNotEmpty((Object)mapProp.get("isChecked"))) {
            List checked = (List)mapProp.get("isChecked");
            for (Map check : checked) {
                if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                checkType = "required|";
            }
        }
        if (ToolUtil.isNotEmpty((Object)checkType)) {
            input.attr("lay-verify", checkType.substring(0, checkType.length() - 1));
        }
        if (this.renderPorp) {
            input.attr("lay-filter", this.componentDto.getId());
        }
        if (ToolUtil.isNotEmpty((Object)mapProp.get("placeholder"))) {
            String inputStyle = mapProp.get("placeholder").toString();
            input.attr("placeholder", inputStyle);
        }
        Element inputHide = new Element("input");
        inputHide.attr("id", "jxd_next_node_assign_val");
        inputHide.attr("type", "hidden");
        element.appendChild((Node)input);
        element.appendChild((Node)inputHide);
        this.renderAttribute(input);
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("borderHoverColor")) {
            content1.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id.layui-input-participant input:hover,#$id.layui-input-participant input:focus{\n $content}";
            template = template.replace("$id", this.componentDto.getId());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("placeholderColor")) {
            content2.append("color:").append(props.get("placeholderColor")).append(";").append("\n");
        }
        if (props.containsKey("placeholderFontSize")) {
            content2.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (props.containsKey("placeholderPosition")) {
            content2.append("text-align:").append(props.get("placeholderPosition")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            String template = "#$id.layui-input-participant input::-webkit-input-placeholder{\n $content}\n#$id.layui-input-participant input::-moz-placeholder{\n $content}\n#$id.layui-input-participant input:-moz-placeholder{\n $content}\n#$id.layui-input-participant input:-ms-input-placeholder{\n $content}\n";
            template = template.replace("$id", this.componentDto.getId());
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        StringBuilder content3 = new StringBuilder();
        if (props.containsKey("placeholderFontSize")) {
            content3.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (content3.length() > 0) {
            String template = "#$id.layui-input-participant input:placeholder-shown{\n $content}\n";
            template = template.replace("$id", this.componentDto.getId());
            template = template.replace("$content", content3);
            result.append(template).append("\n");
        }
        StringBuilder content4 = new StringBuilder();
        if (props.containsKey("disabledBg")) {
            content4.append("background:").append(props.get("disabledBg")).append(";").append("\n");
        }
        if (content4.length() > 0) {
            String template = "#$id.layui-input-participant input:disabled,#$id.layui-input-participant input:disabled:hover{\n $content}\n";
            template = template.replace("$id", this.componentDto.getId());
            template = template.replace("$content", content4);
            result.append(template).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            String conditions;
            sbf.append(CellEventUtil.changeEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
            sbf.append(CellEventUtil.clickEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
            if (EventTriggerEnums.FOCUS.getValue().equals(eventConfigsDto.getTrigger())) {
                sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").focus(function(e){").append("\n");
                conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
                sbf.append(conditions);
                sbf.append("});").append("\n");
            }
            if (!EventTriggerEnums.BLUR.getValue().equals(eventConfigsDto.getTrigger())) continue;
            sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").blur(function(e){").append("\n");
            conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }

    @Override
    public String renderSetDisableActionScript(boolean isNeedCheck) {
        String returnStr = "";
        returnStr = "$('#jxd_next_node_assign').attr('disabled',true);";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"error\");";
        }
        return returnStr;
    }

    @Override
    public String renderNormalActionScript(boolean isNeedCheck) {
        String returnStr = "";
        returnStr = "$('#jxd_next_node_assign').removeAttr(\"disabled\");\n$('#" + this.componentDto.getInstanceKey() + "').show();\n";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').addClass(\"needCheck\");";
        }
        return returnStr;
    }
}

