/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;

public class Input
extends BaseCell {
    @Override
    public void renderCellHTML(Element element) {
        Map<String, String> dMap;
        Map customRule;
        Map<String, Object> prop = this.componentDto.getProps();
        if (ToolUtil.isNotEmpty((Object)prop.get("type")) && "password".equals(prop.get("type"))) {
            element.attr("autocomplete", "new-password");
        } else {
            element.attr("autocomplete ", "off");
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("disabled")) && ((Boolean)prop.get("disabled")).booleanValue()) {
            element.attr("disabled", "");
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("readonly")) && ((Boolean)prop.get("readonly")).booleanValue()) {
            element.attr("readonly", "");
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("placeholder"))) {
            String inputStyle = prop.get("placeholder").toString();
            element.attr("placeholder", inputStyle);
        }
        boolean isNeedCheck = false;
        if (ToolUtil.isNotEmpty((Object)prop.get("isChecked"))) {
            List checked = (List)prop.get("isChecked");
            for (Map check : checked) {
                if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                isNeedCheck = true;
                element.attr("require", true);
            }
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("checkedType"))) {
            isNeedCheck = true;
            if ("number".equals(prop.get("checkedType"))) {
                element.attr("number", true);
            } else if ("email".equals(prop.get("checkedType"))) {
                element.attr("email", true);
            } else if ("date".equals(prop.get("checkedType"))) {
                element.attr("date", true);
            } else if ("http".equals(prop.get("checkedType"))) {
                element.attr("url", true);
            } else if ("phone".equals(prop.get("checkedType"))) {
                element.attr("phone", true);
            } else if ("identityCard".equals(prop.get("checkedType"))) {
                element.attr("identity", true);
            } else if ("fixAndMobile".equals(prop.get("checkedType"))) {
                element.attr("fixAndMobile", true);
            } else if ("decimals".equals(prop.get("checkedType"))) {
                element.attr("decimals", true);
            } else if ("fix".equals(prop.get("checkedType"))) {
                element.attr("fix", true);
            } else if ("positiveInteger".equals(prop.get("checkedType"))) {
                element.attr("positiveInteger", true);
            } else if ("isInteger".equals(prop.get("checkedType"))) {
                element.attr("isInteger", true);
            } else if ("isEnglish".equals(prop.get("checkedType"))) {
                element.attr("isEnglish", true);
            } else if ("isChinese".equals(prop.get("checkedType"))) {
                element.attr("isChinese", true);
            }
        }
        if (prop.containsKey("customRule") && ToolUtil.isNotEmpty((Object)prop.get("customRule")) && Boolean.valueOf((customRule = (Map)prop.get("customRule")).get("isCustomRule").toString()).booleanValue()) {
            isNeedCheck = true;
            List customRules = (List)customRule.get("customRules");
            for (int i = 0; i < customRules.size(); ++i) {
                element.attr(this.componentDto.getInstanceKey() + "_ver" + (i + 1), true);
            }
        }
        if (isNeedCheck) {
            element.addClass("needCheck");
        }
        if (ToolUtil.isNotEmpty(dMap = this.componentDto.getDefaultValue()) && ToolUtil.isNotEmpty((Object)dMap.get("value"))) {
            element.attr("value", dMap.get("value"));
        }
        this.renderAttribute(element);
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        return null;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("borderHoverColor")) {
            content1.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id:hover,#$id:focus{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("placeholderColor")) {
            content2.append("color:").append(props.get("placeholderColor")).append(";").append("\n");
        }
        if (props.containsKey("placeholderFontSize")) {
            content2.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (props.containsKey("placeholderPosition")) {
            content2.append("text-align:").append(props.get("placeholderPosition")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            String template = "#$id::-webkit-input-placeholder{\n $content}\n#$id::-moz-placeholder{\n $content}\n#$id:-moz-placeholder{\n $content}\n#$id:-ms-input-placeholder{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        StringBuilder content3 = new StringBuilder();
        if (props.containsKey("placeholderFontSize")) {
            content3.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (content3.length() > 0) {
            String template = "#$id:placeholder-shown{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content3);
            result.append(template).append("\n");
        }
        StringBuilder content4 = new StringBuilder();
        if (props.containsKey("disabledBgColor")) {
            content4.append("background:").append(props.get("disabledBgColor")).append(";").append("\n");
        }
        if (content4.length() > 0) {
            String template = "#$id.layui-input:disabled,#$id.layui-input:disabled:hover{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content4);
            result.append(template).append("\n");
        }
        StringBuilder hoverStyle = new StringBuilder();
        if (interactive.containsKey("hover")) {
            Object hovers = interactive.get("hover");
            for (Map.Entry entry : ((Map)hovers).entrySet()) {
                hoverStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (hoverStyle.length() > 0) {
            String template = "#$id.layui-input:not(:disabled):hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", hoverStyle);
            result.append(template).append("\n");
        }
        StringBuilder focusStyle = new StringBuilder();
        if (interactive.containsKey("focus")) {
            Object focuss = interactive.get("focus");
            for (Map.Entry entry : ((Map)focuss).entrySet()) {
                focusStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (focusStyle.length() > 0) {
            String template = "#$id.layui-input:not(:disabled):focus{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", focusStyle);
            result.append(template).append("\n");
        }
        StringBuilder readonlyStyle = new StringBuilder();
        if (interactive.containsKey("readonly")) {
            Object object = interactive.get("readonly");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                readonlyStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (readonlyStyle.length() > 0) {
            String string3 = "#$id.layui-input:read-only{\n $content}";
            string3 = string3.replace("$id", this.componentDto.getInstanceKey());
            string3 = string3.replace("$content", readonlyStyle);
            result.append(string3).append("\n");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (interactive.containsKey("disabled")) {
            Object object = interactive.get("disabled");
            for (Map.Entry map : ((Map)object).entrySet()) {
                stringBuilder.append((String)map.getKey()).append(":").append((String)map.getValue()).append("!important;").append("\n");
            }
        }
        if (stringBuilder.length() > 0) {
            String string5 = "#$id.layui-input:disabled{\n $content}";
            string5 = string5.replace("$id", this.componentDto.getInstanceKey());
            string5 = string5.replace("$content", stringBuilder);
            result.append(string5).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        String insFormat = "";
        if (this.componentDto.getProps().containsKey("format")) {
            JSONObject formatObject = (JSONObject)this.componentDto.getProps().get("format");
            insFormat = CellEventUtil.getFormatTemplet(this.componentDto, formatObject);
            insFormat = insFormat + "$(\"#" + this.componentDto.getInstanceKey() + "\").val(formatVal);\n";
            insFormat = insFormat + "$(\"#" + this.componentDto.getInstanceKey() + "\").trigger(\"input\");\n";
        }
        StringBuilder sbf = new StringBuilder(128);
        boolean isChange = false;
        String changeStr = "";
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            String conditions;
            if (EventTriggerEnums.CHANGE.getValue().equals(eventConfigsDto.getTrigger())) {
                isChange = true;
                changeStr = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            }
            sbf.append(CellEventUtil.changeEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
            sbf.append(CellEventUtil.clickEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
            if (EventTriggerEnums.FOCUS.getValue().equals(eventConfigsDto.getTrigger())) {
                sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").focus(function(e){").append("\n");
                conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
                sbf.append(conditions);
                sbf.append("});").append("\n");
            }
            if (!EventTriggerEnums.BLUR.getValue().equals(eventConfigsDto.getTrigger())) continue;
            sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").blur(function(e){").append("\n");
            conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        if (this.componentDto.getProps().containsKey("format") || isChange) {
            sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").change(function(e){").append("\n");
            sbf.append(changeStr);
            sbf.append(insFormat);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }
}

