/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;

public class Icon
extends BaseCell {
    @Override
    public void renderCellHTML(Element element) {
        Map iconSetting = (Map)this.componentDto.getProps().get("changeIcon");
        if (iconSetting.containsKey("fontClassName")) {
            String className;
            element.addClass((String)iconSetting.get("fontClassName"));
            String code = iconSetting.containsKey("code") ? (String)iconSetting.get("code") : "";
            String string = className = iconSetting.containsKey("class") ? (String)iconSetting.get("class") : "";
            if ("".equals(className)) {
                element.html(code);
            } else {
                element.addClass(className);
            }
        }
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        return null;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("iconColor")) {
            content.append("color:").append(props.get("iconColor")).append(";").append("\n");
        }
        if (props.containsKey("iconSize")) {
            content.append("font-size:").append(props.get("iconSize")).append(";").append("\n");
        }
        if (content.length() > 0) {
            String template = "#$id.layui-icon{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content);
            result.append(template).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            if (!EventTriggerEnums.CLICK.getValue().equals(eventConfigsDto.getTrigger())) continue;
            String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            if (this.componentDto.isInChildPage() && "layTable".equals(this.componentDto.getParentPageType())) {
                sbf.append("function ").append(this.componentDto.getInstanceKey()).append("_trigger(d){\n").append(conditions).append("};\n");
                continue;
            }
            sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").click(function(e){").append("\n").append("\tif(").append("$(\"#").append(this.componentDto.getInstanceKey()).append("\").attr(\"disabled\")").append("){\n\t\treturn;\n\t}\n");
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }
}

