/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.nodes.Element;
import org.springframework.stereotype.Component;

@Component
public class HandlingHistory
extends BaseCell {
    private static final Logger log = LogManager.getLogger(HandlingHistory.class);

    @Override
    public void setData(ComponentDto componentDto) {
        super.setData(componentDto);
        this.renderPorp = false;
    }

    @Override
    public void prepareEmbedElementRender(Map<String, ComponentDto> componentDtoMap) {
        JSONArray ja = (JSONArray)this.componentDto.getProps().get("opt_cols");
        int i = 0;
        for (Object o : ja) {
            Map embedElementMap;
            JSONObject instanceConfigJO;
            boolean isTemplate;
            JSONObject jsonObject = (JSONObject)o;
            boolean bl = isTemplate = null == jsonObject.get((Object)"template") ? false : jsonObject.getBoolean("template");
            if (isTemplate && (instanceConfigJO = (JSONObject)jsonObject.get((Object)"instanceConfig")) != null && ToolUtil.isNotEmpty((Object)(embedElementMap = (Map)instanceConfigJO.getObject("instances", (TypeReference)new TypeReference<Map<String, ComponentDto>>(){})))) {
                String rootInstanceKey = instanceConfigJO.getString("rootInstanceKey");
                this.slots.put(String.valueOf(i), rootInstanceKey);
                for (ComponentDto tmp : embedElementMap.values()) {
                    tmp.setTemplatesParentInstanceKey(this.componentDto.getInstanceKey());
                    tmp.setIsRecycleComponent(true);
                }
                componentDtoMap.putAll(embedElementMap);
                this.componentDto.getChildren().add(rootInstanceKey);
            }
            ++i;
        }
    }

    @Override
    public void renderCellHTML(Element element) {
        String iframe = " <table class=\"layui-table\" id=\"processpicListTable\" ></table>";
        element.html(iframe);
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            if (!EventTriggerEnums.TABLE_CELL_VALUE_CHANGE.getValue().equals(eventConfigsDto.getTrigger())) continue;
            sbf.append("var ").append(this.componentDto.getInstanceKey()).append("_listener_edit = ");
            if (ToolUtil.isNotEmpty((Object)this.componentDto.getProps().get("colEdit"))) {
                sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("\")").append(".on(\"").append(this.componentDto.getInstanceKey()).append("_dataChange\"");
            } else {
                sbf.append("table.on('edit(").append(this.componentDto.getInstanceKey()).append(")'");
            }
            sbf.append(", function(obj){").append("\n");
            String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }

    @Override
    public String renderGetValue() {
        return "table.cache[\"" + this.componentDto.getInstanceKey() + "_main\"]";
    }

    @Override
    public String renderGetData(String dataField) {
        return "table.cache[\"" + this.componentDto.getInstanceKey() + "_main\"]";
    }

    @Override
    public void dealEmbedElementRendered(Element element) {
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        StringBuilder sbf = new StringBuilder(512);
        JSONArray cloums = (JSONArray)cellProperties.get("opt_cols");
        StringBuilder cloumsAll = new StringBuilder();
        String instanceKey = this.componentDto.getInstanceKey();
        if (ToolUtil.isNotEmpty((Object)cellProperties.get("showIndex")) && ((Boolean)cellProperties.get("showIndex")).booleanValue()) {
            StringBuilder obj = new StringBuilder();
            obj.append("{").append("\n");
            obj.append("\"width\"").append(":").append("60").append(",").append("\n");
            obj.append("\"type\"").append(":").append("\"numbers\"").append(",").append("\n");
            obj.append("\"title\"").append(":").append("\"\u5e8f\u53f7\"").append(",").append("\n");
            obj.append("\"align\"").append(":").append("\"center\"").append(",").append("\n");
            obj.append("}").append(",").append("\n");
            cloumsAll.append((CharSequence)obj);
        }
        boolean isAutoHeight = false;
        if (ToolUtil.isNotEmpty((Object)cellProperties.get("autoHeight"))) {
            isAutoHeight = Boolean.valueOf(cellProperties.get("autoHeight").toString());
        }
        String tableTemplate = "function ${instanceId}_table() {\n\ttable.render({\n\t\telem:'#processpicListTable',\n";
        if (!isAutoHeight) {
            tableTemplate = tableTemplate + "\t\theight:parseInt($('#${instanceId}').height()),\n";
        }
        tableTemplate = tableTemplate + "\t\turl:Hussar.ctxPath + '/ProcessPicController/listBusiness?businessId='+ window.businessId,\n\t\tid:'processpicListTable',\n\t\tpage:false\n,\t\teven:true,\n\t\tcols:[[${cols}]],\n})\n\t}\n${instanceId}_table();\n";
        if (null != cloums && cloums.size() != 0) {
            String template = "{title:\"${titleValue}\",\nfield:\"${fieldValue}\",\nwidth:0,\nminWidth:80,\nsort:${sortValue},\nalign:\"${alignValue}\",\nevent:${event},\ntemplet:${templet},\nhide:${hide},\n${edit}${totalRow}},\n";
            for (Object o : cloums) {
                JSONObject obj = (JSONObject)o;
                String title = "";
                String field = "";
                String align = "center";
                String sort = "false";
                String templet = "";
                String hide = "false";
                String event = "";
                String edit = "";
                String totalRow = "";
                field = obj.get((Object)"field").toString();
                title = obj.get((Object)"title").toString();
                if (null == field || null == title) continue;
                String column = template.replace("${titleValue}", title).replace("${fieldValue}", field).replace("${alignValue}", align).replace("${sortValue}", sort).replace("${templet}", "\"\"").replace("${hide}", hide).replace("${event}", "\"\"").replace("${edit}", edit).replace("${totalRow}", totalRow);
                cloumsAll.append(column);
            }
        }
        sbf.append(tableTemplate.replace("${instanceId}", instanceKey).replace("${cols}", cloumsAll));
        return sbf.toString();
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content8 = new StringBuilder();
        if (props.containsKey("tdHeight")) {
            content8.append("height:").append(props.get("tdHeight")).append(";").append("\n");
            content8.append("line-height:").append(props.get("tdHeight")).append(";").append("\n");
        }
        if (content8.length() > 0) {
            String template = "#$id .layui-table-body tr{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content8);
            result.append(template).append("\n");
        }
        StringBuilder content9 = new StringBuilder();
        if (props.containsKey("tdBorderColor")) {
            content9.append("border-color:").append(props.get("tdBorderColor")).append("!important;").append("\n");
        }
        if (!props.containsKey("border") || !((Boolean)props.get("border")).booleanValue()) {
            content9.append("border-right: none;").append("\n");
        }
        if (!props.containsKey("border_x") || !((Boolean)props.get("border_x")).booleanValue()) {
            content9.append("border-bottom: none;").append("\n");
        }
        if (content9.length() > 0) {
            String template = "#$id .layui-table-body .layui-table td{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content9);
            result.append(template).append("\n");
            String template1 = "#$id .layui-table-view .layui-table th{\n $content}";
            template1 = template1.replace("$id", this.componentDto.getInstanceKey());
            template1 = template1.replace("$content", content9);
            result.append(template1).append("\n");
            String template2 = "#$id .layui-table-view .layui-table-box{\n $content}";
            template2 = template2.replace("$id", this.componentDto.getInstanceKey());
            template2 = template2.replace("$content", content9);
            result.append(template2).append("\n");
        }
        StringBuilder content10 = new StringBuilder();
        if (props.containsKey("tdOddBgColor")) {
            content10.append("background-color:").append(props.get("tdOddBgColor")).append(";").append("\n");
        }
        if (content10.length() > 0) {
            String template = "#$id .layui-table-body .layui-table{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content10);
            result.append(template).append("\n");
        }
        StringBuilder content11 = new StringBuilder();
        if (props.containsKey("tdEvenBgColor")) {
            content11.append("background-color:").append(props.get("tdEvenBgColor")).append(";").append("\n");
        }
        if (content11.length() > 0) {
            String template = "#$id .layui-table[lay-even] tr:nth-child(even){\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content11);
            result.append(template).append("\n");
        }
        StringBuilder content12 = new StringBuilder();
        if (props.containsKey("tdHoverBgColor")) {
            content12.append("background-color:").append(props.get("tdHoverBgColor")).append(";").append("\n");
        }
        if (content12.length() > 0) {
            String template = "#$id .layui-table tbody tr:hover,#$id .layui-table-hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content12);
            result.append(template).append("\n");
        }
        StringBuilder content13 = new StringBuilder();
        if (props.containsKey("tdFontSize")) {
            content13.append("font-size:").append(props.get("tdFontSize")).append(";").append("\n");
        }
        if (props.containsKey("tdColor")) {
            content13.append("color:").append(props.get("tdColor")).append(";").append("\n");
        }
        if (content13.length() > 0) {
            String template = "#$id .layui-table-body .layui-table-cell{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content13);
            result.append(template).append("\n");
        }
        StringBuilder content14 = new StringBuilder();
        if (props.containsKey("tdFontWeight")) {
            content14.append("font-weight:").append(props.get("tdFontWeight")).append(";").append("\n");
        }
        if (content14.length() > 0) {
            String template = "#$id .layui-table-body{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content14);
            result.append(template).append("\n");
        }
        StringBuilder content15 = new StringBuilder();
        if (props.containsKey("tdEvenColor")) {
            content15.append("color:").append(props.get("tdEvenColor")).append(";").append("\n");
        }
        if (content15.length() > 0) {
            String template = "#$id .layui-table[lay-even] tr:nth-child(even) .layui-table-cell{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content15);
            result.append(template).append("\n");
        }
        StringBuilder content16 = new StringBuilder();
        if (props.containsKey("tdHoverColor")) {
            content16.append("color:").append(props.get("tdHoverColor")).append(";").append("\n");
        }
        if (content16.length() > 0) {
            String template = "#$id .layui-table tbody tr:hover .layui-table-cell,#$id .layui-table-hover .layui-table-cell{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content16);
            result.append(template).append("\n");
        }
        StringBuilder content17 = new StringBuilder();
        if (props.containsKey("thHeight")) {
            content17.append("height:").append(props.get("thHeight")).append(";").append("\n");
            content17.append("line-height:").append(props.get("thHeight")).append(";").append("\n");
        }
        if (props.containsKey("thBgColor")) {
            content17.append("background-color:").append(props.get("thBgColor")).append(";").append("\n");
        }
        if (props.containsKey("thFontSize")) {
            content17.append("font-size:").append(props.get("thFontSize")).append(";").append("\n");
        }
        if (props.containsKey("thFontColor")) {
            content17.append("color:").append(props.get("thFontColor")).append(";").append("\n");
        }
        if (content17.length() > 0) {
            String template = "#$id .layui-table-header .layui-table-cell{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content17);
            result.append(template).append("\n");
        }
        StringBuilder content18 = new StringBuilder();
        if (props.containsKey("thFontWeight")) {
            content18.append("font-weight:").append(props.get("thFontWeight")).append(";").append("\n");
        }
        if (content18.length() > 0) {
            String template = "#$id .layui-table th{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content18);
            result.append(template).append("\n");
        }
        if (ToolUtil.isNotEmpty((Object)props.get("autoHeight"))) {
            boolean isAutoHeight = Boolean.valueOf(props.get("autoHeight").toString());
            String heightStr = this.componentDto.getStyle().get("min-height");
            if (heightStr != null) {
                int tableHeight = Integer.parseInt(heightStr.replace("px", ""));
                String minHeight = tableHeight - 48 + "px";
                StringBuilder content19 = new StringBuilder();
                if (props.containsKey("autoHeight") && isAutoHeight) {
                    content19.append("min-height:").append(minHeight).append(";").append("\n");
                }
                if (content19.length() > 0) {
                    String template = "#$id .layui-table-box{\n $content}";
                    template = template.replace("$id", this.componentDto.getInstanceKey());
                    template = template.replace("$content", content19);
                    result.append(template).append("\n");
                }
            }
        }
        return result.toString();
    }
}

