/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.ComponentUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;

public class Dialog
extends BaseCell {
    public Dialog() {
        this.renderPorp = false;
    }

    @Override
    public void prepareEmbedElementRender(Map<String, ComponentDto> componentDtoMap) {
        JSONObject jo = (JSONObject)this.componentDto.getProps().get("instanceConfig");
        if (jo != null) {
            String rootInstanceKey = jo.getString("rootInstanceKey");
            this.slots.put("content", rootInstanceKey);
            this.componentDto.getChildren().add(rootInstanceKey);
        }
    }

    @Override
    public void dealEmbedElementRendered(Element element) {
    }

    @Override
    public Element renderCommonHTML(Element element) {
        element.attr("style", "display:none");
        element.attr("id", this.componentDto.getInstanceKey());
        return element;
    }

    @Override
    public void renderCellHTML(Element element) {
        if (this.componentDto.getProps().get("instanceConfig") == null) {
            element.append(this.componentDto.getProps().getOrDefault("content", "").toString());
        }
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) throws ClassNotFoundException, GodAxeException {
        List<String> children;
        ComponentDto area;
        JSONObject jo;
        String dpPath;
        String template = "var $id_index = 0;function layerOpen_$id(){\n$id_index = layer.open({\n  type: $type,\n  title: '$title',\n";
        Boolean isShowBtn = (Boolean)this.componentDto.getProps().get("isShowBtn");
        template = isShowBtn == null || isShowBtn != false ? template + "  btn: ['\u53d6\u6d88', '\u786e\u5b9a'],\n  btnAlign: 'r',\n  skin:'" + this.componentDto.getInstanceKey() + "',\n  closeBtn: 1,\n  area: ['$width','$height'],\n  shadeClose: true,\n  content: $content,\n  btn2: $btn2rEvent,\n  success:function(layero, index){\n  $successContent  }\n});\n}" : template + "  btnAlign: 'r',\n  skin:'" + this.componentDto.getInstanceKey() + "',\n  closeBtn: 1,\n  area: ['$width','$height'],\n  shadeClose: true,\n  content: $content,\n  success:function(layero, index){\n  $successContent  }\n});\n}";
        String type = "1";
        String url = "";
        Map<String, Object> props = this.componentDto.getProps();
        JSONObject dialogPagePath = (JSONObject)props.get("dialogPagePath");
        if (ToolUtil.isNotEmpty((Object)dialogPagePath) && ToolUtil.isNotEmpty((Object)(dpPath = dialogPagePath.getString("pagePath")))) {
            url = "Hussar.ctxPath + \"" + ComponentUtil.getViewStr(dpPath) + "\"";
            type = "2";
        }
        String content = "";
        content = ToolUtil.isNotEmpty((Object)url) ? url : ((jo = (JSONObject)props.get("instanceConfig")) != null ? "$('#" + this.componentDto.getInstanceKey() + "')" : "'" + cellProperties.get("content") + "'");
        StringBuilder successContent = new StringBuilder();
        if (this.componentDto.getChildren().size() > 0 && ToolUtil.isNotEmpty((Object)(area = (ComponentDto)this.componentDtoMap.get(this.componentDto.getChildren().get(0)))) && ToolUtil.isNotEmpty(children = area.getChildren())) {
            for (String ins : children) {
                ComponentDto curr = (ComponentDto)this.componentDtoMap.get(ins);
                if (!"layTable".equals(curr.getName())) continue;
                successContent.append("table.resize(\"").append(ins).append("_main").append("\");\n");
            }
        }
        template = template.replace("$content", content);
        template = template.replace("$title", this.componentDto.getProps().getOrDefault("title", "").toString());
        template = template.replace("$width", this.componentDto.getStyle().getOrDefault("width", "100px"));
        template = template.replace("$height", this.componentDto.getStyle().getOrDefault("height", "100px"));
        template = template.replace("$id", this.componentDto.getInstanceKey());
        template = template.replace("$btn2rEvent", this.renderDialogEvent(this.componentDto.getEventConfigs()));
        template = template.replace("$successContent", successContent.toString()).replace("$type", type);
        return template;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("headHeight")) {
            content.append("height:").append(props.get("headHeight")).append(";").append("\n");
            content.append("line-height:").append(props.get("headHeight")).append(";").append("\n");
        }
        if (props.containsKey("headBg")) {
            content.append("background-color:").append(props.get("headBg")).append(";").append("\n");
        }
        if (props.containsKey("headFontSize")) {
            content.append("font-size:").append(props.get("headFontSize")).append(";").append("\n");
        }
        if (props.containsKey("headColor")) {
            content.append("color:").append(props.get("headColor")).append(";").append("\n");
        }
        if (content.length() > 0) {
            String template = ".$id.layui-layer .layui-layer-title{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("closeBtnTop")) {
            content1.append("top:").append(props.get("closeBtnTop")).append(";").append("\n");
        }
        if (content1.length() > 0) {
            String template = ".$id.layui-layer .layui-layer-setwin{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        return result.toString();
    }

    private String renderDialogEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        String ret = "";
        if (null == eventConfigsDtos || eventConfigsDtos.size() == 0) {
            return "function(index, layero) {}\n";
        }
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            if (EventTriggerEnums.LAYER_YES.getValue().equals(eventConfigsDto.getTrigger())) {
                StringBuilder sbf = new StringBuilder(128);
                sbf.append("function (index, layero) {").append("\n");
                String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
                sbf.append(conditions);
                sbf.append("}");
                ret = sbf.toString();
            }
            if (ToolUtil.isNotEmpty((Object)ret)) break;
            ret = "function(index, layero) {}\n";
        }
        return ret;
    }
}

