/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;

public class Datepicker
extends BaseCell {
    @Override
    public void renderCellHTML(Element element) {
        Map<String, String> dMap;
        Map customRule;
        Map<String, Object> prop = this.componentDto.getProps();
        element.attr("autocomplete ", "off");
        if (ToolUtil.isNotEmpty((Object)prop.get("disabled")) && ((Boolean)prop.get("disabled")).booleanValue()) {
            element.attr("disabled", "");
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("readonly")) && ((Boolean)prop.get("readonly")).booleanValue()) {
            element.attr("readonly", "");
        }
        boolean isNeedCheck = false;
        if (ToolUtil.isNotEmpty((Object)prop.get("isChecked"))) {
            List checked = (List)prop.get("isChecked");
            for (Map check : checked) {
                if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                isNeedCheck = true;
                element.attr("require", true);
            }
        }
        if (prop.containsKey("customRule") && ToolUtil.isNotEmpty((Object)prop.get("customRule")) && Boolean.valueOf((customRule = (Map)prop.get("customRule")).get("isCustomRule").toString()).booleanValue()) {
            isNeedCheck = true;
            List customRules = (List)customRule.get("customRules");
            for (int i = 0; i < customRules.size(); ++i) {
                element.attr(this.componentDto.getInstanceKey() + "_ver" + (i + 1), true);
            }
        }
        if (isNeedCheck) {
            element.addClass("needCheck");
        }
        if (ToolUtil.isNotEmpty(dMap = this.componentDto.getDefaultValue()) && ToolUtil.isNotEmpty((Object)dMap.get("value"))) {
            element.attr("value", dMap.get("value"));
        }
        if (prop.containsKey("tabindex")) {
            element.attr("tabindex", prop.get("tabindex").toString());
        }
        this.renderAttribute(element);
    }

    @Override
    public String renderScript(Map<String, Object> propMap) throws ClassNotFoundException, GodAxeException {
        List<EventConfigsDto> eventConfigsDtos = this.componentDto.getEventConfigs();
        String eventStr = this.renderDoneEvent(eventConfigsDtos);
        StringBuilder sbf = new StringBuilder(128);
        sbf.append("var layDate_").append(this.componentDto.getInstanceKey()).append(" = ").append(" laydate.render({  \n").append("elem: '#").append(this.componentDto.getInstanceKey()).append("',\n").append("range:").append(propMap.get("opt_range")).append(",\n").append("format:'").append(propMap.get("opt_format")).append("',\n").append("type:'").append(propMap.get("opt_type")).append("',\n").append("trigger:'click',\n").append("done: function(value, date, endDate) {\n ").append("\t$('#").append(this.componentDto.getInstanceKey()).append("').val(value);").append("if(value != '' && value != null && value != undefined && ").append("$('#").append(this.componentDto.getInstanceKey()).append("').hasClass(\"error\")){").append("$('#").append(this.componentDto.getInstanceKey()).append("').removeClass(\"error\");\n").append("$('#").append(this.componentDto.getInstanceKey()).append("').removeAttr(\"title\");\n").append("}\n").append(eventStr).append("\n}").append(" });");
        return sbf.toString();
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("borderHoverColor")) {
            content.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content.length() > 0) {
            String template = "#$id:hover,#$id:focus{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("disabledBg")) {
            content1.append("background-color:").append(props.get("disabledBg")).append(";").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id.layui-date:disabled{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder hoverStyle = new StringBuilder();
        if (interactive.containsKey("hover")) {
            Object hovers = interactive.get("hover");
            for (Map.Entry entry : ((Map)hovers).entrySet()) {
                hoverStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (hoverStyle.length() > 0) {
            String template = "#$id.layui-date:not(:disabled):hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", hoverStyle);
            result.append(template).append("\n");
        }
        StringBuilder focusStyle = new StringBuilder();
        if (interactive.containsKey("focus")) {
            Object focuss = interactive.get("focus");
            for (Map.Entry entry : ((Map)focuss).entrySet()) {
                focusStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (focusStyle.length() > 0) {
            String template = "#$id.layui-date:not(:disabled):focus{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", focusStyle);
            result.append(template).append("\n");
        }
        StringBuilder readonlyStyle = new StringBuilder();
        if (interactive.containsKey("readonly")) {
            Object object = interactive.get("readonly");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                readonlyStyle.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("!important;").append("\n");
            }
        }
        if (readonlyStyle.length() > 0) {
            String string3 = "#$id.layui-date:read-only{\n $content}";
            string3 = string3.replace("$id", this.componentDto.getInstanceKey());
            string3 = string3.replace("$content", readonlyStyle);
            result.append(string3).append("\n");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (interactive.containsKey("disabled")) {
            Object object = interactive.get("disabled");
            for (Map.Entry map : ((Map)object).entrySet()) {
                stringBuilder.append((String)map.getKey()).append(":").append((String)map.getValue()).append("!important;").append("\n");
            }
        }
        if (stringBuilder.length() > 0) {
            String string5 = "#$id.layui-date:disabled{\n $content}";
            string5 = string5.replace("$id", this.componentDto.getInstanceKey());
            string5 = string5.replace("$content", stringBuilder);
            result.append(string5).append("\n");
        }
        return result.toString();
    }

    private String renderDoneEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            if (!EventTriggerEnums.CHANGE.getValue().equals(eventConfigsDto.getTrigger())) continue;
            String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("\n");
        }
        return sbf.toString();
    }
}

