/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Datapicker
extends BaseCell {
    @Override
    public void renderCellHTML(Element element) {
        Map customRule;
        boolean isAddCheckClass = true;
        Element childNodeInput = new Element("input");
        childNodeInput.attr("readonly", "");
        childNodeInput.attr("id", this.componentDto.getId());
        childNodeInput.attr("lay-filter", this.componentDto.getId());
        Element childNodeI = new Element("i");
        childNodeI.attr("id", this.componentDto.getId() + "_Icon");
        Map iconSetting = (Map)this.componentDto.getProps().get("changeIcon");
        if (iconSetting.containsKey("fontClassName")) {
            String className;
            childNodeI.addClass((String)iconSetting.get("fontClassName"));
            String code = iconSetting.containsKey("code") ? (String)iconSetting.get("code") : "";
            String string = className = iconSetting.containsKey("class") ? (String)iconSetting.get("class") : "";
            if ("".equals(className)) {
                childNodeI.html(code);
            } else {
                childNodeI.addClass(className);
            }
        }
        Map<String, Object> prop = this.componentDto.getProps();
        String iconStyle = "";
        if (ToolUtil.isNotEmpty((Object)prop.get("iconColor"))) {
            iconStyle = iconStyle + "color:" + prop.get("iconColor") + ";";
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("iconSize"))) {
            iconStyle = iconStyle + "font-size:" + prop.get("iconSize") + ";";
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("disabled")) && ((Boolean)prop.get("disabled")).booleanValue()) {
            isAddCheckClass = false;
            element.attr("disabled", "");
            childNodeInput.attr("disabled", "");
            iconStyle = iconStyle + "pointer-events:none;";
        }
        if (!this.componentDto.getIsShow().booleanValue()) {
            isAddCheckClass = false;
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("placeholder"))) {
            String inputStyle = prop.get("placeholder").toString();
            childNodeInput.attr("placeholder", inputStyle);
        }
        boolean isNeedCheck = false;
        String checkType = "";
        if (ToolUtil.isNotEmpty((Object)prop.get("isChecked"))) {
            List checked = (List)prop.get("isChecked");
            for (Map check : checked) {
                if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                isNeedCheck = true;
                childNodeInput.attr("require", true);
            }
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("checkedType"))) {
            isNeedCheck = true;
            if ("number".equals(prop.get("checkedType"))) {
                childNodeInput.attr("number", true);
            } else if ("email".equals(prop.get("checkedType"))) {
                childNodeInput.attr("email", true);
            } else if ("date".equals(prop.get("checkedType"))) {
                childNodeInput.attr("date", true);
            } else if ("http".equals(prop.get("checkedType"))) {
                childNodeInput.attr("url", true);
            } else if ("phone".equals(prop.get("checkedType"))) {
                childNodeInput.attr("phone", true);
            } else if ("identityCard".equals(prop.get("checkedType"))) {
                childNodeInput.attr("identity", true);
            } else if ("fixAndMobile".equals(prop.get("checkedType"))) {
                childNodeInput.attr("fixAndMobile", true);
            } else if ("decimals".equals(prop.get("checkedType"))) {
                childNodeInput.attr("decimals", true);
            } else if ("fix".equals(prop.get("checkedType"))) {
                childNodeInput.attr("fix", true);
            } else if ("positiveInteger".equals(prop.get("checkedType"))) {
                childNodeInput.attr("positiveInteger", true);
            } else if ("isInteger".equals(prop.get("checkedType"))) {
                childNodeInput.attr("isInteger", true);
            } else if ("isEnglish".equals(prop.get("checkedType"))) {
                childNodeInput.attr("isEnglish", true);
            } else if ("isChinese".equals(prop.get("checkedType"))) {
                childNodeInput.attr("isChinese", true);
            }
        }
        if (prop.containsKey("customRule") && ToolUtil.isNotEmpty((Object)prop.get("customRule")) && Boolean.valueOf((customRule = (Map)prop.get("customRule")).get("isCustomRule").toString()).booleanValue()) {
            isNeedCheck = true;
            List customRules = (List)customRule.get("customRules");
            for (int i = 0; i < customRules.size(); ++i) {
                childNodeInput.attr(this.componentDto.getInstanceKey() + "_ver" + (i + 1), true);
            }
        }
        if (isNeedCheck && isAddCheckClass) {
            childNodeInput.addClass("needCheck");
        }
        if (prop.containsKey("tabindex")) {
            childNodeInput.attr("tabindex", prop.get("tabindex").toString());
        }
        childNodeI.attr("style", iconStyle);
        element.attr("id", this.componentDto.getInstanceKey() + "_container");
        element.appendChild((Node)childNodeInput);
        element.appendChild((Node)childNodeI);
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("borderHoverColor")) {
            content.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content.length() > 0) {
            String template = "#$id:hover,#$id:focus{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("disabledBg")) {
            content1.append("background-color:").append(props.get("disabledBg")).append(";").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id_container.layui-datapick input:disabled{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("placeholderColor")) {
            content2.append("color:").append(props.get("placeholderColor")).append(";").append("\n");
        }
        if (props.containsKey("placeholderFontSize")) {
            content2.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (props.containsKey("placeholderPosition")) {
            content2.append("text-align:").append(props.get("placeholderPosition")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            String template = "#$id.layui-datapick input::-webkit-input-placeholder{\n $content}\n#$id.layui-datapick input:-moz-placeholder{\n $content}\n#$id.layui-datapick input::-moz-placeholder{\n $content}\n#$id.layui-datapick input:-ms-input-placeholder{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        StringBuilder content3 = new StringBuilder();
        if (props.containsKey("placeholderFontSize")) {
            content3.append("font-size:").append(props.get("placeholderFontSize")).append(";").append("\n");
        }
        if (content3.length() > 0) {
            String template = "#$id.layui-datapick input:placeholder-shown{\n $content}\n";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content3);
            result.append(template).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            sbf.append(CellEventUtil.changeEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
            if (!EventTriggerEnums.CLICK.getValue().equals(eventConfigsDto.getTrigger())) continue;
            sbf.append("$(\"#").append(this.componentDto.getInstanceKey()).append("_Icon\").click(function(e){").append("\n");
            String conditions = CellEventUtil.genConditionJs(eventConfigsDto.getConditions(), this.componentDto, this.componentDtoMap, eventConfigsDto.getName());
            sbf.append(conditions);
            sbf.append("});").append("\n");
        }
        return sbf.toString();
    }

    @Override
    public String renderSetDisableActionScript(boolean isNeedCheck) {
        String returnStr = "";
        returnStr = "$('#" + this.componentDto.getInstanceKey() + "').attr('disabled',true);\n$('#" + this.componentDto.getInstanceKey() + "_Icon').css('pointer-events','none');\n";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "_container').removeClass(\"error\");";
        }
        return returnStr;
    }

    @Override
    public String renderNormalActionScript(boolean isNeedCheck) {
        String returnStr = "";
        returnStr = "$('#" + this.componentDto.getInstanceKey() + "').removeAttr('disabled');\n$('#" + this.componentDto.getInstanceKey() + "').attr('readonly',true);\n$('#" + this.componentDto.getInstanceKey() + "_Icon').css('pointer-events','visible');\n$('#" + this.componentDto.getInstanceKey() + "_container').show();\n";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').addClass(\"needCheck\");";
        }
        return returnStr;
    }

    @Override
    public String renderHideActionScript(boolean isNeedCheck) {
        String returnStr = "";
        returnStr = "$('#" + this.componentDto.getInstanceKey() + "_container').hide();";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "_container').removeClass(\"error\");";
        }
        return returnStr;
    }
}

