/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.BaseCellImplUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.GenPreDataUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class CheckBoxGroup
extends BaseCell {
    @Override
    public void setData(ComponentDto componentDto) {
        this.renderPorp = true;
        super.setData(componentDto);
    }

    @Override
    public void renderCellHTML(Element element) {
        Map<String, Object> porp = this.componentDto.getProps();
        boolean isAddCheckClass = true;
        JSONArray options = (JSONArray)porp.get("options");
        Boolean disabled = (Boolean)porp.get("disabled");
        JSONArray selected = (JSONArray)porp.get("selected");
        String styleType = (String)porp.get("styleType");
        for (Object tmp : options) {
            JSONObject jsonObject = (JSONObject)tmp;
            String value = jsonObject.getString("value");
            String text = jsonObject.getString("text");
            Element radio = new Element("input");
            radio.attr("type", "checkbox");
            radio.attr("name", this.componentDto.getInstanceKey());
            radio.attr("value", value);
            radio.attr("title", text);
            if (selected.contains((Object)value)) {
                radio.attr("checked", "");
            }
            if ("checkbox".equals(styleType)) {
                radio.attr("lay-skin", "primary");
            }
            if (disabled.booleanValue()) {
                isAddCheckClass = false;
                radio.attr("disabled", "");
            }
            if (!this.componentDto.getIsShow().booleanValue()) {
                isAddCheckClass = false;
            }
            radio.attr("lay-filter", this.componentDto.getId());
            if (ToolUtil.isNotEmpty((Object)porp.get("isChecked"))) {
                List checked = (List)porp.get("isChecked");
                for (Map check : checked) {
                    if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                    if (isAddCheckClass) {
                        element.addClass("needCheck");
                    }
                    element.attr("requiredForCheckBox", true);
                }
            }
            GenPreDataUtil.addDataCurrent(element, this.componentDto);
            element.appendChild((Node)radio);
        }
        this.renderAttribute(element);
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        String templateRenderValue = "function ${insId}_checkBoxGetValue(){\n        var temp = $(\"#${insId} input:checked\");\n        var tempValue = \"\";\n        if (temp && temp.length > 0) {\n            temp.each(function (value) {\n                if (\"\" !== tempValue) {\n                    tempValue += ',' + temp[value].value;\n                } else {\n                    tempValue += temp[value].value;\n                }\n            });\n        }\n        return tempValue;\n}\nfunction ${insId}_checkBoxRenderValue(data){\n        if (\"\" !== data && undefined !== data && null !== data) {\n            var temp = data.split(',');\n            if (temp && temp.length > 0){\n                temp.forEach(function (value) {\n                    $(\"#${insId} input[value='\"+value+\"']\").prop(\"checked\",true);\n                    form.render('checkbox');\n                })\n            }\n        }\n    }";
        return templateRenderValue.replace("${insId}", this.componentDto.getInstanceKey());
    }

    @Override
    public String renderPreloadDataScript(Map<String, Object> cellProperties) {
        StringBuilder res = new StringBuilder();
        JSONObject bindingData = this.componentDto.getDatas();
        if (ToolUtil.isNotEmpty((Object)bindingData) && ToolUtil.isNotEmpty((Object)bindingData.getJSONObject("relateTable"))) {
            JSONObject data = bindingData.getJSONObject("relateTable");
            String relateType = data.getString("relateType");
            String defaultValue = "";
            Map<String, String> defaultMap = this.componentDto.getDefaultValue();
            if (this.returnNotDefault()) {
                defaultValue = defaultMap.get("value");
            }
            Boolean disabled = (Boolean)this.componentDto.getProps().get("disabled");
            if ("dict".equals(relateType)) {
                String dicId = data.getJSONObject("dictTypeID").getString("id");
                String dicTypeId = dicId == null ? "" : dicId;
                String checkBoxTemplate = "var ajax_${insId} = new $ax(Hussar.ctxPath + \"/sys/dic/list_single/\" + \"${dicTypeId}\",\n\tfunction(result){\n\t\tvar options = result.data;\n\t\t$(\"#${insId}\").html('');\n\t\tfor(var i = 0; i < options.length; i++){\n\t\t\tif(options[i] != null){\nvar temp = \"\";\n${defaultValueContent}\n\t\t$(\"#${insId}\").append('<input '+temp+'type=\"checkbox\" ${disabled} lay-skin=\"primary\" name=\"${insId}\" value=\"'+options[i].value+'\" title=\"'+options[i].label+'\" lay-filter=\"${insId}\">')\n}\n}\nif($(\"#${insId}\")[0].hasAttribute('data-form')){\n${insId}_checkBoxRenderValue($(\"#${insId}\").attr('data-form'));}else{\n$(\"#${insId}\").attr('data-current','')}\nif($(\"#${insId}\")[0].hasAttribute('data-disabled')){\n" + this.renderDisableString() + "}layui.form.render(\"checkbox\");\n});\najax_${insId}.setAsync(true);\najax_${insId}.start();\n";
                String defaultValueContent = "";
                if (ToolUtil.isNotEmpty((Object)defaultValue)) {
                    defaultValueContent = "\tif(options[i].value == \"" + defaultValue + "\"){\ntemp = \"checked \";}\n";
                }
                res.append(checkBoxTemplate.replace("${insId}", this.componentDto.getInstanceKey()).replace("${suffix}", "_ajax").replace("${dicTypeId}", dicTypeId).replace("${defaultValueContent}", defaultValueContent).replace("${disabled}", disabled != false ? "disabled" : ""));
            }
        }
        return res.toString();
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        Object hovers;
        String template;
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template2 = "#$id{\n $content}";
            template2 = template2.replace("$id", this.componentDto.getInstanceKey());
            template2 = template2.replace("$content", contentBackground);
            result.append(template2).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("checkSelectColor")) {
            content.append("border-color:").append(props.get("checkSelectColor")).append(";").append("\n");
            content.append("background-color:").append(props.get("checkSelectColor")).append(";").append("\n");
        }
        if (content.length() > 0) {
            String template3 = "#$id>.layui-form-checked[lay-skin=primary] i {\n $content}";
            template3 = template3.replace("$id", this.componentDto.getInstanceKey());
            template3 = template3.replace("$content", content);
            result.append(template3).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("color")) {
            content1.append("color:").append(props.get("color")).append(";").append("\n");
        }
        if (props.containsKey("fontWeight")) {
            content1.append("font-weight:").append(props.get("fontWeight")).append(";").append("\n");
        }
        if (props.containsKey("textDecoration")) {
            content1.append("text-decoration:").append(props.get("textDecoration")).append(";").append("\n");
        }
        if (props.containsKey("itemGap")) {
            content1.append("padding-right:0px;\n");
        }
        if (content1.length() > 0) {
            String template4 = "#$id>.layui-form-checkbox[lay-skin=primary] span{\n $content}";
            template4 = template4.replace("$id", this.componentDto.getInstanceKey());
            template4 = template4.replace("$content", content1);
            result.append(template4).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("itemGap")) {
            content2.append("margin-right:").append(props.get("itemGap")).append(";").append("\n");
        }
        if (content2.length() > 0) {
            String template5 = "#$id .layui-form-checkbox[lay-skin=primary]{\n $content3}";
            template5 = template5.replace("$id", this.componentDto.getInstanceKey());
            template5 = template5.replace("$content3", content2);
            result.append(template5).append("\n");
        }
        StringBuilder content3 = new StringBuilder();
        if (props.containsKey("itemGap")) {
            content3.append("margin-right:0;\n");
        }
        if (content3.length() > 0) {
            String template6 = "#$id .layui-form-checkbox[lay-skin=primary]:last-child{\n $content3}";
            template6 = template6.replace("$id", this.componentDto.getInstanceKey());
            template6 = template6.replace("$content3", content3);
            result.append(template6).append("\n");
        }
        if (interactive.containsKey("hover") && ToolUtil.isNotEmpty((Object)(template = this.renderInteractiveCss(hovers = interactive.get("hover"), "hover")))) {
            result.append(template).append("\n");
        }
        if (interactive.containsKey("active") && ToolUtil.isNotEmpty((Object)(template = this.renderInteractiveCss(hovers = interactive.get("active"), "active")))) {
            result.append(template).append("\n");
        }
        if (interactive.containsKey("disabled") && ToolUtil.isNotEmpty((Object)(template = this.renderInteractiveCss(hovers = interactive.get("disabled"), "disabled")))) {
            result.append(template).append("\n");
        }
        return result.toString();
    }

    private String renderInteractiveCss(Object interactives, String type) {
        StringBuilder stylesCheck = new StringBuilder();
        StringBuilder stylesLabel = new StringBuilder();
        String template = "";
        for (Map.Entry map : ((Map)interactives).entrySet()) {
            if (((String)map.getKey()).equals("check-color")) {
                stylesCheck.append("background-color").append(":").append((String)map.getValue()).append("!important;").append("\n");
                stylesCheck.append("border-color").append(":").append((String)map.getValue()).append("!important;").append("\n");
                continue;
            }
            stylesLabel.append((String)map.getKey()).append(":").append((String)map.getValue()).append("!important;").append("\n");
        }
        if (stylesCheck.length() > 0) {
            if (type.equals("hover")) {
                template = "#$id .layui-form-checkbox[lay-skin=primary]:hover i{\n $content}";
            } else if (type.equals("active")) {
                template = "#$id .layui-form-checkbox[lay-skin=primary].layui-form-checked i{\n $content}";
            } else if (type.equals("disabled")) {
                template = "#$id .layui-form-checkbox[lay-skin=primary].layui-checkbox-disbaled i{\n $content}";
            }
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", stylesCheck);
        }
        if (stylesLabel.length() > 0) {
            if (type.equals("hover")) {
                template = template + "#$id .layui-form-checkbox[lay-skin=primary]:hover span{\n $content}";
            } else if (type.equals("active")) {
                template = template + "#$id .layui-form-checkbox[lay-skin=primary].layui-form-checked span{\n $content}";
            } else if (type.equals("disabled")) {
                template = template + "#$id .layui-form-checkbox[lay-skin=primary].layui-checkbox-disbaled span{\n $content}";
            }
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", stylesLabel);
        }
        return template;
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            sbf.append(CellEventUtil.layEventListenPublic(eventConfigsDto, this.componentDto, this.componentDtoMap, "checkbox"));
        }
        return sbf.toString();
    }

    @Override
    public String renderNormalActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').addClass(\"needCheck\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + " input').removeAttr(\"disabled\");\n$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"layui-hide\");\nform.render();";
        return returnStr;
    }

    @Override
    public String renderHideActionScript(boolean isNeedCheck) {
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"error\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').addClass(\"layui-hide\");\nform.render();";
        return returnStr;
    }

    @Override
    public String renderSetDisableActionScript(boolean isNeedCheck) {
        String template = "if($(\"#${insId}\")[0].hasAttribute('data-current')){\n" + this.renderDisableString() + "}else {\n$(\"#${insId}\").attr('data-disabled','');}";
        String returnStr = "";
        if (isNeedCheck) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"error\");";
        }
        returnStr = returnStr + template.replace("${insId}", this.componentDto.getInstanceKey());
        return returnStr;
    }

    @Override
    public String renderGetValue() {
        return "${insId}_checkBoxGetValue()".replace("${insId}", this.componentDto.getInstanceKey());
    }

    @Override
    public String renderValue(String value) {
        return "${insId}_checkBoxRenderValue(cValue)".replace("${insId}", this.componentDto.getInstanceKey());
    }

    @Override
    public String renderClearValue() {
        return "$(\"#" + this.componentDto.getInstanceKey() + " input[name='" + this.componentDto.getInstanceKey() + "']\").prop('checked',false);\nform.render('checkbox');";
    }

    @Override
    public String renderFormValue(String value) {
        String template = "if($(\"#${insId}\")[0].hasAttribute('data-current')){\n${insId}_checkBoxRenderValue(${value});}else {\n$(\"#${insId}\").attr('data-form',${value});}if($(\"#${insId}\")[0].hasAttribute('data-disabled')){\n" + this.renderDisableString() + "}";
        return template.replace("${insId}", this.componentDto.getInstanceKey()).replace("${value}", value);
    }

    private String renderDisableString() {
        String returnStr = "";
        if (BaseCellImplUtil.isNeedCheck(this.componentDto)) {
            returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + "').removeClass(\"needCheck\");";
        }
        returnStr = returnStr + "$('#" + this.componentDto.getInstanceKey() + " input').attr('disabled',true);\nform.render();";
        return returnStr;
    }
}

