/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class CheckBox
extends BaseCell {
    @Override
    public void setData(ComponentDto componentDto) {
        this.renderPorp = false;
        super.setData(componentDto);
    }

    @Override
    public void renderCellHTML(Element element) {
        Element checkbox = new Element("input");
        Map<String, Object> prop = this.componentDto.getProps();
        checkbox.attr("id", this.componentDto.getInstanceKey() + "_main");
        checkbox.attr("type", "checkbox");
        checkbox.attr("name", (String)prop.get("name"));
        checkbox.attr("title", (String)prop.get("label"));
        checkbox.attr("lay-skin", "primary");
        if (ToolUtil.isNotEmpty((Object)prop.get("disabled")) && ((Boolean)prop.get("disabled")).booleanValue()) {
            checkbox.attr("disabled", "");
        }
        if (ToolUtil.isNotEmpty((Object)prop.get("checked")) && ((Boolean)prop.get("checked")).booleanValue()) {
            checkbox.attr("checked", "");
        }
        element.appendChild((Node)checkbox);
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        return null;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content = new StringBuilder();
        if (props.containsKey("checkSelectColor")) {
            content.append("border-color:").append(props.get("checkSelectColor")).append(";").append("\n");
            content.append("background-color:").append(props.get("checkSelectColor")).append(";").append("\n");
        }
        if (content.length() > 0) {
            String template = "#$id>.layui-form-checked[lay-skin=primary] i {\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("color")) {
            content1.append("color:").append(props.get("color")).append(";").append("\n");
        }
        if (props.containsKey("fontWeight")) {
            content1.append("font-weight:").append(props.get("fontWeight")).append(";").append("\n");
        }
        if (props.containsKey("textDecoration")) {
            content1.append("text-decoration:").append(props.get("textDecoration")).append(";").append("\n");
        }
        if (props.containsKey("widthInner")) {
            content1.append("margin-left:12px;padding-left:").append(props.get("widthInner")).append(";").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id>.layui-form-checkbox[lay-skin=primary] span{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder content2 = new StringBuilder();
        if (props.containsKey("widthInner")) {
            content2.append("padding-left:0;\n");
        }
        if (content2.length() > 0) {
            String template = "#$id>.layui-form-checkbox[lay-skin=primary]{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content2);
            result.append(template).append("\n");
        }
        StringBuilder content3 = new StringBuilder();
        if (props.containsKey("widthInner")) {
            content3.append("width:").append(props.get("widthInner")).append(";").append("\n");
        }
        if (props.containsKey("heightInner")) {
            content3.append("height:").append(props.get("heightInner")).append(";").append("\n");
        }
        if (content3.length() > 0) {
            String template = "#$id>.layui-form-checkbox[lay-skin=primary] .layui-icon-ok{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content3);
            result.append(template).append("\n");
        }
        StringBuilder content4 = new StringBuilder();
        if (props.containsKey("heightInner")) {
            content4.append("line-height:").append(props.get("heightInner")).append(";").append("\n");
        }
        if (content4.length() > 0) {
            String template = "#$id>.layui-form-checkbox[lay-skin=primary] .layui-icon-ok:before{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content4);
            result.append(template).append("\n");
        }
        StringBuilder content5 = new StringBuilder();
        if (props.containsKey("disabledColor ")) {
            content5.append("border-color:").append(props.get("disabledColor")).append(" !important;").append("\n");
        }
        if (content5.length() > 0) {
            String template = "#$id>.layui-form-checkbox[lay-skin=primary].layui-disabled i{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content5);
            result.append(template).append("\n");
        }
        StringBuilder content6 = new StringBuilder();
        if (props.containsKey("disabledColor ")) {
            content6.append("border-color:").append(props.get("disabledColor")).append(" !important;").append("\n");
            content6.append("background-color:").append(props.get("disabledColor")).append(";").append("\n");
        }
        if (content6.length() > 0) {
            String template = "#$id>.layui-form-checkbox[lay-skin=primary].layui-form-checked.layui-disabled i{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content6);
            result.append(template).append("\n");
        }
        return result.toString();
    }
}

