/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventActionsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConditionsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.enums.EventTriggerEnums;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.CellEventUtil;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Button
extends BaseCell {
    @Override
    public void renderCellHTML(Element element) {
        Map iconSetting;
        Map<String, Object> mapPro = this.componentDto.getProps();
        if (mapPro.containsKey("icon") && (iconSetting = (Map)mapPro.get("icon")) != null && iconSetting.containsKey("fontClassName") && !"-".equals(iconSetting.get("fontClassName"))) {
            String className;
            Element i = new Element("i");
            i.addClass((String)iconSetting.get("fontClassName"));
            String code = iconSetting.containsKey("code") ? (String)iconSetting.get("code") : "";
            String string = className = iconSetting.containsKey("class") ? (String)iconSetting.get("class") : "";
            if ("".equals(className)) {
                i.html(code);
            } else {
                i.addClass(className);
            }
            element.appendChild((Node)i);
        }
        if (null != mapPro.get("size") && !"-".equals(mapPro.get("size"))) {
            element.addClass((String)mapPro.get("size"));
        }
        element.append(mapPro.get("text").toString());
        if (ToolUtil.isNotEmpty((Object)mapPro.get("disabled")) && ((Boolean)mapPro.get("disabled")).booleanValue()) {
            element.addClass("layui-btn-disabled");
        }
        if (ToolUtil.isNotEmpty((Object)mapPro.get("round")) && ((Boolean)mapPro.get("round")).booleanValue()) {
            element.addClass("layui-btn-radius");
        }
        if (ToolUtil.isNotEmpty((Object)mapPro.get("disabled")) && ((Boolean)mapPro.get("disabled")).booleanValue()) {
            element.attr("disabled", "");
        }
        if (ToolUtil.isNotEmpty((Object)mapPro.get("type")) && !"".equals(mapPro.get("type"))) {
            element.attr("type", (String)mapPro.get("type"));
        } else {
            element.attr("type", "button");
        }
        String param = this.getSubmitParam(this.componentDto.getEventConfigs());
        if (param.length() > 0) {
            element.attr("lay-submit", "");
            element.attr("lay-filter", param);
        }
        this.renderAttribute(element);
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (props.containsKey("backgroundImage")) {
            contentBackground.append("background-image:").append(props.get("backgroundImage")).append("\n");
        }
        if (props.containsKey("backgroundRepeat")) {
            contentBackground.append("background-repeat:").append(props.get("backgroundRepeat")).append("\n");
        }
        if (props.containsKey("backgroundPosition")) {
            contentBackground.append("background-position:").append(props.get("backgroundPosition")).append("\n");
        }
        if (props.containsKey("backgroundSize")) {
            contentBackground.append("background-size:").append(props.get("backgroundSize")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        StringBuilder content1 = new StringBuilder();
        if (props.containsKey("backgroundHover")) {
            content1.append("background:").append(props.get("backgroundHover")).append("!important;").append("\n");
        }
        if (props.containsKey("fontHoverColor")) {
            content1.append("color:").append(props.get("fontHoverColor")).append("!important;").append("\n");
        }
        if (props.containsKey("borderHoverColor")) {
            content1.append("border-color:").append(props.get("borderHoverColor")).append("!important;").append("\n");
        }
        if (content1.length() > 0) {
            String template = "#$id.layui-btn:hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", content1);
            result.append(template).append("\n");
        }
        StringBuilder hoverStyle = new StringBuilder();
        if (interactive.containsKey("hover")) {
            Object hovers = interactive.get("hover");
            for (Map.Entry map : ((Map)hovers).entrySet()) {
                hoverStyle.append((String)map.getKey()).append(":").append((String)map.getValue()).append("!important;").append("\n");
            }
        }
        if (hoverStyle.length() > 0) {
            String template = "#$id.layui-btn:not(:disabled):hover{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", hoverStyle);
            result.append(template).append("\n");
        }
        StringBuilder disabledStyle = new StringBuilder();
        if (interactive.containsKey("disabled")) {
            Object disableds = interactive.get("disabled");
            for (Map.Entry map : ((Map)disableds).entrySet()) {
                disabledStyle.append((String)map.getKey()).append(":").append((String)map.getValue()).append("!important;").append("\n");
            }
        }
        if (disabledStyle.length() > 0) {
            String template = "#$id.layui-btn:disabled{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", disabledStyle);
            result.append(template).append("\n");
        }
        return result.toString();
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        return null;
    }

    @Override
    public String renderEvent(List<EventConfigsDto> eventConfigsDtos) throws ClassNotFoundException, GodAxeException {
        StringBuilder sbf = new StringBuilder(128);
        for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
            sbf.append(CellEventUtil.clickEventPublic(eventConfigsDto, this.componentDto, this.componentDtoMap));
        }
        return sbf.toString();
    }

    private String getSubmitParam(List<EventConfigsDto> eventConfigsDtos) {
        String ret = "";
        if (null == eventConfigsDtos || eventConfigsDtos.size() == 0) {
            ret = "";
        } else {
            for (EventConfigsDto eventConfigsDto : eventConfigsDtos) {
                if (EventTriggerEnums.CLICK.getValue().equals(eventConfigsDto.getTrigger())) {
                    block1: for (EventConditionsDto eventConditionsDto : eventConfigsDto.getConditions()) {
                        for (EventActionsDto eventActionsDto : eventConditionsDto.getActions()) {
                            if ("submit-form".equals(eventActionsDto.getHandler()) || "search-table".equals(eventActionsDto.getHandler()) || "submit-flow-form".equals(eventActionsDto.getHandler()) || "show-form-workflow".equals(eventActionsDto.getHandler()) || "leap-submit-flow-form".equals(eventActionsDto.getHandler()) || "reject-any-workflow".equals(eventActionsDto.getHandler()) || "reject-last-workflow".equals(eventActionsDto.getHandler()) || "reject-first-workflow".equals(eventActionsDto.getHandler()) || "submit-reject-node".equals(eventActionsDto.getHandler())) {
                                ret = eventActionsDto.getParams().get(0).get("value");
                                continue block1;
                            }
                            if (!"append-row".equals(eventActionsDto.getHandler()) && !"update-row".equals(eventActionsDto.getHandler())) continue;
                            ret = this.componentDto.getInstanceKey();
                            continue block1;
                        }
                    }
                }
                if (!ToolUtil.isNotEmpty((Object)ret)) continue;
                break;
            }
        }
        return ret;
    }
}

