/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.layui;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class AdvancedQuery
extends BaseCell {
    @Override
    public void prepareEmbedElementRender(Map<String, ComponentDto> componentDtoMap) {
        JSONObject jo = (JSONObject)this.componentDto.getProps().get("instanceConfig");
        if (jo != null) {
            String rootInstanceKey = jo.getString("rootInstanceKey");
            this.slots.put("content", rootInstanceKey);
            this.componentDto.getChildren().add(rootInstanceKey);
        }
    }

    @Override
    public void dealEmbedElementRendered(Element element) {
        element.attr("id", this.componentDto.getInstanceKey());
        element.addClass("layui-advanced-query");
        Element div = new Element("div");
        div.addClass("layui-query-inner");
        String text = (String)this.componentDto.getProps().get("showText");
        String fixHeight = this.componentDto.getStyle().get("fixHeight");
        String height = this.componentDto.getStyle().get("height");
        if (ToolUtil.isNotEmpty((Object)text)) {
            div.append(text);
        }
        if (ToolUtil.isNotEmpty((Object)fixHeight)) {
            div.attr("style", "height:" + fixHeight + ";line-height:" + fixHeight + ";");
        } else {
            div.attr("style", "height:" + height + ";line-height:" + height + ";");
        }
        Element i = new Element("i");
        i.addClass("layui-query-arrow");
        div.appendChild((Node)i);
        element.appendChild((Node)div);
    }

    @Override
    public void renderCellHTML(Element element) {
        if (this.componentDto.getProps().get("instanceConfig") == null) {
            element.append(this.componentDto.getProps().getOrDefault("content", "").toString());
        }
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) throws ClassNotFoundException {
        String relatedKey = (String)this.componentDto.getProps().get("relatedKey");
        String rootInstanceKey = "";
        JSONObject jo = (JSONObject)this.componentDto.getProps().get("instanceConfig");
        if (jo != null) {
            rootInstanceKey = jo.getString("rootInstanceKey");
        }
        String template = "";
        template = "$(\"#$id .layui-query-inner\").click(function(){\n            //  \u5224\u65ad\u662f\u5426\u5c55\u5f00\n            var isOpen = false;\n            isOpen = $(this).data(\"isOpen\");\n            var height = $('#$childRootKey').css(\"height\");\n\n            var adjustHeightArr = $adjustHeightArr;\n            if(!!adjustHeightArr && adjustHeightArr.length>0){\n              adjustHeightArr.forEach(function(key){\n                var oldRelateH = $('#'+key).css(\"height\");\n                var oldRelateT = $('#'+key).css(\"top\");\n                if(isOpen){\n                  $(\"#\"+key).css(\"top\",parseInt(oldRelateT) - parseInt(height));\n                  $(\"#\"+key).css(\"height\",parseInt(oldRelateH)+ parseInt(height));\n                }else{\n                  $(\"#\"+key).css(\"top\",parseInt(oldRelateT) + parseInt(height));\n                  $(\"#\"+key).css(\"height\",parseInt(oldRelateH)- parseInt(height));\n                }\n              });\n            }\n\n            var renderArr = $renderArr;\n            if(!!renderArr &&renderArr.length>0 ){\n              renderArr.forEach(function(key){\n                // re-render\n                // \u8868\u683c\n                if($('#'+key).hasClass('layui-table-wrap')){\n                  eval(key+\"_table()\");\n                  eval(key+\"_tableInit()\");\n                }\n              });\n            }\n        \n            if(isOpen){\n              // \u9690\u85cf\n              $('#$childRootKey').hide();\n              $(this).data(\"isOpen\",false);\n              $(this).removeClass(\"Open\");\n            }else{\n              // \u663e\u793a\n              $('#$childRootKey').show();\n              $(this).data(\"isOpen\",true);\n              $(this).addClass(\"Open\");\n            }\n      });";
        Map<String, List<String>> relateInstances = this.componentDto.getRelateInstances();
        List<String> heightArr = relateInstances.get("height");
        List<String> renderArr = relateInstances.get("render");
        template = ToolUtil.isNotEmpty(heightArr) && heightArr.size() > 0 ? template.replace("$adjustHeightArr", JSON.toJSONString(heightArr)) : template.replace("$adjustHeightArr", "\"\"");
        template = ToolUtil.isNotEmpty(renderArr) && renderArr.size() > 0 ? template.replace("$renderArr", JSON.toJSONString(renderArr)) : template.replace("$renderArr", "\"\"");
        template = template.replace("$childRootKey", rootInstanceKey);
        template = template.replace("$id", this.componentDto.getInstanceKey());
        return template;
    }

    @Override
    public String renderCSS(Map<String, Object> props, Map<String, Object> interactive) {
        StringBuilder result = new StringBuilder();
        StringBuilder contentBackground = new StringBuilder();
        if (props.containsKey("backgroundColor")) {
            contentBackground.append("background-color:").append(props.get("backgroundColor")).append("\n");
        }
        if (contentBackground.length() > 0) {
            String template = "#$id .layui-query-inner{\n $content}";
            template = template.replace("$id", this.componentDto.getInstanceKey());
            template = template.replace("$content", contentBackground);
            result.append(template).append("\n");
        }
        return result.toString();
    }
}

