/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.common.utildata;

import com.baomidou.mybatisplus.generator.formdesign.config.po.TableField;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableInfo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.GenCodePreData;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.GenPreDataUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.utildata.DependReturnMap;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.utildata.TableRelationShipInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableReturnMap {
    private GenCodePreData genCodePreData;
    private List<TableField> mainFields;
    private String tableName;
    private List<DependReturnMap> dependReturnMaps;

    public TableReturnMap(GenCodePreData genCodePreData) {
        this.genCodePreData = genCodePreData;
    }

    public void addMainField(TableField tableField, String tableName) {
        if (null == this.mainFields) {
            this.mainFields = new ArrayList<TableField>();
        }
        this.tableName = tableName;
        this.mainFields.add(tableField);
    }

    public void addDependReturnMap(TableField tableField, String tableName, TableRelationShipInfo tableRelationShipInfo) {
        if (null == this.dependReturnMaps) {
            this.dependReturnMaps = new ArrayList<DependReturnMap>();
        }
        boolean flag = false;
        for (DependReturnMap dependReturnMap : this.dependReturnMaps) {
            if (!dependReturnMap.getTableName().equals(tableName)) continue;
            flag = true;
            dependReturnMap.addReFields(tableField);
        }
        if (!flag) {
            DependReturnMap dependReturnMap = new DependReturnMap();
            dependReturnMap.setTableName(tableName);
            dependReturnMap.setTableRelationShipInfo(tableRelationShipInfo);
            dependReturnMap.addReFields(tableField);
            this.dependReturnMaps.add(dependReturnMap);
        }
    }

    public Map<String, String> getTableAlias() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.tableName, "T1");
        if (ToolUtil.isNotEmpty(this.dependReturnMaps)) {
            for (int i = 0; i < this.dependReturnMaps.size(); ++i) {
                map.put(this.dependReturnMaps.get(i).getTableName(), "T" + (i + 2));
            }
        }
        return map;
    }

    public String getTableRelatedSql() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("FROM ").append(this.tableName).append(" T1").append("\n");
        String temple = "LEFT JOIN $TABLE_R $TABLE_A ON T1.$R_M = $TABLE_A.$R_R";
        for (DependReturnMap dependReturnMap : this.dependReturnMaps) {
            String tName = dependReturnMap.getTableName();
            String aName = this.getTableAlias().get(tName);
            TableRelationShipInfo tableRelationShipInfo = dependReturnMap.getTableRelationShipInfo();
            stringBuilder.append(temple.replace("$TABLE_R", tName).replace("$TABLE_A", aName).replace("$R_M", GenPreDataUtil.getRealTFNameFromG(this.genCodePreData, this.tableName, tableRelationShipInfo.getField())).replace("$R_R", GenPreDataUtil.getRealTFNameFromG(this.genCodePreData, tName, tableRelationShipInfo.getReField()))).append("\n");
        }
        return stringBuilder.toString();
    }

    public String getReturn() {
        StringBuilder stringBuilder = new StringBuilder(256);
        String tem = "$ALIAS.$FIELD AS $VALUE";
        for (TableField tableField : this.mainFields) {
            stringBuilder.append(tem.replace("$ALIAS", "T1").replace("$FIELD", tableField.getName()).replace("$VALUE", tableField.getPropertyName())).append(",\n");
        }
        for (DependReturnMap dependReturnMap : this.dependReturnMaps) {
            for (TableField tableField : dependReturnMap.getReFields()) {
                stringBuilder.append(tem.replace("$ALIAS", this.getTableAlias().get(dependReturnMap.getTableName())).replace("$FIELD", tableField.getName()).replace("$VALUE", tableField.getPropertyName())).append(",\n");
            }
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    public String getWhereInfo() {
        TableInfo tableInfo = this.getMainTableInfo();
        String keyName = this.getMainTableInfoKeyName();
        String tem = "T1.$FIELD = #{$FIELD}";
        String temMain = "T1.$FIELD = #{$_FIELDID}";
        return " WHERE " + temMain.replace("$FIELD", keyName).replace("$_FIELDID", tableInfo.getEnName() + "Id");
    }

    public String getMultiFormArgs() {
        StringBuilder stringBuilder = new StringBuilder(256);
        String keyName = this.getMainTableInfoKeyName();
        String tem = ",String $FIELD ";
        for (DependReturnMap dependReturnMap : this.dependReturnMaps) {
            String mainReField = dependReturnMap.getTableRelationShipInfo().getField();
            if ("".equals(keyName) || keyName.equals(mainReField)) continue;
            stringBuilder.append(tem.replace("$FIELD", mainReField));
        }
        return stringBuilder.toString();
    }

    public String getSendMultiFormArgs() {
        StringBuilder stringBuilder = new StringBuilder(256);
        String keyName = this.getMainTableInfoKeyName();
        String tem = ",$FIELD ";
        for (DependReturnMap dependReturnMap : this.dependReturnMaps) {
            String mainReField = dependReturnMap.getTableRelationShipInfo().getField();
            if ("".equals(keyName) || keyName.equals(mainReField)) continue;
            stringBuilder.append(tem.replace("$FIELD", mainReField));
        }
        return stringBuilder.toString();
    }

    public String getMapperMultiFormArgs() {
        StringBuilder stringBuilder = new StringBuilder(256);
        String keyName = this.getMainTableInfoKeyName();
        String tem = ",@Param(\"$FIELD\")String $FIELD ";
        for (DependReturnMap dependReturnMap : this.dependReturnMaps) {
            String mainReField = dependReturnMap.getTableRelationShipInfo().getField();
            if ("".equals(keyName) || keyName.equals(mainReField)) continue;
            stringBuilder.append(tem.replace("$FIELD", mainReField));
        }
        return stringBuilder.toString();
    }

    private TableInfo getMainTableInfo() {
        return this.genCodePreData.getTableInfos().get(this.tableName);
    }

    private String getMainTableInfoKeyName() {
        TableInfo tableInfo = this.getMainTableInfo();
        if (null != tableInfo) {
            return tableInfo.getKeyPropertyName();
        }
        return "";
    }

    public GenCodePreData getGenCodePreData() {
        return this.genCodePreData;
    }

    public List<TableField> getMainFields() {
        return this.mainFields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<DependReturnMap> getDependReturnMaps() {
        return this.dependReturnMaps;
    }

    public void setGenCodePreData(GenCodePreData genCodePreData) {
        this.genCodePreData = genCodePreData;
    }

    public void setMainFields(List<TableField> mainFields) {
        this.mainFields = mainFields;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDependReturnMaps(List<DependReturnMap> dependReturnMaps) {
        this.dependReturnMaps = dependReturnMaps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableReturnMap)) {
            return false;
        }
        TableReturnMap other = (TableReturnMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GenCodePreData this$genCodePreData = this.getGenCodePreData();
        GenCodePreData other$genCodePreData = other.getGenCodePreData();
        if (this$genCodePreData == null ? other$genCodePreData != null : !this$genCodePreData.equals(other$genCodePreData)) {
            return false;
        }
        List<TableField> this$mainFields = this.getMainFields();
        List<TableField> other$mainFields = other.getMainFields();
        if (this$mainFields == null ? other$mainFields != null : !((Object)this$mainFields).equals(other$mainFields)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<DependReturnMap> this$dependReturnMaps = this.getDependReturnMaps();
        List<DependReturnMap> other$dependReturnMaps = other.getDependReturnMaps();
        return !(this$dependReturnMaps == null ? other$dependReturnMaps != null : !((Object)this$dependReturnMaps).equals(other$dependReturnMaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableReturnMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GenCodePreData $genCodePreData = this.getGenCodePreData();
        result = result * 59 + ($genCodePreData == null ? 43 : $genCodePreData.hashCode());
        List<TableField> $mainFields = this.getMainFields();
        result = result * 59 + ($mainFields == null ? 43 : ((Object)$mainFields).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<DependReturnMap> $dependReturnMaps = this.getDependReturnMaps();
        result = result * 59 + ($dependReturnMaps == null ? 43 : ((Object)$dependReturnMaps).hashCode());
        return result;
    }

    public String toString() {
        return "TableReturnMap(genCodePreData=" + this.getGenCodePreData() + ", mainFields=" + this.getMainFields() + ", tableName=" + this.getTableName() + ", dependReturnMaps=" + this.getDependReturnMaps() + ")";
    }
}

