/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.cell.base;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.BaseCell;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import java.util.ArrayList;
import java.util.Map;
import org.jsoup.nodes.Element;

public class DynamicPanel
extends BaseCell {
    public DynamicPanel() {
        this.renderPorp = false;
    }

    @Override
    public void prepareEmbedElementRender(Map<String, ComponentDto> componentDtoMap) {
        JSONObject dynamicInstances = (JSONObject)this.componentDto.getProps().get("dynamicInstances");
        for (Map.Entry entry : dynamicInstances.entrySet()) {
            JSONObject jo = (JSONObject)entry.getValue();
            if (jo == null) continue;
            String rootInstanceKey = jo.getString("rootInstanceKey");
            this.slots.put(entry.getKey(), rootInstanceKey);
            this.componentDto.getChildren().add(rootInstanceKey);
        }
    }

    @Override
    public void dealEmbedElementRendered(Element element) {
        JSONObject dynamicInstances = (JSONObject)this.componentDto.getProps().get("dynamicInstances");
        String activeState = ((JSONObject)this.componentDto.getProps().get("dynamicStateActive")).getString("id");
        ArrayList<Element> waitForAppend = new ArrayList<Element>();
        boolean dontDisplay = false;
        for (Map.Entry entry : dynamicInstances.entrySet()) {
            String contentRootInstanceKey = (String)this.slots.get(entry.getKey());
            if (contentRootInstanceKey == null) continue;
            Element tmp = element.getElementById(contentRootInstanceKey);
            tmp.attr("data-panel-name", (String)entry.getKey());
            waitForAppend.add(tmp);
            if (((String)entry.getKey()).equals(activeState)) continue;
            String styleStr = tmp.attr("style");
            if (!styleStr.contains("display:none;")) {
                styleStr = styleStr + ";display:none;";
            }
            tmp.attr("style", styleStr);
        }
        element.html("");
        for (Element el : waitForAppend) {
            element.append(el.outerHtml());
        }
    }

    @Override
    public String renderScript(Map<String, Object> cellProperties) {
        String template = "function dyaPanelChangeState_$id(state){\n$(\"#$id > [data-panel-name]\").hide();\n$(\"#$id > [data-panel-name=\" + state + \"]\").show();\n}";
        template = template.replace("$id", this.componentDto.getInstanceKey());
        return template;
    }
}

