/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.commonmethod.controller;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.commonmethod.entity.TreeSelect;
import com.jxdinfo.hussar.formdesign.commonmethod.service.ITreeSelectService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="/commonMethod/treeSelect")
@RequestMapping(value={"/commonMethod/treeSelect"})
public class TreeSelectController {
    @Autowired
    private ITreeSelectService treeSelectService;

    @RequestMapping(value={"/getDicData"})
    @ResponseBody
    public Object getDicData(String dicId) {
        ArrayList<TreeSelect> childDicList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)dicId)) {
            List<TreeSelect> totalDicList = this.treeSelectService.getAllDicList();
            childDicList = totalDicList.stream().filter(dicInfo -> dicInfo.getTypeId().equals(dicId)).collect(Collectors.toList());
            this.getChildDic(childDicList, totalDicList);
            return childDicList;
        }
        return "[{\"id\": 0,\"name\": \"\u9009\u9879\u4e00\",\"open\": false,\"children\": [{\"id\": 1,\"name\": \"\u9009\u9879\u4e8c\",\"open\": false,\"checked\": false},{\"id\": 2,\"name\": \"\u9009\u9879\u4e09\",\"open\": false,\"checked\": false}],\"checked\": false},{\"id\": 3,\"name\": \"\u9009\u9879\u56db\",\"open\": false,\"checked\": true }";
    }

    public void getChildDic(List<TreeSelect> childDicList, List<TreeSelect> totalDicList) {
        ArrayList<TreeSelect> allChildList = new ArrayList<TreeSelect>();
        for (TreeSelect dic : childDicList) {
            List<TreeSelect> childList = totalDicList.stream().filter(dicInfo -> dicInfo.getTypeId().equals(dic.getDicId())).collect(Collectors.toList());
            if (childList.size() <= 0) continue;
            dic.setChildren(childList);
            allChildList.addAll(childList);
        }
        if (allChildList.size() <= 0) {
            return;
        }
        this.getChildDic(allChildList, totalDicList);
    }
}

