/**
* 流程列表删除
*/
@PostMapping(value = "/${name!}")
${businessLog!}
public ApiResponse<?> ${name!}(String id){
    <#--基础数据模型-->
    <#--引用数据模型-->
    // 删除业务数据
    ${table.serviceEnName}.${name!}Business(id);
    // 删除流程数据
    return ${table.serviceEnName}.${name!}(id);
}

/**
* 流程列表删除(仅删除未启动流程和节点处于第一节点的流程)
*/
@PostMapping(value = "/${name!}UnStart")
${businessLog!}
public ApiResponse<?> ${name!}UnStart(String id){
    // 验证流程状态
    BpmResponseResult validateResult;
    try {
        // 切换数据源
        DataSourceUtil.changeTempDs("${DBName!}");
        validateResult = InstanceEngineService.validateDeleteByBusinessKey(id);
    } finally {
        DataSourceUtil.poll();
    }
    if ("1".equals(validateResult.getCode())) {
        String state = validateResult.getResult().get(0) == null ? "" : validateResult.getResult().get(0).toString();
        switch (state) {
                //1 代表流程已经启动，并且节点处于第一节点，可以删除业务数据和流程数据
                case "1":
                    // 删除业务数据
                    ${table.serviceEnName}.${name!}Business(id);
                    // 删除流程数据
                    return ${table.serviceEnName}.${name!}(id);
                //2 代表流程已经启动，并且节点不处于第一节点，不可以删除业务数据和流程数据
                case "2":
                    return ApiResponse.fail(validateResult.getMsg());
                    //0 代表流程没有启动，可以删除业务数据，不需要删除流程数据
                case "0":
                    // 删除业务数据
                    ${table.serviceEnName}.${name!}Business(id);
                    return ApiResponse.success("");
                default:
                    return ApiResponse.fail("删除失败！");
        }
    }
    return ApiResponse.fail("删除失败！");
}