/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.formdesign.permission.handler;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.codegenerator.core.handler.StateHandler;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.StateVisitor;
import com.jxdinfo.hussar.formdesign.formdesign.permission.common.BpmPageState;
import com.jxdinfo.hussar.formdesign.formdesign.permission.common.BpmStateConditionItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="stateHandler.bpm")
public class BpmStateHandler
implements StateHandler {
    public void handlerState(Object data, Ctx ctx) throws LcdpException {
        Map pageState = (Map)data;
        ArrayList<String> stateList = new ArrayList<String>();
        for (Map.Entry entrys : pageState.entrySet()) {
            Map pages = (Map)entrys.getValue();
            for (Map.Entry entry : pages.entrySet()) {
                BpmPageState page = (BpmPageState)JSON.parseObject((String)JSON.toJSONString(entry.getValue()), BpmPageState.class);
                ArrayList<String> stateCodes = new ArrayList<String>();
                String conditionFrame = "// " + page.getText() + "\u4ee3\u7801start\nif (${condition}){\n${body}\n}\n";
                BpmStateConditionItem conditionItems = page.getCondition();
                String conditionArg = "HussarRouter.query(self, 'processDefinitionKey') + HussarRouter.query(self, 'taskDefinitionKey') === '" + conditionItems.getWorkflowKey() + conditionItems.getTaskDefinitionKey() + "'";
                conditionFrame = conditionFrame.replace("${condition}", "".equals(conditionArg) ? "''" : conditionArg);
                Map<String, List<String>> instances = page.getInstances();
                if (instances != null) {
                    for (Map.Entry<String, List<String>> e : instances.entrySet()) {
                        String stateName = e.getKey();
                        List<String> componentIds = e.getValue();
                        Map componentMap = ctx.getComponentMap();
                        for (String componentInstanceKey : componentIds) {
                            LcdpComponent stateComponent = (LcdpComponent)componentMap.get(componentInstanceKey);
                            if (stateComponent == null) continue;
                            StateVisitor stateVisitor = (StateVisitor)stateComponent.getProvideVisitor("state");
                            stateVisitor.visit(stateComponent, ctx, null);
                            switch (stateName) {
                                case "disabled": {
                                    String disableFunc = stateVisitor.setDisable();
                                    stateCodes.add(disableFunc);
                                    break;
                                }
                                case "readonly": {
                                    String readonlyFunc = stateVisitor.setReadOnly();
                                    stateCodes.add(readonlyFunc);
                                    break;
                                }
                                case "hide": {
                                    String hideFunc = stateVisitor.setHidden();
                                    stateCodes.add(hideFunc);
                                    break;
                                }
                            }
                        }
                    }
                }
                String finalCode = conditionFrame.replace("${body}", String.join((CharSequence)"\n", stateCodes)) + "// " + page.getText() + "\u4ee3\u7801end\n";
                stateList.add(finalCode);
            }
        }
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("stateList", stateList);
        ctx.addMethod("jxd_0BpmStateHandler", RenderUtil.renderTemplate((String)"/template/workflow/bpmStateHandler/bpmStateHandler.ftl", params));
        ctx.addMounted("self.jxd_0BpmStateHandler();");
    }
}

