/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.storage.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.storage.client.service.RecordService;
import com.jxdinfo.hussar.formdesign.storage.common.annotations.RecordTable;
import com.jxdinfo.hussar.formdesign.storage.common.model.RecordEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.RecordQuery;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageConfiguration;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.utils.HttpUtil;
import com.jxdinfo.hussar.formdesign.storage.common.utils.RecordEntityUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class RecordServiceImpl
implements RecordService {
    private final StorageConfiguration config;

    public RecordServiceImpl(StorageConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    @Override
    public <T> StorageResult<String> put(Class<T> clazz, T pojo) {
        StorageResult<List<String>> result = this.put(clazz, Collections.singletonList(pojo));
        return result.map(list -> list != null && list.size() > 0 ? (String)list.get(0) : null);
    }

    @Override
    public <T> StorageResult<List<String>> put(Class<T> clazz, List<T> list) {
        if (list == null || clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        ArrayList<RecordEntity> records = new ArrayList<RecordEntity>(list.size());
        for (T pojo : list) {
            records.add(RecordEntityUtil.encode(pojo));
        }
        HttpResponse response = HttpUtil.request("POST", this.config.getAddr(), this.getPath(table), null, this.getHeaders(), records);
        return this.getStringList(response);
    }

    @Override
    public <T> StorageResult<T> get(Class<T> clazz, String id) {
        StorageResult<List<List>> result = this.get(clazz, Collections.singletonList(id));
        return result.map(list -> list != null && list.size() > 0 ? list.get(0) : null);
    }

    @Override
    public <T> StorageResult<List<T>> get(Class<T> clazz, List<String> ids) {
        if (ids == null || clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        Map<String, String> params = Collections.singletonMap("keys", String.join((CharSequence)",", ids));
        HttpResponse response = HttpUtil.request("GET", this.config.getAddr(), this.getPath(table), params, this.getHeaders(), null);
        return this.convertGetResult(clazz, response);
    }

    @Override
    public <T> StorageResult<List<T>> getAll(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        HttpResponse response = HttpUtil.request("GET", this.config.getAddr(), this.getPath(table), null, this.getHeaders(), null);
        return this.convertGetResult(clazz, response);
    }

    @Override
    public <T> StorageResult<List<T>> getMatches(Class<T> clazz, RecordQuery query) {
        if (query == null || clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        HttpResponse response = HttpUtil.request("GET", this.config.getAddr(), this.getPath(table), null, this.getHeaders(), query);
        return this.convertGetResult(clazz, response);
    }

    private <T> StorageResult<List<T>> convertGetResult(Class<T> clazz, HttpResponse response) {
        StorageResult<List<RecordEntity>> result = this.getRecordEntityList(response);
        return result.map(list -> list.stream().map(record -> RecordEntityUtil.decode(clazz, record)).collect(Collectors.toList()));
    }

    @Override
    public StorageResult<String> delete(Class<?> clazz, String id) {
        StorageResult<List<String>> result = this.delete(clazz, Collections.singletonList(id));
        return result.map(list -> list != null && list.size() > 0 ? (String)list.get(0) : null);
    }

    @Override
    public StorageResult<List<String>> delete(Class<?> clazz, List<String> ids) {
        if (ids == null || clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        Map<String, String> params = Collections.singletonMap("keys", String.join((CharSequence)",", ids));
        HttpResponse response = HttpUtil.request("DELETE", this.config.getAddr(), this.getPath(table), params, this.getHeaders(), null);
        return this.getStringList(response);
    }

    @Override
    public StorageResult<List<String>> deleteAll(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        HttpResponse response = HttpUtil.request("DELETE", this.config.getAddr(), this.getPath(table), null, this.getHeaders(), null);
        return this.getStringList(response);
    }

    @Override
    public StorageResult<List<String>> deleteMatches(Class<?> clazz, RecordQuery query) {
        if (query == null || clazz == null) {
            throw new NullPointerException();
        }
        String table = this.checkClassAndGetTableName(clazz);
        HttpResponse response = HttpUtil.request("DELETE", this.config.getAddr(), this.getPath(table), null, this.getHeaders(), query);
        return this.getStringList(response);
    }

    private Header[] getHeaders() {
        return new Header[]{new BasicHeader("X-File-Cipher-Key", this.config.getCipher())};
    }

    private String getPath(String table) {
        return "/" + this.config.getWorkspace() + "/table/" + table;
    }

    private String checkClassAndGetTableName(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Class<?> idType = RecordEntityUtil.getIdType(clazz);
        if (String.class != idType) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u672a\u5b9a\u4e49\u4e3b\u952e\uff0c\u6216\u4e3b\u952e\u7c7b\u578b\u4e0d\u662f\u5b57\u7b26\u4e32");
        }
        RecordTable annotation = clazz.getAnnotation(RecordTable.class);
        String table = annotation != null && !annotation.value().isEmpty() ? annotation.value() : clazz.getSimpleName();
        return table;
    }

    private StorageResult<List<String>> getStringList(HttpResponse response) {
        try {
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            return (StorageResult)JSON.parseObject((String)body, StringListResult.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private StorageResult<List<RecordEntity>> getRecordEntityList(HttpResponse response) {
        try {
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            return (StorageResult)JSON.parseObject((String)body, RecordEntityResult.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class RecordEntityResult
    extends StorageResult<List<RecordEntity>> {
        private RecordEntityResult() {
        }
    }

    private static class StringListResult
    extends StorageResult<List<String>> {
        private StringListResult() {
        }
    }
}

