/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.storage.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageConfiguration;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CodeEnum;
import com.jxdinfo.hussar.formdesign.storage.common.utils.HttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class StorageServiceImpl
implements StorageService {
    private final StorageConfiguration config;

    public StorageServiceImpl(StorageConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    @Override
    public StorageResult<Boolean> uploadByPath(String path, byte[] content, boolean retry) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (retry) {
            params.put("retry", "true");
        } else {
            params.put("retry", "false");
        }
        return this.getBoolean(HttpUtil.doPost(this.getAddr(), this.getUrl(null, path, null), this.getHeaders(null), params, content));
    }

    @Override
    public StorageResult<Boolean> uploadByUuid(CategoryEnum category, String uuid, String path, byte[] content, boolean retry) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (retry) {
            params.put("retry", "true");
        } else {
            params.put("retry", "false");
        }
        return this.getBoolean(HttpUtil.doPost(this.getAddr(), this.getUrl(category, path, null), this.getHeaders(uuid), params, content));
    }

    @Override
    public StorageResult<Boolean> uploadByUuidByAppId(CategoryEnum category, String uuid, String path, byte[] content, boolean retry, String appId) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (retry) {
            params.put("retry", "true");
        } else {
            params.put("retry", "false");
        }
        return this.getBoolean(HttpUtil.doPost(this.getAddr(), this.getUrl(category, path, null), this.getHeaders(uuid), params, content));
    }

    @Override
    public StorageResult<byte[]> downloadByPath(String path) {
        return this.getBytes(HttpUtil.doGet(this.getAddr(), this.getUrl(null, path, null), this.getHeaders(null), null));
    }

    @Override
    public StorageResult<byte[]> downloadByUuid(CategoryEnum category, String uuid) {
        return this.getBytes(HttpUtil.doGet(this.getAddr(), this.getUrl(category, uuid, null), this.getHeaders(uuid), null));
    }

    @Override
    public StorageResult<String> getFilePathByUuid(CategoryEnum category, String uuid) {
        return this.getFilePath(HttpUtil.doGet(this.getAddr(), this.getUrl(category, uuid, "getFilePath"), this.getHeaders(uuid), null));
    }

    @Override
    public StorageResult<List<StorageEntity>> list(String pathStartWith, String pathEndWith, boolean content) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (content) {
            params.put("content", "true");
        } else {
            params.put("content", "false");
        }
        params.put("pathStartWith", pathStartWith == null ? "" : pathStartWith.replace("\\", "/"));
        params.put("pathEndWith", pathEndWith == null ? "" : pathEndWith.replace("\\", "/"));
        String path = "/" + this.config.getWorkspace() + "/list";
        HttpResponse response = HttpUtil.doGet(this.getAddr(), path, this.getHeaders(null), params);
        if (response != null && response.getEntity() != null && response.getStatusLine().getStatusCode() == 200) {
            try {
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                JSONObject data = JSONObject.parseObject((String)result);
                List list = null;
                if (Boolean.parseBoolean(data.get((Object)"success").toString())) {
                    list = JSONArray.parseArray((String)data.get((Object)"data").toString(), StorageEntity.class);
                }
                return new StorageResult<List<StorageEntity>>(list, Integer.parseInt(data.get((Object)"code").toString()), Boolean.parseBoolean(data.get((Object)"success").toString()), data.get((Object)"msg").toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return StorageResult.failed(null, CodeEnum.CODE_NOT_FOUND);
    }

    @Override
    public StorageResult<Boolean> deleteByPath(String path, boolean retry) {
        return this.getBoolean(HttpUtil.doDelete(this.getAddr(), this.getUrl(null, path, null), this.getHeaders(null), null));
    }

    @Override
    public StorageResult<Boolean> deleteDirByPath(String path, boolean retry) {
        return null;
    }

    @Override
    public StorageResult<Boolean> deleteByUuid(CategoryEnum category, String uuid, boolean retry) {
        return this.getBoolean(HttpUtil.doDelete(this.getAddr(), this.getUrl(category, uuid, null), this.getHeaders(uuid), null));
    }

    @Override
    public StorageResult<Boolean> rename(String source, String target, boolean retry) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (retry) {
            params.put("retry", "true");
        } else {
            params.put("retry", "false");
        }
        params.put("source", source.replace("\\", "/"));
        params.put("target", target.replace("\\", "/"));
        String path = '/' + this.config.getWorkspace() + "/rename";
        return this.getBoolean(HttpUtil.doPost(this.getAddr(), path, this.getHeaders(null), params, null));
    }

    @Override
    public StorageResult<Boolean> existsByPath(String path) {
        return this.getBoolean(HttpUtil.doGet(this.getAddr(), this.getUrl(null, path, "exists"), this.getHeaders(null), null));
    }

    @Override
    public StorageResult<Boolean> existsByUuid(CategoryEnum category, String uuid) {
        return this.getBoolean(HttpUtil.doGet(this.getAddr(), this.getUrl(category, uuid, "exists"), this.getHeaders(uuid), null));
    }

    private Header[] getHeaders(String uuid) {
        Header[] headers = uuid != null && !"".equals(uuid) ? new Header[]{new BasicHeader("X-File-Cipher-Key", this.config.getCipher()), new BasicHeader("X-File-UUID", uuid)} : new Header[]{new BasicHeader("X-File-Cipher-Key", this.config.getCipher())};
        return headers;
    }

    private String getAddr() {
        return this.config.getAddr();
    }

    private String getUrl(CategoryEnum category, String pathOrUuid, String extraLogo) {
        StringBuilder url = new StringBuilder();
        url.append("/").append(this.config.getWorkspace());
        if (extraLogo != null) {
            url.append('/').append(extraLogo);
        }
        url.append("/by-");
        if (category == null) {
            url.append(CategoryEnum.PATH.getValue());
        } else if (CategoryEnum.JSON.getValue().equals(category.getValue())) {
            url.append(CategoryEnum.JSON.getValue());
        } else if (CategoryEnum.META.getValue().equals(category.getValue())) {
            url.append(CategoryEnum.META.getValue());
        } else {
            url.append(CategoryEnum.PATH.getValue());
        }
        url.append("/").append(pathOrUuid != null ? pathOrUuid : "");
        return url.toString();
    }

    private StorageResult<Boolean> getBoolean(HttpResponse response) {
        if (response != null && response.getEntity() != null) {
            try {
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                JSONObject data = JSONObject.parseObject((String)result);
                return new StorageResult<Boolean>(data.get((Object)"data") == null ? null : Boolean.valueOf(Boolean.parseBoolean(data.get((Object)"data").toString())), Integer.parseInt(data.get((Object)"code").toString()), Boolean.parseBoolean(data.get((Object)"success").toString()), data.get((Object)"msg").toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return StorageResult.failed(false, CodeEnum.CODE_NOT_FOUND);
    }

    private StorageResult<byte[]> getBytes(HttpResponse response) {
        if (response != null && response.getEntity() != null) {
            try {
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject data = JSONObject.parseObject((String)result);
                byte[] bytes = null;
                if (Boolean.parseBoolean(data.get((Object)"success").toString())) {
                    bytes = ((StorageEntity)JSONObject.parseObject((String)data.get((Object)"data").toString(), StorageEntity.class)).getContent();
                }
                return new StorageResult<byte[]>(bytes, Integer.parseInt(data.get((Object)"code").toString()), Boolean.parseBoolean(data.get((Object)"success").toString()), data.get((Object)"msg").toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return StorageResult.failed(null, CodeEnum.CODE_NOT_FOUND);
    }

    private StorageResult<String> getFilePath(HttpResponse response) {
        if (response != null && response.getEntity() != null) {
            StorageResult data = null;
            try {
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                data = (StorageResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<StorageResult<String>>(){}, (Feature[])new Feature[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (data == null) {
                return StorageResult.failed(null, CodeEnum.CODE_NOT_FOUND);
            }
            if (data.getData() == null) {
                data.setData("");
            }
            return data;
        }
        return StorageResult.failed(null, CodeEnum.CODE_NOT_FOUND);
    }
}

