/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.storage.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RecordQuery {
    private List<List<Condition>> expression;

    public static Builder builder() {
        return new Builder();
    }

    public List<List<Condition>> getExpression() {
        return this.expression;
    }

    public void setExpression(List<List<Condition>> expression) {
        this.expression = expression;
    }

    public String toString() {
        if (this.expression == null) {
            return Objects.toString(null);
        }
        if (this.expression.size() == 0) {
            return "false";
        }
        return this.expression.stream().map(andList -> {
            if (andList == null) {
                return Objects.toString(null);
            }
            if (andList.size() == 0) {
                return "true";
            }
            return andList.stream().map(Condition::toString).collect(Collectors.joining(" && "));
        }).collect(Collectors.joining(" || "));
    }

    public static class Builder {
        private List<List<Condition>> tree = new ArrayList<List<Condition>>();
        private boolean or = false;

        public Builder equal(String field, Object value) {
            this.push(Condition.equal(field, value));
            return this;
        }

        public Builder notEqual(String field, Object value) {
            this.push(Condition.notEqual(field, value));
            return this;
        }

        public Builder between(String field, Object from, Object to) {
            this.push(Condition.between(field, from, to));
            return this;
        }

        public Builder startsWith(String field, String value) {
            this.push(Condition.startsWith(field, value));
            return this;
        }

        public Builder or() {
            this.or = true;
            return this;
        }

        public Builder or(Consumer<Builder> subBuilding) {
            this.or = true;
            Builder subBuilder = new Builder();
            subBuilding.accept(subBuilder);
            RecordQuery subQuery = subBuilder.build();
            this.push(subQuery.getExpression());
            return this;
        }

        public Builder and(Consumer<Builder> subBuilding) {
            this.or = false;
            Builder subBuilder = new Builder();
            subBuilding.accept(subBuilder);
            RecordQuery subQuery = subBuilder.build();
            this.push(subQuery.getExpression());
            return this;
        }

        public RecordQuery build() {
            RecordQuery query = new RecordQuery();
            query.setExpression(this.tree);
            return query;
        }

        private void push(Condition condition) {
            if (this.or) {
                ArrayList<Condition> and = new ArrayList<Condition>();
                and.add(condition);
                this.tree.add(and);
            } else {
                if (this.tree.size() == 0) {
                    this.tree.add(new ArrayList());
                }
                for (List<Condition> and : this.tree) {
                    and.add(condition);
                }
            }
            this.or = false;
        }

        private void push(List<List<Condition>> other) {
            if (other.size() == 0) {
                return;
            }
            if (this.or) {
                this.tree.addAll(other);
            } else {
                if (this.tree.size() == 0) {
                    this.tree.add(new ArrayList());
                }
                ArrayList<List<Condition>> intersection = new ArrayList<List<Condition>>();
                for (List<Condition> left : this.tree) {
                    for (List<Condition> right : other) {
                        ArrayList<Condition> item = new ArrayList<Condition>();
                        item.addAll(left);
                        item.addAll(right);
                        intersection.add(item);
                    }
                }
                this.tree = intersection;
            }
            this.or = false;
        }
    }

    public static class Condition {
        public static final String OP_EQUAL = "=";
        public static final String OP_NOT_EQUAL = "!=";
        public static final String OP_STARTS_WITH = "^~";
        public static final String OP_BETWEEN = "..";
        private String op;
        private String name;
        private Object value;
        private Object from;
        private Object to;

        public static Condition equal(String field, Object value) {
            Condition condition = new Condition();
            condition.setOp(OP_EQUAL);
            condition.setName(field);
            condition.setValue(value);
            return condition;
        }

        public static Condition notEqual(String field, Object value) {
            Condition condition = new Condition();
            condition.setOp(OP_NOT_EQUAL);
            condition.setName(field);
            condition.setValue(value);
            return condition;
        }

        public static Condition between(String field, Object from, Object to) {
            Condition condition = new Condition();
            condition.setOp(OP_BETWEEN);
            condition.setName(field);
            condition.setFrom(from);
            condition.setTo(to);
            return condition;
        }

        public static Condition startsWith(String field, String value) {
            Condition condition = new Condition();
            condition.setOp(OP_STARTS_WITH);
            condition.setName(field);
            condition.setValue(value);
            return condition;
        }

        public String getOp() {
            return this.op;
        }

        public void setOp(String op) {
            this.op = op;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getFrom() {
            return this.from;
        }

        public void setFrom(Object from) {
            this.from = from;
        }

        public Object getTo() {
            return this.to;
        }

        public void setTo(Object to) {
            this.to = to;
        }

        public String toString() {
            if (this.op == null) {
                return "<op null>";
            }
            switch (this.op) {
                case "=": 
                case "!=": 
                case "^~": {
                    return this.name + " " + this.op + " " + this.value;
                }
                case "..": {
                    return this.name + " between " + this.from + " and " + this.to;
                }
            }
            return "<op " + this.op + ">";
        }
    }
}

