/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.storage.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.storage.common.annotations.RecordId;
import com.jxdinfo.hussar.formdesign.storage.common.model.RecordEntity;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class RecordEntityUtil {
    private static final Set<Class<?>> SIMPLE_CLASSES = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, String.class, Double.class, Byte.class, Boolean.class, Short.class, Float.class));

    public static RecordEntity fromJson(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        RecordEntity record = new RecordEntity();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            record.put(entry.getKey(), RecordEntityUtil.encodeField(entry.getValue()));
        }
        return record;
    }

    public static RecordEntity encode(Object pojo) {
        if (pojo == null) {
            return null;
        }
        RecordEntity record = new RecordEntity();
        Map<String, PropertyDescriptor> properties = RecordEntityUtil.resolveProperties(pojo.getClass());
        for (Map.Entry<String, PropertyDescriptor> entry : properties.entrySet()) {
            try {
                Object value;
                Method getter = entry.getValue().getReadMethod();
                if (getter == null || (value = getter.invoke(pojo, new Object[0])) == null) continue;
                record.put(entry.getKey(), RecordEntityUtil.encodeField(value));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
        return record;
    }

    public static <T> T decode(Class<T> clazz, RecordEntity record) {
        Object pojo;
        try {
            pojo = ConstructorUtils.invokeConstructor(clazz, null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        Map<String, PropertyDescriptor> properties = RecordEntityUtil.resolveProperties(clazz);
        for (Map.Entry<String, PropertyDescriptor> entry : properties.entrySet()) {
            String name = entry.getValue().getName();
            Class<?> type = entry.getValue().getPropertyType();
            Comparable value = record.get(entry.getKey());
            if (type == null || value == null) continue;
            try {
                Method setter = entry.getValue().getWriteMethod();
                if (setter == null) continue;
                setter.invoke(pojo, RecordEntityUtil.decodeField(clazz, name, type, value));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
        return (T)pojo;
    }

    private static Map<String, PropertyDescriptor> resolveProperties(Class<?> clazz) {
        List<PropertyDescriptor> propertyDescriptors = RecordEntityUtil.getPropertyDescriptors(clazz);
        PropertyDescriptor idPropertyDescriptor = RecordEntityUtil.findIdPropertyDescriptor(clazz, propertyDescriptors);
        LinkedHashMap<String, PropertyDescriptor> properties = new LinkedHashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor == idPropertyDescriptor) {
                properties.put("#", idPropertyDescriptor);
                continue;
            }
            properties.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return properties;
    }

    public static Class<?> getIdType(Class<?> clazz) {
        List<PropertyDescriptor> propertyDescriptors = RecordEntityUtil.getPropertyDescriptors(clazz);
        PropertyDescriptor idPropertyDescriptor = RecordEntityUtil.findIdPropertyDescriptor(clazz, propertyDescriptors);
        return idPropertyDescriptor != null ? idPropertyDescriptor.getPropertyType() : null;
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        return Arrays.stream(PropertyUtils.getPropertyDescriptors(clazz)).filter(propertyDescriptor -> !"class".equals(propertyDescriptor.getName())).collect(Collectors.toList());
    }

    private static PropertyDescriptor findIdPropertyDescriptor(Class<?> clazz, List<PropertyDescriptor> propertyDescriptors) {
        PropertyDescriptor idPropertyDescriptor = null;
        for (PropertyDescriptor propertyDescriptor2 : propertyDescriptors) {
            String property = propertyDescriptor2.getName();
            if (!RecordEntityUtil.propertyIsId(clazz, property)) continue;
            idPropertyDescriptor = propertyDescriptor2;
            break;
        }
        if (idPropertyDescriptor == null) {
            idPropertyDescriptor = propertyDescriptors.stream().filter(propertyDescriptor -> "id".equals(propertyDescriptor.getName())).findFirst().orElse(null);
        }
        return idPropertyDescriptor;
    }

    private static boolean propertyIsId(Class<?> clazz, String property) {
        try {
            Field field = clazz.getDeclaredField(property);
            return field.getAnnotation(RecordId.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean isSimpleValue(Object value) {
        return value == null || SIMPLE_CLASSES.contains(value.getClass());
    }

    public static Comparable encodeField(Object value) {
        if (value == null) {
            return null;
        }
        if (RecordEntityUtil.isSimpleValue(value)) {
            return (Comparable)value;
        }
        if (value instanceof byte[]) {
            return Base64.getEncoder().encodeToString((byte[])value);
        }
        try {
            return JSON.toJSONString((Object)value, (boolean)false);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Object decodeField(Class<?> pojoClazz, String pojoField, Class<?> clazz, Comparable value) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return RecordEntityUtil.convert(clazz, ((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return RecordEntityUtil.convert(clazz, (Long)value);
        }
        if (value instanceof String) {
            return RecordEntityUtil.convert(pojoClazz, pojoField, clazz, (String)((Object)value));
        }
        if (value instanceof Double) {
            return RecordEntityUtil.convert(clazz, (Double)value);
        }
        if (value instanceof Byte) {
            return RecordEntityUtil.convert(clazz, ((Byte)value).byteValue());
        }
        if (value instanceof Boolean) {
            return RecordEntityUtil.convert(clazz, (Boolean)value);
        }
        if (value instanceof Short) {
            return RecordEntityUtil.convert(clazz, ((Short)value).shortValue());
        }
        if (value instanceof Float) {
            return RecordEntityUtil.convert(clazz, ((Float)value).floatValue());
        }
        throw new IllegalArgumentException();
    }

    private static Object convert(Class<?> clazz, long value) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return (int)value;
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return value;
        }
        if (String.class.equals(clazz)) {
            return String.valueOf(value);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return (double)value;
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            return (byte)value;
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return value != 0L;
        }
        if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            return (short)value;
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(value);
        }
        return null;
    }

    private static Object convert(Class<?> clazz, double value) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return (int)value;
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return (long)value;
        }
        if (String.class.equals(clazz)) {
            return String.valueOf(value);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return value;
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            return (byte)value;
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return !Double.isNaN(value) && value != 0.0;
        }
        if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            return (short)value;
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf((float)value);
        }
        return null;
    }

    private static Object convert(Class<?> clazz, boolean value) {
        int intValue;
        int n = intValue = value ? 1 : 0;
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return intValue;
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return (long)intValue;
        }
        if (String.class.equals(clazz)) {
            return String.valueOf(value);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return (double)intValue;
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            return (byte)intValue;
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return value;
        }
        if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            return (short)intValue;
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(intValue);
        }
        return null;
    }

    private static Object convert(Class<?> pojoClazz, String pojoField, Class<?> clazz, String value) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        if (String.class.equals(clazz)) {
            return value;
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            try {
                return Byte.valueOf(value);
            }
            catch (NumberFormatException e) {
                return (byte)0;
            }
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                return (short)0;
            }
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Float.valueOf(Float.NaN);
            }
        }
        if (byte[].class.equals(clazz)) {
            try {
                return Base64.getDecoder().decode(value);
            }
            catch (IllegalArgumentException e) {
                return new byte[0];
            }
        }
        try {
            return JSON.parseObject((String)value, (Type)pojoClazz.getDeclaredField(pojoField).getGenericType(), (Feature[])new Feature[0]);
        }
        catch (JSONException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }
}

