/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.storage.common.model;

import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CodeEnum;
import java.io.Serializable;
import java.util.function.Function;

public class StorageResult<T>
implements Serializable {
    private boolean success;
    private int code;
    private T data;
    private String msg;

    public StorageResult() {
    }

    public StorageResult(T data, int code, boolean success, String msg) {
        this.success = success;
        this.code = code;
        this.data = data;
        this.msg = msg;
    }

    public static <T> StorageResult<T> succeed(T model) {
        return StorageResult.succeedWith(model, CodeEnum.CODE_OK.getCode(), CodeEnum.CODE_OK.getName());
    }

    public static <T> StorageResult<T> succeed(T model, String msg) {
        return StorageResult.succeedWith(model, CodeEnum.CODE_OK.getCode(), msg);
    }

    public static <T> StorageResult<T> succeedWith(T data, Integer code, String msg) {
        return new StorageResult<T>(data, code, true, msg);
    }

    public static <T> StorageResult<T> failed(T model) {
        return StorageResult.failedWith(model, CodeEnum.CODE_INTERNAL_ERROR.getCode(), CodeEnum.CODE_INTERNAL_ERROR.getName());
    }

    public static <T> StorageResult<T> failed(T model, CodeEnum codeEnum) {
        return StorageResult.failedWith(model, codeEnum.getCode(), codeEnum.getName());
    }

    public static <T> StorageResult<T> failed(T model, int code, String msg) {
        return StorageResult.failedWith(model, code, msg);
    }

    public static <T> StorageResult<T> failedWith(T data, Integer code, String msg) {
        return new StorageResult<T>(data, code, false, msg);
    }

    public <R> StorageResult<R> map(Function<T, R> mapper) {
        StorageResult<R> result = new StorageResult<R>();
        result.setSuccess(this.isSuccess());
        result.setCode(this.getCode());
        result.setMsg(this.getMsg());
        result.setData(mapper.apply(this.getData()));
        return result;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

