/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.storage.common.model;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.iterators.SingletonIterator;

public class RecordEntity
implements Map<String, Comparable> {
    public static final String PROPERTY_ID = "#";
    private String id;
    private Map<String, Comparable> props;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Comparable> getProps() {
        return this.props;
    }

    public void setProps(Map<String, Comparable> props) {
        this.props = props;
    }

    public void generateIdIfNotPresent() {
        if (this.id != null) {
            return;
        }
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
    }

    @Override
    public int size() {
        return (this.id != null ? 1 : 0) + (this.props != null ? this.props.size() : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.id == null && this.props == null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.id != null && PROPERTY_ID.equals(key) || this.props != null && this.props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.id != null && this.id.equals(value) || this.props != null && this.props.containsValue(value);
    }

    @Override
    public Comparable get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        if (PROPERTY_ID.equals(key)) {
            return this.id;
        }
        return this.props != null ? this.props.get(key) : null;
    }

    @Override
    public Comparable put(String property, Comparable value) {
        if (PROPERTY_ID.equals(property)) {
            String old = this.id;
            this.id = value != null ? value.toString() : null;
            return old;
        }
        if (this.props == null) {
            this.props = new LinkedHashMap<String, Comparable>();
        }
        return this.props.put(property, value);
    }

    @Override
    public Comparable remove(Object key) {
        if (PROPERTY_ID.equals(key)) {
            String old = this.id;
            this.id = null;
            return old;
        }
        if (this.props != null) {
            return this.props.remove(key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Comparable> map) {
        for (Map.Entry<? extends String, ? extends Comparable> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.id = null;
        this.props = null;
    }

    @Override
    public Set<String> keySet() {
        if (this.id == null && this.props == null) {
            return Collections.emptySet();
        }
        if (this.id != null && this.props != null) {
            return new OverwriteSet<String>(this.id, this.props.keySet());
        }
        if (this.id != null) {
            return Collections.singleton(this.id);
        }
        return this.props.keySet();
    }

    @Override
    public Collection<Comparable> values() {
        if (this.id == null && this.props == null) {
            return Collections.emptyList();
        }
        if (this.id != null && this.props != null) {
            return new OverwriteCollection<Comparable>((Comparable)((Object)this.id), this.props.values());
        }
        if (this.id != null) {
            return Collections.singleton(this.id);
        }
        return this.props.values();
    }

    @Override
    public Set<Map.Entry<String, Comparable>> entrySet() {
        if (this.id == null && this.props == null) {
            return Collections.emptySet();
        }
        if (this.id != null && this.props != null) {
            return new OverwriteSet<Map.Entry<String, Comparable>>(new IdEntry(this), this.props.entrySet());
        }
        if (this.id != null) {
            return Collections.singleton(new IdEntry(this));
        }
        return this.props.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RecordEntity)) {
            return false;
        }
        RecordEntity that = (RecordEntity)other;
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.keySet());
        keys.addAll(that.keySet());
        for (String key : keys) {
            if (Objects.equals(this.get(key), that.get(key))) continue;
            return false;
        }
        return true;
    }

    private static class IdEntry
    implements Map.Entry<String, Comparable> {
        RecordEntity record;

        public IdEntry(RecordEntity record) {
            this.record = record;
        }

        @Override
        public String getKey() {
            return RecordEntity.PROPERTY_ID;
        }

        @Override
        public Comparable getValue() {
            return this.record.getId();
        }

        @Override
        public Comparable setValue(Comparable value) {
            Comparable old = this.getValue();
            this.record.put(RecordEntity.PROPERTY_ID, value);
            return old;
        }
    }

    private static class OverwriteCollection<T>
    extends AbstractCollection<T> {
        private final T item;
        private final Collection<T> collection;

        public OverwriteCollection(T item, Collection<T> collection) {
            this.item = item;
            this.collection = collection;
        }

        @Override
        public Iterator<T> iterator() {
            SingletonIterator itemIterator = new SingletonIterator(this.item);
            return new IteratorChain((Iterator)itemIterator, this.collection.iterator());
        }

        @Override
        public int size() {
            return 1 + this.collection.size();
        }
    }

    private static class OverwriteSet<T>
    extends AbstractSet<T> {
        private final T item;
        private final Set<T> set;

        public OverwriteSet(T item, Set<T> set) {
            this.item = item;
            this.set = set;
        }

        @Override
        public Iterator<T> iterator() {
            SingletonIterator itemIterator = new SingletonIterator(this.item);
            return new IteratorChain((Iterator)itemIterator, this.set.iterator());
        }

        @Override
        public int size() {
            return 1 + this.set.size();
        }
    }
}

