/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.qddtui.expansion.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.qddtui.expansion.service.IExpansionService;
import com.jxdinfo.hussar.formdesign.qddtui.expansion.vo.MessageVo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.qddtui.expansion.impl.ExpansionServiceImpl")
public class ExpansionServiceImpl
implements IExpansionService {
    private static String assessToken;
    private static Long tokenTimestamp;
    private static String jsapiTicket;
    private static Long jsapiTicketTimestamp;
    private static String jsapiTicketApp;
    private static Long jsapiTicketTimestampApp;

    @Override
    public MessageVo getMessage(String url, String market, String corpId, String corpSecret) {
        long passedSeconds;
        long nowTime = System.currentTimeMillis();
        if ("app".equals(market)) {
            if (ToolUtil.isEmpty((Object)jsapiTicketApp)) {
                this.getAccessToken(corpId, corpSecret);
                this.getJsapiTicket(market, corpId, corpSecret);
            } else {
                passedSeconds = nowTime - jsapiTicketTimestampApp;
                if (passedSeconds >= 0x6DDD00L) {
                    this.getJsapiTicket(market, corpId, corpSecret);
                }
            }
        } else if (ToolUtil.isEmpty((Object)jsapiTicket)) {
            this.getAccessToken(corpId, corpSecret);
            this.getJsapiTicket(market, corpId, corpSecret);
        } else {
            passedSeconds = nowTime - jsapiTicketTimestamp;
            if (passedSeconds >= 0x6DDD00L) {
                this.getJsapiTicket(market, corpId, corpSecret);
            }
        }
        String randomString = UUID.randomUUID().toString();
        String ToolString = "app".equals(market) ? "jsapi_ticket=" + jsapiTicketApp + "&noncestr=" + randomString + "&timestamp=" + nowTime + "&url=" + url : "jsapi_ticket=" + jsapiTicket + "&noncestr=" + randomString + "&timestamp=" + nowTime + "&url=" + url;
        String signature = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hash = digest.digest(ToolString.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            signature = hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setTimestamp(nowTime);
        messageVo.setNonceStr(randomString);
        messageVo.setSignature(signature);
        return messageVo;
    }

    @Override
    public void getMaterial(String mediaId, HttpServletResponse response, String corpId, String corpSecret) {
        block12: {
            Long nowTime = System.currentTimeMillis();
            long passedSeconds = nowTime - tokenTimestamp;
            if (passedSeconds >= 0x6DDD00L) {
                this.getAccessToken(corpId, corpSecret);
            }
            String url = "https://qyapi.weixin.qq.com/cgi-bin/media/get";
            InputStream is = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                uriBuilder.setParameter("access_token", assessToken);
                uriBuilder.setParameter("media_id", mediaId);
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                httpGet.addHeader("Content-Type", "application/json");
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).build();
                httpGet.setConfig(requestConfig);
                CloseableHttpClient httpClient = HttpClients.createDefault();
                CloseableHttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);
                HttpEntity entity = response2.getEntity();
                if (!ToolUtil.isNotEmpty((Object)entity)) break block12;
                is = entity.getContent();
                byte[] bytes = new byte[(int)entity.getContentLength()];
                try {
                    is.read(bytes, 0, (int)entity.getContentLength());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                response.setContentType("multipart/form-data");
                String filename = response2.getHeaders("Content-disposition")[0].getValue();
                String str = StringUtils.substringBetween((String)filename, (String)"filename=\"", (String)"\"");
                String type = response2.getHeaders("Content-Type")[0].getValue();
                response.addHeader("Content-Type", type);
                response.addHeader("Content-disposition", str);
                IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                throw new BaseException("\u83b7\u53d6token\u5931\u8d25");
            }
            finally {
                try {
                    is.close();
                    response.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void getAccessToken(String corpId, String corpSecret) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
        InputStream is = null;
        String body = null;
        StringBuilder res = new StringBuilder();
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            uriBuilder.setParameter("corpid", corpId);
            uriBuilder.setParameter("corpsecret", corpSecret);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.addHeader("Content-Type", "application/json");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (ToolUtil.isNotEmpty((Object)entity)) {
                is = entity.getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, Consts.UTF_8));
                while ((body = br.readLine()) != null) {
                    res.append(body);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6token\u5931\u8d25");
        }
        tokenTimestamp = System.currentTimeMillis();
        HashMap map = (HashMap)JSON.parseObject((String)String.valueOf(res), HashMap.class);
        assessToken = String.valueOf(map.get("access_token"));
    }

    private void getJsapiTicket(String market, String corpId, String corpSecret) {
        HashMap map;
        Long nowTime = System.currentTimeMillis();
        long passedSeconds = nowTime - tokenTimestamp;
        if (passedSeconds >= 0x6DDD00L) {
            this.getAccessToken(corpId, corpSecret);
        }
        String url = "app".equals(market) ? "https://qyapi.weixin.qq.com/cgi-bin/ticket/get" : "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket";
        InputStream is = null;
        String body = null;
        StringBuilder res = new StringBuilder();
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            uriBuilder.setParameter("access_token", assessToken);
            if ("app".equals(market)) {
                uriBuilder.setParameter("type", "agent_config");
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.addHeader("Content-Type", "application/json");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (ToolUtil.isNotEmpty((Object)entity)) {
                is = entity.getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, Consts.UTF_8));
                while ((body = br.readLine()) != null) {
                    res.append(body);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6jsapi_ticket\u5931\u8d25");
        }
        if ("app".equals(market)) {
            jsapiTicketTimestampApp = System.currentTimeMillis();
            map = (HashMap)JSON.parseObject((String)String.valueOf(res), HashMap.class);
            jsapiTicketApp = String.valueOf(map.get("ticket"));
        } else {
            jsapiTicketTimestamp = System.currentTimeMillis();
            map = (HashMap)JSON.parseObject((String)String.valueOf(res), HashMap.class);
            jsapiTicket = String.valueOf(map.get("ticket"));
        }
    }
}

