const countNum = self.${instancekey!}IsMultiple ? 100 : 1;
window.wxConfig.chooseImage({
    count: countNum,
    sizeType: ['original', 'compressed'], // 可以指定是原图还是压缩图，默认二者都有
    sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
    defaultCameraMode: "batch", // 表示进入拍照界面的默认模式，目前有normal与batch两种选择，normal表示普通单拍模式，batch表示连拍模式，不传该参数则为normal模式。从3.0.26版本开始支持front和batch_front两种值，其中front表示默认为前置摄像头单拍模式，batch_front表示默认为前置摄像头连拍模式。（注：用户进入拍照界面仍然可自由切换两种模式）
    isSaveToAlbum: 1, // 整型值，0表示拍照时不保存到系统相册，1表示自动保存，默认值是1
    success: function (res) {
        res.localIds.forEach((id) => {
            const newData = {
                serverId: '',
                localId: id,
            }
            if (method.verifyAndroid()) {
                newData.localData = id;
                if (self.${instancekey!}IsMultiple) {
                    self.${instancekey!}LocalData.push(newData);
                } else {
                    self.${instancekey!}LocalData = [newData];
                }
            } else if (method.verifyIos()) {
                window.wxConfig.getLocalImgData({
                    localId: id,
                    success: function (resData) {
                        newData.localData = resData.localData; // localData是图片的base64数据，可以用img标签显示
                        if (self.${instancekey!}IsMultiple) {
                            self.${instancekey!}LocalData.push(newData);
                        } else {
                            self.${instancekey!}LocalData = [newData];
                        }
                    }
                });
            }
            <#if autoUpload == true>
                // 开启自动上传
                window.wxConfig.uploadImage({
                    localId: id, // 需要上传的图片的本地ID，由chooseImage接口获得
                    isShowProgressTips: 1, // 默认为1，显示进度提示
                    success: function (res) {
                        newData.serverId = res.serverId; // 返回图片的服务器端ID
                        if (self.${instancekey!}IsMultiple) {
                            self.${instancekey!}ServerId += `<#noparse>$</#noparse>{(self.${instancekey!}ServerId !== '' ? ',' : '') + res.serverId}`;
                        } else {
                            self.${instancekey!}ServerId = res.serverId;
                        }
                        self.${valueData!} = self.${instancekey!}ServerId;
                    }
                });
            </#if>
        });
    }
});