/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.move.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.file.move.service.IFileMoveService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="FileMoveServiceOnLineImpl")
@Transactional(rollbackFor={Exception.class})
@Conditional(value={ConditionUseSharedStorage.class})
public class FileMoveServiceOnLineImpl
implements IFileMoveService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private PathStrategyService pathStrategy;
    private final StorageService storageService;

    public FileMoveServiceOnLineImpl(StorageService storageService) {
        this.storageService = storageService;
    }

    @Override
    public Map<String, Object> moveFiles(Map<String, Object> map) throws LcdpException {
        boolean moveJson;
        String oldJsonPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath() + map.get("path");
        String oldMetaPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath() + map.get("pathMeta");
        String type = String.valueOf(map.get("type"));
        String parentId = String.valueOf(map.get("parentId"));
        String newJsonPath = this.getNewJsonPath(parentId, oldMetaPath);
        JSONObject metaFileContent = JSON.parseObject((String)new String((byte[])this.storageService.downloadByPath(oldJsonPath + ".meta").getData(), StandardCharsets.UTF_8));
        boolean moveMeta = (Boolean)this.storageService.rename(oldJsonPath + ".meta", newJsonPath + ".meta", false).getData();
        metaFileContent.put("parentId", (Object)parentId);
        metaFileContent.put("name", (Object)this.getNameByPath(newJsonPath + ".meta"));
        String metaId = metaFileContent.getString("id");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put(metaId, this.getNameByPath(newJsonPath + ".meta"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            moveJson = (Boolean)this.storageService.uploadByUuid(CategoryEnum.META, metaId, newJsonPath + ".meta", new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)metaFileContent).getBytes(StandardCharsets.UTF_8), false).getData();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            resultMap.put("code", 500);
            resultMap.put("msg", "\u79fb\u52a8\u5931\u8d25");
            return resultMap;
        }
        if ("Module".equals(type)) {
            List fileList = (List)this.storageService.list(oldJsonPath + File.separator, "", false).getData();
            for (StorageEntity storageEntity : fileList) {
                if (!Boolean.FALSE.equals(this.storageService.rename(storageEntity.getPath(), newJsonPath + storageEntity.getPath().substring(oldJsonPath.length()), false).getData())) continue;
                moveJson = false;
            }
        } else {
            moveJson = Boolean.TRUE.equals(this.storageService.rename(oldJsonPath, newJsonPath, false).getData());
        }
        if (moveMeta && moveJson) {
            resultMap.put("code", 200);
            resultMap.put("data", nameMap);
            resultMap.put("msg", "\u6587\u4ef6\u79fb\u52a8\u6210\u529f");
        } else {
            resultMap.put("code", 500);
            resultMap.put("msg", "\u79fb\u52a8\u5931\u8d25");
        }
        return resultMap;
    }

    private String getNameByPath(String path) {
        String dataName = path.substring(path.lastIndexOf("/") + 1).substring(path.lastIndexOf("\\") + 1);
        return dataName.substring(0, dataName.indexOf(46));
    }

    private String getNewJsonPath(String newParentId, String oldMetaPath) throws LcdpException {
        String newMetaPath;
        String oldMetaName = oldMetaPath.substring(oldMetaPath.lastIndexOf("/") + 1).substring(oldMetaPath.lastIndexOf("\\") + 1);
        String newParentPath = this.fileMappingService.getDataPath(newParentId);
        String testNewMetaPath = newParentPath + File.separator + oldMetaName;
        if (Boolean.TRUE.equals(this.storageService.existsByPath(testNewMetaPath).getData())) {
            StringBuilder newDataName = new StringBuilder(oldMetaName.substring(0, oldMetaName.indexOf(46)));
            String suffix = oldMetaName.substring(oldMetaName.indexOf(46));
            do {
                newDataName.append('1');
            } while (Boolean.TRUE.equals(this.storageService.existsByPath(newParentPath + newDataName + suffix).getData()));
            newMetaPath = newParentPath + File.separator + newDataName + suffix;
        } else {
            newMetaPath = testNewMetaPath;
        }
        return newMetaPath.substring(0, newMetaPath.lastIndexOf(46));
    }
}

