/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.component.model.CheckInfo;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.PageTemplateInductsInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModelPageTemplateUtil {
    private static final List<String> FUNCTION_TYPE_RANGE = Arrays.asList("BASE", "MASTER_SLAVE", "FLOW", "FLOW_MASTER_SLAVE", "TASK", "TASK_MASTER_SLAVE");
    private static final List<String> PAGE_TYPE_RANGE = Arrays.asList("WebPage", "UniPage", "WebAndUni");
    private static final String ILLEGAL_CHARS_REGEX = "[\\\\/:*?\"<>|\u0000]";

    public static void deleteTempFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void validateManifest(InputStream is, ObjectMapper mapper) throws IOException, IllegalArgumentException {
        JsonNode root = mapper.readTree(is);
        ModelPageTemplateUtil.validateRequiredField(root, "pageType", PAGE_TYPE_RANGE, "manifest.json");
        ModelPageTemplateUtil.validateRequiredField(root, "functionType", FUNCTION_TYPE_RANGE, "manifest.json");
        if (!root.has("templateName") || HussarUtils.isEmpty((Object)root.get("templateName").asText())) {
            throw new IllegalArgumentException("manifest.json\u6587\u4ef6\u7f3a\u5c11\u6a21\u677f\u540d\u79f0");
        }
        if (root.get("templateName").asText().length() > 32) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u8d85\u957f");
        }
        String templateName = root.get("templateName").asText();
        String chars = ModelPageTemplateUtil.validateFileName(templateName);
        if (HussarUtils.isNotEmpty((Object)chars) || templateName.endsWith(".")) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26");
        }
    }

    public static String validateFileName(String fileName) {
        Pattern pattern = Pattern.compile(ILLEGAL_CHARS_REGEX);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.find() ? matcher.group() : null;
    }

    private static void validateRequiredField(JsonNode node, String field, List<String> allowedValues, String fileName) {
        if (!node.has(field) || HussarUtils.isEmpty((Object)node.get(field).asText())) {
            throw new IllegalArgumentException(fileName + "\u6587\u4ef6\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5: " + field);
        }
        String value = node.get(field).asText();
        if (!allowedValues.contains(value)) {
            throw new IllegalArgumentException(fileName + "\u6587\u4ef6\u7684" + field + "\u503c\u975e\u6cd5\uff0c\u5141\u8bb8\u503c: " + allowedValues);
        }
    }

    private static void validateTemplate(InputStream is, String fileName, ObjectMapper mapper) throws IOException {
        JsonNode root = mapper.readTree(is);
        ModelPageTemplateUtil.validateRequiredField(root, "pageType", PAGE_TYPE_RANGE, fileName);
        ModelPageTemplateUtil.validateRequiredField(root, "functionType", FUNCTION_TYPE_RANGE, fileName);
        if (!root.has("tempData") || root.get("tempData").isNull()) {
            throw new IOException(fileName + "\u7f3a\u5c11tempData");
        }
    }

    public static void validateDirectory(Path dir, CheckResult<PageTemplateInductsInfo> checkResult) {
        try (ZipFile zip = new ZipFile(dir.toFile());){
            List jsonEntries = zip.stream().filter(entry -> !entry.isDirectory() && entry.getName().toLowerCase().endsWith(".json")).collect(Collectors.toList());
            if (jsonEntries.size() < 3) {
                ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName() + "\u5fc5\u987b\u5305\u542b\u81f3\u5c113\u4e2aJSON\u6587\u4ef6", 1, dir.getFileName().toString());
            }
            ZipEntry manifestEntry = null;
            ArrayList<ZipEntry> formTemplateEntry = new ArrayList<ZipEntry>();
            ArrayList<ZipEntry> listTemplateEntry = new ArrayList<ZipEntry>();
            ArrayList<ZipEntry> mobileFormTemplateEntry = new ArrayList<ZipEntry>();
            ArrayList<ZipEntry> mobileListTemplateEntry = new ArrayList<ZipEntry>();
            ArrayList<ZipEntry> slaveTemplateEntry = new ArrayList<ZipEntry>();
            boolean isSlave = false;
            String pageType = "";
            for (ZipEntry entry2 : jsonEntries) {
                String fileName = entry2.getName().replaceAll("/", "").replaceAll("\\\\", "");
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = mapper.readTree(zip.getInputStream(entry2));
                String templateType = "";
                if (HussarUtils.isNotEmpty((Object)jsonNode.get("templateType"))) {
                    templateType = jsonNode.get("templateType").asText();
                }
                if ("manifest.json".equals(fileName)) {
                    manifestEntry = entry2;
                    ModelPageTemplateUtil.validateManifest(zip.getInputStream(manifestEntry), mapper);
                    JsonNode root = mapper.readTree(zip.getInputStream(manifestEntry));
                    String value = root.get("functionType").asText().toLowerCase();
                    pageType = root.get("pageType").asText();
                    if (!value.contains("slave")) continue;
                    isSlave = true;
                    continue;
                }
                if ("formPage".equals(templateType)) {
                    formTemplateEntry.add(entry2);
                    ModelPageTemplateUtil.validateTemplate(zip.getInputStream(entry2), fileName, mapper);
                    continue;
                }
                if ("listPage".equals(templateType)) {
                    listTemplateEntry.add(entry2);
                    ModelPageTemplateUtil.validateTemplate(zip.getInputStream(entry2), fileName, mapper);
                    continue;
                }
                if ("mobileFormPage".equals(templateType)) {
                    mobileFormTemplateEntry.add(entry2);
                    ModelPageTemplateUtil.validateTemplate(zip.getInputStream(entry2), fileName, mapper);
                    continue;
                }
                if ("mobileListPage".equals(templateType)) {
                    mobileListTemplateEntry.add(entry2);
                    ModelPageTemplateUtil.validateTemplate(zip.getInputStream(entry2), fileName, mapper);
                    continue;
                }
                if (!fileName.toLowerCase().contains("slave")) continue;
                slaveTemplateEntry.add(entry2);
            }
            if ("WebPage".equals(pageType)) {
                if (HussarUtils.isEmpty(formTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u8868\u5355\u6a21\u677f\u6587\u4ef6formTemplate", 1, dir.getFileName().toString());
                } else if (formTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u8868\u5355\u6a21\u677f\u6587\u4ef6formTemplate", 1, dir.getFileName().toString());
                }
                if (HussarUtils.isEmpty(listTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u5217\u8868\u6a21\u677f\u6587\u4ef6listTemplate", 1, dir.getFileName().toString());
                } else if (listTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u5217\u8868\u6a21\u677f\u6587\u4ef6listTemplate", 1, dir.getFileName().toString());
                }
                if (isSlave && HussarUtils.isNotEmpty(slaveTemplateEntry) && slaveTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u5b50\u8868\u6587\u4ef6", 1, dir.getFileName().toString());
                }
            } else if ("UniPage".equals(pageType)) {
                if (HussarUtils.isEmpty(mobileFormTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u8868\u5355\u6a21\u677f\u6587\u4ef6mobileFormTemplate", 1, dir.getFileName().toString());
                } else if (mobileFormTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u8868\u5355\u6a21\u677f\u6587\u4ef6mobileFormTemplate", 1, dir.getFileName().toString());
                }
                if (HussarUtils.isEmpty(mobileListTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u5217\u8868\u6a21\u677f\u6587\u4ef6mobileListTemplate", 1, dir.getFileName().toString());
                } else if (mobileListTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u5217\u8868\u6a21\u677f\u6587\u4ef6mobileListTemplate", 1, dir.getFileName().toString());
                }
            } else {
                if (HussarUtils.isEmpty(formTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u8868\u5355\u6a21\u677f\u6587\u4ef6formTemplate", 1, dir.getFileName().toString());
                } else if (formTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u8868\u5355\u6a21\u677f\u6587\u4ef6formTemplate", 1, dir.getFileName().toString());
                }
                if (HussarUtils.isEmpty(listTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u5217\u8868\u6a21\u677f\u6587\u4ef6listTemplate", 1, dir.getFileName().toString());
                } else if (listTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u5217\u8868\u6a21\u677f\u6587\u4ef6listTemplate", 1, dir.getFileName().toString());
                }
                if (HussarUtils.isEmpty(mobileFormTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u8868\u5355\u6a21\u677f\u6587\u4ef6mobileFormTemplate", 1, dir.getFileName().toString());
                } else if (mobileFormTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u8868\u5355\u6a21\u677f\u6587\u4ef6mobileFormTemplate", 1, dir.getFileName().toString());
                }
                if (HussarUtils.isEmpty(mobileListTemplateEntry)) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u5217\u8868\u6a21\u677f\u6587\u4ef6mobileListTemplate", 1, dir.getFileName().toString());
                } else if (mobileListTemplateEntry.size() > 1) {
                    ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u5b58\u5728\u591a\u4e2a\u5217\u8868\u6a21\u677f\u6587\u4ef6mobileListTemplate", 1, dir.getFileName().toString());
                }
            }
            if (manifestEntry == null) {
                ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u6587\u4ef6manifest.json", 1, dir.getFileName().toString());
            }
            if (isSlave && HussarUtils.isEmpty(slaveTemplateEntry)) {
                ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u7f3a\u5c11\u5fc5\u8981\u7684\u5b50\u8868\u6587\u4ef6", 1, dir.getFileName().toString());
            }
        }
        catch (IOException | IllegalArgumentException e) {
            ModelPageTemplateUtil.checkInfo(checkResult, dir.getFileName().toString() + "\u6587\u4ef6\u5185" + e.getMessage(), 2, dir.getFileName().toString());
        }
    }

    public static void checkInfo(CheckResult<PageTemplateInductsInfo> checkResult, String checkInfo, int type, String templateName) {
        checkResult.setResult(-1);
        CheckInfo completeCheck = type == 1 ? new CheckInfo(templateName + "\u6587\u4ef6\u4e0d\u5b8c\u6574", -2) : new CheckInfo(templateName + "\u6587\u4ef6\u5185\u5bb9\u6821\u9a8c\u5931\u8d25", -2);
        completeCheck.addInfos(checkInfo, -1);
        checkResult.addCheckInfos(completeCheck);
    }
}

