/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.MicroAppInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ServerConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="MicroAppInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class MicroAppInfoServiceImpl
extends BaseFileServiceImpl<MicroAppInfo>
implements MicroAppInfoService {
    @Override
    public Boolean createProject(String toPath) throws IOException, LcdpException {
        String path = "mobile_ionic";
        File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        File microAppFolder = new File(toPath);
        if (!FileUtils.exists((File)microAppFolder)) {
            FileUtils.forceMkdir((File)microAppFolder);
        }
        if (FileUtils.isFile((File)jarFile)) {
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String name = jarEntry.getName();
                    if (!name.startsWith(path + "/") || "mobile_ionic/".equals(name)) continue;
                    String folderString = name.substring(12);
                    File toFile = new File(toPath + File.separator + folderString);
                    if (jarEntry.isDirectory()) {
                        if (FileUtils.exists((File)toFile)) continue;
                        FileUtils.forceMkdir((File)toFile);
                        continue;
                    }
                    try {
                        InputStream inputStream = this.getClass().getResourceAsStream("/" + name);
                        Throwable throwable = null;
                        try {
                            assert (inputStream != null);
                            FileUtils.copyForJar((byte[])FileUtils.convertInputStreamToByteArray((InputStream)inputStream), (String)toFile.getAbsolutePath());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            URL url = this.getClass().getResource("/" + path);
            if (url != null) {
                try {
                    File formFile = new File(url.toURI());
                    File toFile = new File(toPath);
                    for (File f : FileUtils.listFiles((File)formFile)) {
                        if (FileUtils.isDirectory((File)f)) {
                            FileUtils.copyDirectoryToDirectory((File)f, (File)toFile);
                            continue;
                        }
                        FileUtils.copyFileToDirectory((File)f, (File)toFile);
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.openFolder(toPath);
        return false;
    }

    private void installProject(String currPath) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        File file = new File(currPath + File.separator + "package.bat");
        ArrayList<String> cmdS = new ArrayList<String>();
        cmdS.add("cd " + currPath);
        cmdS.add("cnpm install");
        FileUtils.writeLines((File)file, (String)"utf-8", cmdS);
        Process child = Runtime.getRuntime().exec(currPath + File.separator + "\\package.bat");
        InputStream inputStream = child.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        inputStream.close();
    }

    private void openFolder(String currPath) throws IOException {
        if (System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1) {
            String[] cmd = new String[]{"cmd", "/c", "start", " ", currPath};
            Runtime.getRuntime().exec(cmd);
        }
    }

    @Override
    public List<String> getFolder(String path) throws LcdpException {
        ArrayList<String> folders = new ArrayList<String>();
        if (path == null || "/".equals(path) || "".equals(path)) {
            File[] roots = File.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                String folderPath = ToolUtil.pathFomatterByOS((String)roots[i].getPath());
                int lastIndexOf = folderPath.lastIndexOf(File.separator);
                folders.add(folderPath.substring(0, lastIndexOf));
            }
        } else {
            File file = new File(path);
            if (!FileUtils.exists((File)file)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FOLDER, path);
            }
            if (FileUtils.isDirectory((File)file)) {
                try {
                    for (File f : FileUtils.listFiles((File)file)) {
                        if (FileUtils.isHidden((File)f) || !FileUtils.isDirectory((File)f)) continue;
                        String folderPath = ToolUtil.pathFomatterByOS((String)f.getPath());
                        int lastIndexOf = folderPath.lastIndexOf(File.separator);
                        folders.add(folderPath.substring(lastIndexOf + 1, f.getPath().length()));
                    }
                }
                catch (Exception e) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_PERMISSION_DIRECTORY, e.getMessage());
                }
            }
        }
        return folders;
    }

    @Override
    public String getProjectPath() throws IOException {
        File directory = new File("");
        String courseFile = directory.getCanonicalPath();
        return courseFile;
    }

    private void copyForJar(InputStream fromFile, File toFile) throws IOException {
        byte[] b = new byte[1024];
        try (FileOutputStream fos = new FileOutputStream(toFile);){
            int a;
            while ((a = fromFile.read(b)) != -1) {
                fos.write(b, 0, a);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Boolean folderIsExist(String folderPath) {
        File file = new File(folderPath);
        if (FileUtils.exists((File)file) && file.list().length > 0) {
            return true;
        }
        return false;
    }

    private void createFolder(String folderPath) throws LcdpException, IOException {
        String OS = System.getProperty("os.name").toLowerCase();
        String[] path = folderPath.split("\\\\");
        String charPath = "";
        if (OS.indexOf("windows") >= 0) {
            for (int i = 0; i < path.length; ++i) {
                charPath = charPath + path[i] + File.separator;
                File file = new File(charPath);
                if (i == 0 && !FileUtils.exists((File)file)) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FOLDER, charPath + "\u76d8\u4e0d\u5b58\u5728");
                }
                if (FileUtils.exists((File)file) || i == 0) continue;
                FileUtils.forceMkdir((File)file);
            }
        } else {
            for (int i = 0; i < path.length; ++i) {
                File file = new File(charPath = charPath + path[i] + File.separator);
                if (FileUtils.exists((File)file) || i == 0) continue;
                FileUtils.forceMkdir((File)file);
            }
        }
    }

    @Override
    public List<MicroAppInfo> getMicroAppInfo() throws LcdpException {
        String path = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndCodePath();
        return this.getMicroAppInfos(path);
    }

    private List<MicroAppInfo> getMicroAppInfos(String path) throws LcdpException {
        ArrayList<MicroAppInfo> list = new ArrayList<MicroAppInfo>();
        File file = new File(ToolUtil.pathFomatterByOS((String)path));
        if (FileUtils.isDirectory((File)file)) {
            for (File f : FileUtils.listFiles((File)file)) {
                if (FileUtils.isDirectory((File)f)) {
                    String filepath = f.getAbsolutePath();
                    list.addAll(this.getMicroAppInfos(filepath));
                    continue;
                }
                MicroAppInfo microAppInfo = this.readMicroAppInfo(f);
                if (microAppInfo == null) continue;
                list.add(microAppInfo);
            }
        } else {
            MicroAppInfo microAppInfo = this.readMicroAppInfo(file);
            if (microAppInfo != null) {
                list.add(microAppInfo);
            }
        }
        return list;
    }

    private MicroAppInfo readMicroAppInfo(File file) throws LcdpException {
        MicroAppInfo microAppInfo = null;
        String[] name = file.getName().split("\\.");
        if (name.length == 3 && name[1].equals(".mad".replace(".", ""))) {
            try {
                File fileOfMeta = new File(ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()));
                String info = FileUtils.readFileToString((File)fileOfMeta, (String)"UTF-8");
                microAppInfo = (MicroAppInfo)((Object)JSON.parseObject((String)info, (Type)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0], (Feature[])new Feature[0]));
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, file.getAbsolutePath());
            }
        }
        return microAppInfo;
    }

    @Override
    public FormDesignResponse<Integer> getMaxPort(List<MicroAppInfo> microAppInfoList) {
        int maxPort = 8380;
        for (MicroAppInfo microAppInfo : microAppInfoList) {
            if (microAppInfo.getAppPort() == null) break;
            Integer port = microAppInfo.getAppPort();
            if (maxPort >= port) continue;
            maxPort = port;
        }
        if (maxPort != 8380) {
            ++maxPort;
        }
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        speedCodeResponse.setData((Object)maxPort);
        return speedCodeResponse;
    }

    @Override
    public void updateAppPort(MicroAppInfo microAppInfo) {
        String fileName = "vue.config.js";
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(microAppInfo.getProjectPath() + File.separator + fileName, "rw");){
            String line;
            long lastPoint = 0L;
            while ((line = randomAccessFile.readLine()) != null) {
                long point = randomAccessFile.getFilePointer();
                if (line.contains("port: 8082")) {
                    String str = line.replace("8082", microAppInfo.getAppPort() + "");
                    randomAccessFile.seek(lastPoint);
                    randomAccessFile.writeBytes(str);
                }
                lastPoint = point;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateServerPort(String projectPath) throws IOException {
        String serverAddress = ServerConfig.getUrl();
        File microDevelopEnv = new File(projectPath + "\\.env.development");
        File microProductionEnv = new File(projectPath + "\\.env.production");
        if (!FileUtils.exists((File)microDevelopEnv) || !FileUtils.exists((File)microProductionEnv)) {
            return;
        }
        List developStrS = FileUtils.readLines((File)microDevelopEnv, (String)"utf-8");
        List productionStrS = FileUtils.readLines((File)microProductionEnv, (String)"utf-8");
        for (String s : developStrS) {
            if (!s.contains("VUE_APP_HUSSAR_DEFAULT_API")) continue;
            developStrS.remove(s);
            developStrS.add(2, "VUE_APP_HUSSAR_DEFAULT_API='http://127.0.0.1:" + ServerConfig.serverPort + "'");
            break;
        }
        for (String s : productionStrS) {
            if (!s.contains("VUE_APP_URL_PREFIX")) continue;
            productionStrS.remove(s);
            productionStrS.add(1, "VUE_APP_URL_PREFIX='" + serverAddress + "'");
            break;
        }
        FileUtils.writeLines((File)microDevelopEnv, (Collection)developStrS);
        FileUtils.writeLines((File)microProductionEnv, (Collection)productionStrS);
    }
}

