/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl.ResourceCascadeCommonService;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotDataBaseStorage.class})
public class ResourceCascadeServiceImpl
extends ResourceCascadeCommonService
implements ResourceCascadeService {
    @Autowired
    private PathStrategyService pathStrategy;
    @Autowired
    private FileMappingService fileMappingService;

    public void deleteModelPublishFile(String id) throws LcdpException {
        File publishFile = new File(this.getPublishFilePathById());
        if (FileUtils.exists((File)publishFile)) {
            for (File f : Objects.requireNonNull(FileUtils.listFiles((File)publishFile))) {
                if (!f.getName().contains(id.replace("_", "/"))) continue;
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
                }
            }
        }
    }

    public void deleteVuePublishFile(String id) throws IOException {
        String publishPath = FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/")});
        if (FileUtils.exists((File)new File(publishPath))) {
            FileUtils.forceDelete((File)new File(publishPath));
        }
    }

    public JSONObject getJSONObject(String id) throws IOException, LcdpException {
        String path = this.getMetaPath(id);
        File file = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), path + ".meta"}));
        return JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
    }

    public void deleteWorkFlowPublishFile(String id) throws IOException {
        String publishPath = FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/") + "hussar"});
        if (FileUtils.exists((File)new File(publishPath))) {
            FileUtils.forceDelete((File)new File(publishPath));
        }
    }

    public void deleteModulePublishFile(String id) throws IOException {
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

