/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.publishrecord.model.SysPublishRecord;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl.BaseFileDataBaseServiceImpl;
import com.jxdinfo.hussar.formdesign.preview.service.PagePreviewService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class PageInfoDataBaseServiceImpl
extends BaseFileDataBaseServiceImpl<PageInfo>
implements PageInfoService {
    @Resource
    private FormDesignProperties formDesignProperties;
    @Autowired
    public ISysPublishRecordService sysPublishRecordService;
    @Autowired
    public PagePreviewService pagePreviewService;

    @Override
    public PageInfoNode getPageInfoNodeFromPageToRoot(String id) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)this.get(id);
        String cnName = pageInfo.getDesc();
        String enName = pageInfo.getName();
        boolean isPage = "WebPage".equals(pageInfo.getType());
        PageInfoNode pageInfoNode = new PageInfoNode(enName, cnName, isPage, pageInfo.getId());
        String parentId = pageInfo.getParentId();
        if (ToolUtil.isNotEmpty((Object)parentId) && !"#".equals(parentId)) {
            pageInfoNode.parent = this.getPageInfoNodeFromPageToRoot(parentId);
            pageInfoNode.parent.child = pageInfoNode;
        }
        return pageInfoNode;
    }

    @Override
    public String getWebUrl(String pageId) {
        String url;
        String path = this.pagePreviewService.getPreviewPath(pageId);
        if (path == null) {
            url = null;
        } else {
            String devUser = VfgModeTool.isModularization() ? String.format("?tcode=%s&dev_user=%s&isResetRouter=true", BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getId()) : "?isResetRouter=true";
            PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
            url = String.format("%s%s%s", this.formDesignProperties.getWebUrl(), FileUtil.posixPath((String[])new String[]{"#", pathStrategy.vuePathService().prefix(), path}), devUser);
        }
        return url;
    }

    @Override
    public String getMobileUrl(String pageId) throws LcdpException {
        String url = this.formDesignProperties.getMobileUrl();
        String path = this.fileMappingService.getFormatPath(pageId);
        if (path != null && url != null) {
            String devUser = VfgModeTool.isModularization() ? String.format("?tcode=%s&dev_user=%s&isResetRouter=true", BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getId()) : "?isResetRouter=true";
            PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
            url = String.format("%s%s%s", url, FileUtil.posixPath((String[])new String[]{"#", pathStrategy.vuePathService().prefix(), path}), devUser);
        }
        return url;
    }

    @Override
    public Map<String, Object> getAllReferencesAndErrorsList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> refMap = new HashMap<String, Object>();
        HashMap errorMap = new HashMap();
        List allFiles = this.sysMidFileCodeService.getAllFiles();
        this.iteratorCodeFile("#", refMap, allFiles);
        map.put("references", refMap);
        map.put("crossReferErrors", errorMap);
        return map;
    }

    @Override
    public List<String> getPageState(List<String> ids) {
        ArrayList<String> idList = new ArrayList<String>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty(ids)) {
            wrapper.in(SysPublishRecord::getSourceId, new Object[0]);
        }
        List publishRecords = this.sysPublishRecordService.list(wrapper);
        ArrayList<String> functionList = new ArrayList<String>();
        HashSet<String> moduleList = new HashSet<String>();
        HashSet<String> bpmList = new HashSet<String>();
        HashSet<String> secondScriptList = new HashSet<String>();
        for (SysPublishRecord publishRecord : publishRecords) {
            if ("0".equals(publishRecord.getSourceType())) {
                idList.add(publishRecord.getSourceId());
                continue;
            }
            functionList.add(publishRecord.getSourceId());
        }
        List allFiles = this.sysMidFileCodeService.getAllFiles();
        this.iteratorFileGetModuleId("#", functionList, moduleList, bpmList, secondScriptList, allFiles);
        if (ToolUtil.isNotEmpty(ids)) {
            ArrayList<String> moduleIds = new ArrayList<String>(moduleList);
            block1: for (String string : ids) {
                for (String string2 : moduleIds) {
                    if (!string.equals(string2)) continue;
                    idList.add(string2);
                    continue block1;
                }
            }
            ArrayList<String> bpmIds = new ArrayList<String>(bpmList);
            block3: for (String id : ids) {
                for (String bpmId : bpmIds) {
                    if (!id.equals(bpmId)) continue;
                    idList.add(bpmId);
                    continue block3;
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>(secondScriptList);
            block5: for (String string : ids) {
                for (String s : arrayList) {
                    if (!string.equals(s)) continue;
                    idList.add(s);
                    continue block5;
                }
            }
        } else {
            idList.addAll(new ArrayList<String>(moduleList));
            idList.addAll(new ArrayList<String>(bpmList));
            idList.addAll(new ArrayList<String>(secondScriptList));
        }
        return idList;
    }

    private void iteratorFileGetModuleId(String parentId, List<String> functionList, Set<String> moduleList, Set<String> bpmList, Set<String> secondScriptList, List<SysMidFileCode> allFiles) {
        List childFiles = allFiles.stream().filter(file -> HussarUtils.equals((Object)file.getParentId(), (Object)parentId)).collect(Collectors.toList());
        for (SysMidFileCode childFile : childFiles) {
            List grandChildFiles;
            boolean isPublish;
            JSONObject jsonObject;
            String fileName = this.fileDataBaseHelper.getFileName(childFile);
            if (fileName.endsWith(".dbd")) {
                jsonObject = JSON.parseObject((String)childFile.getData());
                JSONArray operationsArray = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"operations")));
                for (Object o : operationsArray) {
                    JSONObject operation = (JSONObject)o;
                    for (String s : functionList) {
                        if (!operation.get((Object)"id").equals(s)) continue;
                        String id = jsonObject.get((Object)"id").toString();
                        moduleList.add(id);
                        return;
                    }
                }
            } else if (fileName.contains(".dbd") && fileName.endsWith(".meta")) {
                boolean isPublish2;
                jsonObject = JSON.parseObject((String)childFile.getData());
                if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)"isPublished")) && ToolUtil.isNotEmpty((Object)(isPublish2 = ((Boolean)jsonObject.get((Object)"isPublished")).booleanValue())) && isPublish2) {
                    moduleList.add(jsonObject.get((Object)"id").toString());
                }
            } else if (fileName.startsWith("bpm_") && fileName.endsWith(".meta")) {
                jsonObject = JSON.parseObject((String)childFile.getData());
                Object version = jsonObject.get((Object)"version");
                if (ToolUtil.isNotEmpty((Object)version)) {
                    bpmList.add(jsonObject.get((Object)"id").toString());
                }
            } else if ((fileName.contains(".jsd") || fileName.contains(".cpd") || fileName.contains(".mjsd") || fileName.contains(".mcpd") || fileName.contains(".ujsd") || fileName.contains(".ucpd") || fileName.contains(".csd") || fileName.contains(".ucsd") || fileName.contains(".mcsd")) && fileName.endsWith(".meta") && ToolUtil.isNotEmpty((Object)(jsonObject = JSON.parseObject((String)childFile.getData())).get((Object)"isPublished")) && ToolUtil.isNotEmpty((Object)(isPublish = ((Boolean)jsonObject.get((Object)"isPublished")).booleanValue())) && isPublish) {
                secondScriptList.add(jsonObject.get((Object)"id").toString());
            }
            if (!HussarUtils.isNotEmpty(grandChildFiles = allFiles.stream().filter(file -> HussarUtils.equals((Object)file.getParentId(), (Object)childFile.getFileId())).collect(Collectors.toList()))) continue;
            this.iteratorFileGetModuleId(childFile.getFileId(), functionList, moduleList, bpmList, secondScriptList, allFiles);
        }
    }

    private void iteratorCodeFile(String parentId, Map<String, Object> refMap, List<SysMidFileCode> allFiles) {
        List<SysMidFileCode> childFiles = this.getChildFiles(allFiles, parentId);
        for (SysMidFileCode childFile : childFiles) {
            List<SysMidFileCode> grandChildFiles;
            JSONObject jsonObject = JSON.parseObject((String)childFile.getData());
            JSONArray referArray = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"references")));
            if (ToolUtil.isNotEmpty((Object)referArray)) {
                JSONObject o = (JSONObject)referArray.get(0);
                String id = o.get((Object)"referPath").toString().split("\\.")[0];
                refMap.put(id, referArray);
            }
            if (!HussarUtils.isNotEmpty(grandChildFiles = this.getChildFiles(allFiles, childFile.getFileId()))) continue;
            this.iteratorCodeFile(childFile.getFileId(), refMap, allFiles);
        }
    }

    private List<SysMidFileCode> getChildFiles(List<SysMidFileCode> allFiles, String parentId) {
        return allFiles.stream().filter(file -> HussarUtils.equals((Object)file.getParentId(), (Object)parentId)).collect(Collectors.toList());
    }
}

