/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.util;

import com.jxdinfo.hussar.formdesign.extend.constant.FormulaTypeEnum;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaDefineMethodVO;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaDefinedVO;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaType;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FormulaExcelUtil {
    public List<ExtendFormulaDefinedVO> readExcel() throws IOException {
        Sheet sheet = this.getSheet();
        if (sheet == null) {
            return null;
        }
        if (sheet.getLastRowNum() < 2) {
            return null;
        }
        List<ExtendFormulaDefinedVO> list = this.getFormulaType();
        block0: for (int i = sheet.getFirstRowNum() + 2; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = 0; j <= list.size(); ++j) {
                if (!row.getCell(1).getStringCellValue().equals(list.get(j).getTypeName())) continue;
                list.get(j).getMethods().add(this.getDefinedMethod(row));
                continue block0;
            }
        }
        return list;
    }

    public List<ExtendFormulaType> readTypePath() throws IOException {
        ArrayList<ExtendFormulaType> list = new ArrayList<ExtendFormulaType>();
        Sheet sheet = this.getSheet();
        if (sheet == null) {
            return null;
        }
        if (sheet.getLastRowNum() < 2) {
            return null;
        }
        for (int c = 8; c < sheet.getRow(1).getPhysicalNumberOfCells(); ++c) {
            String pageType = sheet.getRow(1).getCell(c).getStringCellValue();
            for (int r = sheet.getFirstRowNum() + 2; r <= sheet.getLastRowNum(); ++r) {
                sheet.getRow(r).getCell(2).setCellType(CellType.STRING);
                String methods = sheet.getRow(r).getCell(2).getStringCellValue();
                String path = sheet.getRow(r).getCell(c).getStringCellValue();
                ExtendFormulaType formulaType = new ExtendFormulaType();
                formulaType.setPageType(pageType);
                formulaType.setMethods(methods);
                formulaType.setPath(path);
                list.add(formulaType);
            }
        }
        return list;
    }

    public Sheet getSheet() throws IOException {
        FileInputStream inputStream;
        String excelPath = "/formula/formula-defined.xlsx";
        InputStream in = this.getClass().getResourceAsStream(excelPath);
        File file = File.createTempFile("tmp", ".xlsx");
        try (OutputStream output = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);){
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            bufferedOutput.write(bytes);
            inputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException();
        }
        file.deleteOnExit();
        Workbook wb = this.getWorkbook(excelPath, inputStream);
        if (wb == null) {
            return null;
        }
        return wb.getSheetAt(0);
    }

    private Workbook getWorkbook(String excelPath, FileInputStream inputStream) {
        XSSFWorkbook wb = null;
        try {
            if (excelPath.indexOf(".xlsx") > 0) {
                wb = new XSSFWorkbook((InputStream)inputStream);
            } else if (excelPath.indexOf(".xls") > 0) {
                wb = new HSSFWorkbook((InputStream)inputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return wb;
    }

    private List<ExtendFormulaDefinedVO> getFormulaType() {
        FormulaTypeEnum[] typeEnums;
        ArrayList<ExtendFormulaDefinedVO> definedVOS = new ArrayList<ExtendFormulaDefinedVO>();
        for (FormulaTypeEnum typeEnum : typeEnums = FormulaTypeEnum.values()) {
            ExtendFormulaDefinedVO definedVO = new ExtendFormulaDefinedVO();
            definedVO.setTypeName(typeEnum.getName());
            definedVO.setType(typeEnum.getCode());
            definedVO.setMethods(new ArrayList<ExtendFormulaDefineMethodVO>());
            definedVOS.add(definedVO);
        }
        return definedVOS;
    }

    private ExtendFormulaDefineMethodVO getDefinedMethod(Row row) {
        ExtendFormulaDefineMethodVO methodVO = new ExtendFormulaDefineMethodVO();
        try {
            row.getCell(2).setCellType(CellType.STRING);
            methodVO.setMethod(row.getCell(2).getStringCellValue());
            methodVO.setName(row.getCell(3).getStringCellValue());
            row.getCell(4).setCellType(CellType.STRING);
            methodVO.setReturnType(row.getCell(4).getStringCellValue());
            methodVO.setDesc(row.getCell(5).getStringCellValue());
            methodVO.setUsage(row.getCell(6).getStringCellValue());
            methodVO.setExample(row.getCell(7).getStringCellValue());
            methodVO.setPath(row.getCell(8).getStringCellValue());
            methodVO.setMobilePath(row.getCell(9).getStringCellValue());
            methodVO.setMobileUniPath(row.getCell(10).getStringCellValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException("\u89e3\u6790\u5931\u8d25");
        }
        return methodVO;
    }
}

